---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：5-Executorプロセス管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **maxDirectResultSizeのデフォルト値1MB**：設定ファイルでの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/executor/Executor.scala` 61-100行目 - IsolatedSessionState
- E-02: `core/src/main/scala/org/apache/spark/executor/Executor.scala` - launchTask, TaskRunner
- E-03: `core/src/main/scala/org/apache/spark/executor/CoarseGrainedExecutorBackend.scala` - RPCバックエンド
- E-04: `core/src/main/scala/org/apache/spark/executor/TaskMetrics.scala` - メトリクス定義
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 6行目 - 機能定義
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面関連
- E-07: `core/src/main/scala/org/apache/spark/SparkContext.scala` 755-776行目 - getExecutorThreadDump
- E-08: `core/src/main/scala/org/apache/spark/SparkContext.scala` 787-808行目 - getExecutorHeapHistogram

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Executorはワーカーノード上でタスクを実行するプロセス | E-05 | ○ |
| C-02 | IsolatedSessionStateによるセッション分離 | E-01 | ○ |
| C-03 | launchTaskでタスクを受信しTaskRunnerで実行 | E-02 | ○ |
| C-04 | CoarseGrainedExecutorBackendがRPC通信を担当 | E-03 | ○ |
| C-05 | タスクメトリクス（executorRunTime等）の収集 | E-04 | ○ |
| C-06 | SparkContext.getExecutorThreadDumpでスレッドダンプ取得 | E-07 | ○ |
| C-07 | SparkContext.getExecutorHeapHistogramでヒープ情報取得 | E-08 | ○ |
| C-08 | 結果サイズに応じてDirect/Indirectで送信 | E-02 | ○ |
| C-09 | ハートビートの定期送信 | E-02 | ○ |
| C-10 | 画面1,2,6,8,10,11,12,25,28との関連 | E-06 | ○ |
| C-11 | FetchFailedExceptionの処理 | E-02 | ○ |
| C-12 | セッション状態遷移（Created→Active→Idle→Evicted） | E-01 | ○ |
| C-13 | ローカルモードではドライバーと同一JVMで実行 | E-05 | ○ |
| C-14 | タスクデシリアライズ時間のメトリクス追跡 | E-04 | ○ |
| C-15 | maxDirectResultSizeのデフォルト値は1MB | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-15: maxDirectResultSizeのデフォルト値はconfigパッケージで確認が必要
  - 候補：`internal/config/package.scala` / Executor.scala内の参照

## 5) リスクフラグ（レビュー観点）
- 0: Executorの基本設計 - ソースコードから直接確認済み
- 0: IsolatedSessionStateの状態遷移 - Scaladocの状態遷移図から確認済み
- 1: 設定パラメータのデフォルト値 - configパッケージの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] TaskRunner.run()の処理フローが最新コードと一致しているか
- [ ] IsolatedSessionStateの状態遷移が正確か
- [ ] maxDirectResultSizeのデフォルト値が正確か
- [ ] 画面関連マッピングが画面機能マッピング.csvと一致しているか
