---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：50-因子分解マシン分類

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **train()メソッドの詳細実装**：150行目以降のFactorizationMachines.trainImpl()呼び出し

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/classification/FMClassifier.scala` (1-150行目)
- E-02: `docs/code-to-docs/機能一覧/機能一覧.csv` 行51

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ProbabilisticClassifierを継承 | E-01 (77行目) | ○ |
| C-02 | FactorizationMachinesトレイトを使用 | E-01 (78行目) | ○ |
| C-03 | FMClassifierParamsはProbabilisticClassifierParams + FactorizationMachinesParams | E-01 (40-42行目) | ○ |
| C-04 | FM式のScaladoc記述 | E-01 (49-63行目) | ○ |
| C-05 | ロジスティック損失を使用 | E-01 (68-69行目, Scaladoc) | ○ |
| C-06 | 二値分類のみサポート | E-01 (71行目, Scaladoc) | ○ |
| C-07 | Spark 3.0.0で追加 | E-01 (74行目, @Since) | ○ |
| C-08 | デフォルトUID "fmc" | E-01 (81行目) | ○ |
| C-09 | setFactorSize | E-01 (90行目) | ○ |
| C-10 | setFitIntercept | E-01 (99行目) | ○ |
| C-11 | setFitLinear | E-01 (108行目) | ○ |
| C-12 | setRegParam | E-01 (117行目) | ○ |
| C-13 | setMiniBatchFraction | E-01 (126行目) | ○ |
| C-14 | setInitStd | E-01 (135行目) | ○ |
| C-15 | 機能一覧にFM分類として定義 | E-02 | ○ |
| C-16 | train()内のFactorizationMachines.trainImpl()詳細 | **根拠不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: train()メソッドの本体（150行目以降）とFactorizationMachines.trainImpl()の詳細実装が読み込み範囲外
  - 候補：FMClassifier.scala全文 / FactorizationMachines.scala

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - train()の詳細実装は部分的にしか確認できていない
- 0: 低リスク - パラメータ定義とFM数式の仕様は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] train()メソッドのFactorizationMachines.trainImpl()呼び出しが正確か確認
- [ ] FM相互作用項の効率的計算（O(kn)）の実装が正しいか確認
- [ ] AdamWソルバーの実装が正しいか確認
- [ ] ロジスティック損失の勾配計算が正確か確認
