---
generated_at: 2026-02-04 10:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：52-線形回帰

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **MAX_FEATURES_FOR_NORMAL_SOLVERの具体的な値**：WeightedLeastSquares側の定義要確認

## 2) 参照した情報（Evidence一覧）
- E-01: `LinearRegression.scala` 58-128行目（パラメータ定義）
- E-02: `LinearRegression.scala` 329-438行目（train()メソッド）
- E-03: `LinearRegression.scala` 440-465行目（trainWithNormal）
- E-04: `LinearRegression.scala` 494-527行目（createOptimizer）
- E-05: `LinearRegression.scala` 529-610行目（trainImpl）
- E-06: `LinearRegression.scala` 612-644行目（createModel）
- E-07: `LinearRegression.scala` 698-832行目（LinearRegressionModel）
- E-08: `LinearRegression.scala` 996-1162行目（LinearRegressionSummary）
- E-09: `LinearRegression.scala` 130-182行目（Scaladoc）
- E-10: `LinearRegression.scala` 658-692行目（コンパニオンオブジェクト）
- E-11: `機能一覧.csv` No.52行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | L1/L2/ElasticNet正則化に対応 | E-01, E-09 | ○ |
| C-02 | squaredErrorとhuberの2種類の損失関数を選択可能 | E-01（86-88行目）, E-10 | ○ |
| C-03 | ソルバーはauto/normal/l-bfgsの3種類 | E-10（682行目） | ○ |
| C-04 | Huber損失はnormalソルバーをサポートしない | E-01（119-121行目） | ○ |
| C-05 | Huber損失はL2正則化のみ | E-01（122-123行目） | ○ |
| C-06 | auto時に特徴量数で自動ソルバー選択 | E-02（353-356行目） | ○ |
| C-07 | normalソルバーは1パスで完了 | E-03 | ○ |
| C-08 | ブロック化によるGEMV最適化（Spark 3.1.0以降） | E-05, E-09（180-182行目） | ○ |
| C-09 | 予測はdot(features, coefficients) + intercept | E-07（752-753行目） | ○ |
| C-10 | PMML形式でのエクスポートに対応 | E-10（876-894行目） | ○ |
| C-11 | normalソルバー使用時のみt値・p値が利用可能 | E-08（1109-1161行目） | ○ |
| C-12 | R^2, adjR^2, RMSE, MAEの計算 | E-08（1025-1066行目） | ○ |
| C-13 | デフォルトブロックサイズは1MB | E-05（550-553行目） | ○ |
| C-14 | epsilonのデフォルト値は1.35 | E-01（110-112行目） | ○ |
| C-15 | Spark 1.3.0で導入 | E-07（@Since("1.3.0")） | ○ |
| C-16 | MAX_FEATURES_FOR_NORMAL_SOLVERの具体的な値 | **要WeightedLeastSquares参照** | △ |

## 4) 不足情報（Unknown / Missing）
- C-16: MAX_FEATURES_FOR_NORMAL_SOLVERの具体値はWeightedLeastSquares.MAX_NUM_FEATURESから参照される（670行目）が、その具体値はWeightedLeastSquares.scalaに定義されているため追加確認が必要
  - 候補: WeightedLeastSquares.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コードから直接確認可能な主張が大半

## 6) レビュアーチェックリスト（最小）
- [ ] Huber損失使用時の制約がドキュメントに正確に記載されているか
- [ ] normalソルバーの特徴量数制限値が正しいか
- [ ] サマリー統計量（t値、p値）の計算式が数学的に正しいか
