---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：55-勾配ブースティング木回帰

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `GBTRegressor.scala` 39-55行目（Scaladoc - Stochastic Gradient Boosting）
- E-02: `GBTRegressor.scala` 115-118行目（setImpurity - 警告のみ）
- E-03: `GBTRegressor.scala` 167-198行目（train()メソッド）
- E-04: `GBTRegressor.scala` 207-209行目（supportedLossTypes）
- E-05: `GBTRegressor.scala` 222-234行目（GBTRegressionModel require）
- E-06: `GBTRegressor.scala` 302-306行目（predict - BLAS.ddot）
- E-07: `GBTRegressor.scala` 331-332行目（featureImportances）
- E-08: `GBTRegressor.scala` 346-350行目（evaluateEachIteration）
- E-09: `GBTRegressor.scala` 168-174行目（検証データ分割）
- E-10: `機能一覧.csv` No.55行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Stochastic Gradient Boostingの実装 | E-01 | ○ |
| C-02 | 不純度設定は無視される | E-02 | ○ |
| C-03 | 損失関数はsquaredとabsolute | E-04 | ○ |
| C-04 | 検証データセットによる早期停止 | E-09, E-03 | ○ |
| C-05 | 1つ以上の木が必要 | E-05 | ○ |
| C-06 | 木と重みの配列長一致が必要 | E-05 | ○ |
| C-07 | 予測はBLAS.ddotによる重み付き合計 | E-06 | ○ |
| C-08 | 特徴量重要度はperTreeNormalization=false | E-07 | ○ |
| C-09 | evaluateEachIterationで各ステップの損失取得可能 | E-08 | ○ |
| C-10 | J.H. Friedman 1999に基づく | E-01（44行目） | ○ |
| C-11 | Spark 1.4.0で導入 | @Since("1.4.0") | ○ |
| C-12 | TreeBoostではなくStochastic Gradient Boosting | E-01（46-51行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 早期停止のvalidationTolパラメータの動作が正しいか
- [ ] evaluateEachIterationの損失計算が正しいか
