---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：56-一般化線形回帰

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **IRLS最適化の内部処理詳細**：ファイルの全行を読み切れていないため、IRLS内部の重み・作業応答変数計算の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `GeneralizedLinearRegression.scala` 49-51行目（GeneralizedLinearRegressionBase）
- E-02: `GeneralizedLinearRegression.scala` 56-67行目（familyパラメータ）
- E-03: `GeneralizedLinearRegression.scala` 96-109行目（linkパラメータ）
- E-04: `GeneralizedLinearRegression.scala` 186-188行目（デフォルト値設定）
- E-05: `GeneralizedLinearRegression.scala` 231-246行目（Scaladoc: サポートFamily/Link）
- E-06: `GeneralizedLinearRegression.scala` 380-399行目（train()メソッド先頭部）
- E-07: `GeneralizedLinearRegression.scala` 190-228行目（validateAndTransformSchema）
- E-08: `GeneralizedLinearRegression.scala` 74-90行目（variancePower for Tweedie）
- E-09: `GeneralizedLinearRegression.scala` 147-158行目（offsetCol）
- E-10: `機能一覧.csv` No.56行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | gaussian/binomial/poisson/gamma/tweedieのファミリーをサポート | E-02 | ○ |
| C-02 | identity/log/inverse/logit/probit/cloglog/sqrtのリンクをサポート | E-03 | ○ |
| C-03 | tweedieファミリー時はlinkPowerを使用 | E-07（194-198行目） | ○ |
| C-04 | デフォルトファミリーはgaussian | E-04 | ○ |
| C-05 | デフォルトソルバーはirls | E-04 | ○ |
| C-06 | デフォルトmaxIterは25 | E-04 | ○ |
| C-07 | 特徴量数制限あり | E-06（392-396行目） | ○ |
| C-08 | オフセット項のサポート | E-09 | ○ |
| C-09 | 重み付きサンプルのサポート | E-01（50行目 HasWeightCol） | ○ |
| C-10 | variancePowerは0 or [1, Inf) | E-08 | ○ |
| C-11 | サポートされるファミリー・リンク組み合わせのバリデーション | E-07（207-212行目） | ○ |
| C-12 | Spark 2.0.0で導入 | @Since("2.0.0") | ○ |
| C-13 | L2正則化対応（regParam） | E-04, E-01 | ○ |
| C-14 | IRLS各反復でWLS問題を解く | **コード後半部読み切り不足** | △ |

## 4) 不足情報（Unknown / Missing）
- C-14: GeneralizedLinearRegression.scalaは非常に長いファイル（1000行以上）であり、IRLS最適化の詳細実装（train()メソッド後半部分）の全行確認が必要
  - 候補: GeneralizedLinearRegression.scala 400-600行目付近

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - IRLS最適化の内部処理の正確性はファイル後半の読み込みで確認すべき

## 6) レビュアーチェックリスト（最小）
- [ ] ファミリー・リンク組み合わせの表が正しいか
- [ ] IRLS最適化の詳細処理が正確に記述されているか
- [ ] AIC計算の正確性
