---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 13
  claims_with_evidence: 12
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：57-AFT生存回帰

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：12 / 13、根拠なし：1
- 優先レビュー（高）
  1. **分位数予測の計算式**：AFTSurvivalRegressionModelのtransform後半部の詳細確認が必要

## 2) 参照した情報（Evidence一覧）
- E-01: `AFTSurvivalRegression.scala` 51-98行目（パラメータ定義）
- E-02: `AFTSurvivalRegression.scala` 128-137行目（Scaladoc）
- E-03: `AFTSurvivalRegression.scala` 202-284行目（train()メソッド）
- E-04: `AFTSurvivalRegression.scala` 215-221行目（censorバリデーション）
- E-05: `AFTSurvivalRegression.scala` 223-231行目（Instance構築、weightにcensor格納）
- E-06: `AFTSurvivalRegression.scala` 260行目（BreezeLBFGSオプティマイザ）
- E-07: `AFTSurvivalRegression.scala` 268行目（初期解: numFeatures+2次元）
- E-08: `AFTSurvivalRegression.scala` 278-284行目（係数・切片・スケール抽出）
- E-09: `AFTSurvivalRegression.scala` 287-345行目（trainImpl）
- E-10: `AFTSurvivalRegression.scala` 376-382行目（AFTSurvivalRegressionModel）
- E-11: `機能一覧.csv` No.57行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Weibull分布に基づくパラメトリックモデル | E-02（132行目） | ○ |
| C-02 | 打ち切りフラグは0/1のみ | E-04 | ○ |
| C-03 | L-BFGS最適化を使用 | E-06 | ○ |
| C-04 | パラメータ構造は[coefficients, intercept, log(sigma)] | E-07, E-08 | ○ |
| C-05 | Instance.weightにcensorを格納 | E-05（229行目コメント） | ○ |
| C-06 | 特徴量標準化を実施 | E-09（300-303行目） | ○ |
| C-07 | ブロック化によるGEMV最適化 | E-09（305-308行目） | ○ |
| C-08 | デフォルトcensorCol="censor" | E-01（95行目） | ○ |
| C-09 | デフォルトmaxIter=100 | E-01（97行目） | ○ |
| C-10 | Spark 1.6.0で導入 | @Since("1.6.0") | ○ |
| C-11 | R survival::survregとの差異 | E-09（255-258行目コメント） | ○ |
| C-12 | 予測式: exp(Xw + b) | E-10 | ○ |
| C-13 | 分位数予測: prediction * (-log(1-p))^scale | **Model後半部要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- C-13: AFTSurvivalRegressionModelの分位数予測処理はtransformメソッド内にあり、ファイル後半部（400行目以降）の確認が必要
  - 候補: AFTSurvivalRegression.scala 400-500行目付近

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要処理はtrain()メソッドから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 分位数計算式がWeibull分布の数学的定義と整合しているか
- [ ] 打ち切りデータの尤度関数が正しく実装されているか
- [ ] fitIntercept=false時の定数非ゼロ列の扱いが適切か
