---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-Factorization-Machines回帰

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）
- E-01: `FMRegressor.scala` 51-122行目（FactorizationMachinesParams）
- E-02: `FMRegressor.scala` 119-121行目（デフォルト値設定）
- E-03: `FMRegressor.scala` 126-134行目（initCoefficients）
- E-04: `FMRegressor.scala` 136-159行目（trainImpl）
- E-05: `FMRegressor.scala` 162-267行目（FactorizationMachinesオブジェクト）
- E-06: `FMRegressor.scala` 208-231行目（splitCoefficients）
- E-07: `FMRegressor.scala` 247-266行目（getRawPrediction）
- E-08: `FMRegressor.scala` 411-441行目（FMRegressor.train）
- E-09: `FMRegressor.scala` 612-720行目（BaseFactorizationMachinesGradient）
- E-10: `FMRegressor.scala` 781-803行目（MSEFactorizationMachinesGradient）
- E-11: `FMRegressor.scala` 818-853行目（AdamWUpdater）
- E-12: `FMRegressor.scala` 276-301行目（Scaladoc - FM formula）
- E-13: `機能一覧.csv` No.58行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | FM予測式: w0 + sum(wi*xi) + sum_pairs | E-12, E-07 | ○ |
| C-02 | ペアワイズ交互作用のO(kn)計算 | E-07（254-262行目） | ○ |
| C-03 | デフォルトfactorSize=8 | E-02 | ○ |
| C-04 | デフォルトsolver=adamW | E-02 | ○ |
| C-05 | GDとAdamWの2つのソルバー | E-05（170-171行目） | ○ |
| C-06 | 正規乱数による初期化 | E-03 | ○ |
| C-07 | 係数構造: factors(k*n) + linear(n) + intercept(1) | E-06 | ○ |
| C-08 | MSE損失の乗数: 2*(prediction - label) | E-10（797行目） | ○ |
| C-09 | AdamWのハイパーパラメータ: beta1=0.9, beta2=0.999, eps=1e-8 | E-11（819-821行目） | ○ |
| C-10 | スパースベクトル専用勾配計算パス | E-09（671-699行目） | ○ |
| C-11 | Rendle 2010に基づく | E-12（Scaladoc） | ○ |
| C-12 | Loshchilov & Hutter 2019に基づくAdamW | E-11（Scaladoc） | ○ |
| C-13 | Spark 3.0.0で導入 | @Since("3.0.0") | ○ |
| C-14 | miniBatchFractionでデータ使用量を制御 | E-04（155行目） | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てソースコードから直接確認

## 6) レビュアーチェックリスト（最小）
- [ ] FM予測式の数学的正確性
- [ ] AdamWのweight decay実装がオリジナル論文と整合しているか
- [ ] スパースベクトル最適化パスの正確性
