---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：61-二分K-Meansクラスタリング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件の詳細**：具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/clustering/BisectingKMeans.scala` BisectingKMeansParamsトレイト（44-86行目）
- E-02: `mllib/src/main/scala/org/apache/spark/ml/clustering/BisectingKMeans.scala` BisectingKMeansクラス（238-329行目）
- E-03: `mllib/src/main/scala/org/apache/spark/ml/clustering/BisectingKMeans.scala` BisectingKMeansModelクラス（93-187行目）
- E-04: `mllib/src/main/scala/org/apache/spark/ml/clustering/BisectingKMeans.scala` BisectingKMeansSummaryクラス（340-360行目）
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` No.61の定義
- E-06: `mllib/src/main/scala/org/apache/spark/ml/clustering/BisectingKMeans.scala` ScalaDocコメント（224-237行目）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | kのデフォルト値は4 | E-01（75行目: `k -> 4`） | ○ |
| C-02 | maxIterのデフォルト値は20 | E-01（75行目: `maxIter -> 20`） | ○ |
| C-03 | minDivisibleClusterSizeのデフォルト値は1.0 | E-01（75行目: `minDivisibleClusterSize -> 1.0`） | ○ |
| C-04 | kは1より大きい必要がある | E-01（55行目: `ParamValidators.gt(1)`） | ○ |
| C-05 | fit()でMLlibBisectingKMeansに委譲 | E-02（296-310行目） | ○ |
| C-06 | transform()でUDFによる予測 | E-03（121-127行目） | ○ |
| C-07 | clusterCentersを返す | E-03（143行目） | ○ |
| C-08 | computeCostは3.0.0で非推奨 | E-03（157-159行目: `@deprecated`） | ○ |
| C-09 | モデルはMLWritableで永続化可能 | E-03（167行目: `override def write: MLWriter`） | ○ |
| C-10 | summaryにtrainingCostが含まれる | E-04（358行目: `val trainingCost: Double`） | ○ |
| C-11 | 階層的二分割アプローチのアルゴリズム説明 | E-06（ScalaDocコメント） | ○ |
| C-12 | 同レベルの分割はグループ化して並列実行 | E-06（230行目） | ○ |
| C-13 | 大きいクラスタが分割優先される | E-06（232行目） | ○ |
| C-14 | distanceMeasureパラメータをサポート | E-02（275行目: `setDistanceMeasure`） | ○ |
| C-15 | weightColパラメータをサポート | E-02（285行目: `setWeightCol`） | ○ |
| C-16 | NaN検出を行う | E-02（304行目: `checkNonNanVectors`） | ○ |
| C-17 | 非負重み検証を行う | E-02（305行目: `checkNonNegativeWeights`） | ○ |
| C-18 | パフォーマンスはデータサイズ等に依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件について具体的なベンチマーク数値がソースコードからは取得できない
  - 候補：公式ドキュメント / パフォーマンステスト結果 / ベンチマーク資料

## 5) リスクフラグ（レビュー観点）
- 0: 全体的にソースコードに基づく記述で低リスク
- 1: パフォーマンス要件については定性的記述のみ

## 6) レビュアーチェックリスト（最小）
- [ ] パラメータのデフォルト値がソースコードと一致しているか確認
- [ ] アルゴリズム説明がScalaDocの記述と整合しているか確認
- [ ] 行番号の参照が最新コードと一致しているか確認
