---
generated_at: 2026-02-04 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：66-特徴量変換

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **40以上の変換器の網羅性**：代表的な変換器のみ記載、全量は未確認
  2. **計算ロジックの数式**：一部の変換器のみ記載

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/feature/VectorAssembler.scala` VectorAssembler定義（44-82行目）
- E-02: `mllib/src/main/scala/org/apache/spark/ml/feature/StandardScaler.scala` StandardScaler定義（38-73行目）
- E-03: `mllib/src/main/scala/org/apache/spark/ml/feature/StringIndexer.scala` StringIndexerBase定義（42-99行目）
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` No.66の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | VectorAssemblerのhandleInvalidデフォルトは"error" | E-01（82行目） | ○ |
| C-02 | StandardScalerのwithMeanデフォルトはfalse | E-02（72行目） | ○ |
| C-03 | StandardScalerのwithStdデフォルトはtrue | E-02（72行目） | ○ |
| C-04 | StringIndexerのhandleInvalidデフォルトは"error" | E-03（82行目） | ○ |
| C-05 | StringIndexerのstringOrderTypeデフォルトは"frequencyDesc" | E-03（83行目） | ○ |
| C-06 | VectorAssemblerはTransformerパターン | E-01（44行目: extends Transformer） | ○ |
| C-07 | StandardScalerはEstimatorパターン | E-02（85-87行目: extends Estimator） | ○ |
| C-08 | StringIndexerは複数カラム対応 | E-03（90-99行目: getInOutCols） | ○ |
| C-09 | handleInvalidの3つの選択肢 | E-01（64-69行目） | ○ |
| C-10 | withMean=trueで密ベクトル出力 | E-02（41-43行目: ScalaDoc） | ○ |
| C-11 | Pipeline APIと統合 | E-01, E-02（Transformer/Estimator継承） | ○ |
| C-12 | MLWritable/MLReadableで永続化可能 | E-01（DefaultParamsWritable） | ○ |
| C-13 | 40以上の変換器を提供 | E-04 | ○ |
| C-14 | StandardScaler: x'=(x-mean)/std | E-02 | ○ |
| C-15 | StringIndexerの4つのstringOrderType | E-03（63-73行目） | ○ |
| C-16 | VectorAssemblerは1パスで処理 | E-01 | ○ |
| C-17 | 全変換器の網羅的なパラメータ一覧 | **根拠なし** | △ |
| C-18 | TF-IDFの計算式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 全変換器のパラメータ一覧は代表的なもののみ記載。全量確認が必要
  - 候補：ml/feature/ディレクトリ配下の全ファイル
- TF-IDFの計算式は一般的な定義を記載。Spark固有の実装差異がある可能性
  - 候補：HashingTF.scala / IDF.scala の内部実装

## 5) リスクフラグ（レビュー観点）
- 0: 代表的な変換器の記述は低リスク
- 1: 全変換器の網羅性は中リスク（代表的なもののみ記載）
- 0: 計算ロジックは標準的な定義に基づくため低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 代表的な変換器のパラメータデフォルト値がソースコードと一致しているか確認
- [ ] 変換器のカテゴリ分類が適切か確認
- [ ] 記載されていない変換器で重要なものがないか確認
