---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：67-モデル評価

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **計算ロジックの詳細数式**：一般的な定義を記載

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/evaluation/Evaluator.scala` 28-63行目
- E-02: `mllib/src/main/scala/org/apache/spark/ml/evaluation/BinaryClassificationEvaluator.scala` 37-159行目
- E-03: `mllib/src/main/scala/org/apache/spark/ml/evaluation/MulticlassClassificationEvaluator.scala` 35-100行目
- E-04: `mllib/src/main/scala/org/apache/spark/ml/evaluation/RegressionEvaluator.scala` 34-100行目
- E-05: `mllib/src/main/scala/org/apache/spark/ml/evaluation/ClusteringEvaluator.scala` 36-100行目
- E-06: `mllib/src/main/scala/org/apache/spark/ml/evaluation/RankingEvaluator.scala` 36-100行目
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` No.67の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Evaluator抽象クラスのevaluate()メソッド | E-01（39-51行目） | ○ |
| C-02 | isLargerBetterプロパティ | E-01（58-59行目） | ○ |
| C-03 | BinaryClassificationのmetricNameデフォルトは"areaUnderROC" | E-02（95行目） | ○ |
| C-04 | BinaryClassificationのnumBinsデフォルトは1000 | E-02（95行目） | ○ |
| C-05 | BinaryClassificationのisLargerBetterはtrue | E-02（142行目） | ○ |
| C-06 | rawPredictionColはDouble型またはVector型 | E-02（118行目） | ○ |
| C-07 | Vector型の場合は長さ2が必要 | E-02（125行目） | ○ |
| C-08 | MulticlassClassificationのmetricNameデフォルトは"f1" | E-03 | ○ |
| C-09 | RegressionのmetricNameデフォルトは"rmse" | E-04（94行目） | ○ |
| C-10 | RegressionのthroughOriginデフォルトはfalse | E-04（94行目） | ○ |
| C-11 | RegressionのmetricName選択肢 | E-04（53行目） | ○ |
| C-12 | ClusteringのmetricName="silhouette" | E-05（68行目） | ○ |
| C-13 | ClusteringのdistanceMeasure選択肢 | E-05（88-89行目） | ○ |
| C-14 | RankingのmetricNameデフォルトは"meanAveragePrecision" | E-06（92行目） | ○ |
| C-15 | Rankingのkデフォルトは10 | E-06（92行目） | ○ |
| C-16 | getMetrics()でmlllib Metricsオブジェクトにアクセス | E-02（116行目） | ○ |
| C-17 | BinaryClassificationMetricsを使用 | E-02（138行目） | ○ |
| C-18 | weightColサポート（Binary, Multiclass, Regression, Clustering） | E-02-E-05 | ○ |
| C-19 | RankingEvaluatorは@Experimental | E-06（34行目） | ○ |
| C-20 | 5種類のEvaluatorを提供 | E-02-E-06 | ○ |
| C-21 | CrossValidator/TrainValidationSplitと連携 | E-07 | ○ |
| C-22 | 計算ロジックの詳細数式 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 計算ロジックは一般的な定義を記載。Spark固有の実装差異がある可能性
  - 候補：mllib.evaluation内部実装

## 5) リスクフラグ（レビュー観点）
- 0: 全体的にソースコードに基づく記述で低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] 各Evaluatorのパラメータデフォルト値がソースコードと一致しているか確認
- [ ] isLargerBetterの値が各Evaluatorで正しいか確認
- [ ] サポートされるmetricNameの一覧が網羅的か確認
