---
generated_at: 2026-02-04 10:40:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：69-頻出パターンマイニング

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンスに関するドライバーメモリ警告の詳細**：定性的記述

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/fpm/FPGrowth.scala` FPGrowthParams（44-115行目）
- E-02: `mllib/src/main/scala/org/apache/spark/ml/fpm/FPGrowth.scala` FPGrowth.fit()/genericFit()（128-203行目）
- E-03: `mllib/src/main/scala/org/apache/spark/ml/fpm/FPGrowth.scala` FPGrowthModel（218-335行目）
- E-04: `mllib/src/main/scala/org/apache/spark/ml/fpm/FPGrowth.scala` AssociationRules（393-432行目）
- E-05: `mllib/src/main/scala/org/apache/spark/ml/fpm/PrefixSpan.scala` PrefixSpanParams（29-92行目）
- E-06: `mllib/src/main/scala/org/apache/spark/ml/fpm/PrefixSpan.scala` findFrequentSequentialPatterns（138-166行目）
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` No.69の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | minSupportデフォルトは0.3（FP-Growth） | E-01（101行目） | ○ |
| C-02 | itemsColデフォルトは"items" | E-01（101行目） | ○ |
| C-03 | minConfidenceデフォルトは0.8 | E-01（101行目） | ○ |
| C-04 | minSupportデフォルトは0.1（PrefixSpan） | E-05（90行目） | ○ |
| C-05 | maxPatternLengthデフォルトは10 | E-05（90行目） | ○ |
| C-06 | maxLocalProjDBSizeデフォルトは32000000 | E-05（90行目） | ○ |
| C-07 | sequenceColデフォルトは"sequence" | E-05（91行目） | ○ |
| C-08 | fit()でMLlib FPGrowthに委譲 | E-02（171-181行目） | ○ |
| C-09 | NULL行のフィルタリング | E-02（170行目: isNotNull） | ○ |
| C-10 | freqItemsets DataFrameの生成 | E-02（182-186行目） | ○ |
| C-11 | associationRulesのminConfidenceキャッシュ | E-03（245-265行目） | ○ |
| C-12 | transform()でルールのブロードキャスト | E-03（289行目） | ○ |
| C-13 | UDFで既存アイテム除外した推薦 | E-03（293-300行目） | ○ |
| C-14 | associationRulesにconfidence/lift/support含む | E-04（423-428行目） | ○ |
| C-15 | PrefixSpanはEstimatorパターンではない | E-06（106行目: extends PrefixSpanParams） | ○ |
| C-16 | PrefixSpanのスキーマ検証 | E-06（145-148行目） | ○ |
| C-17 | FP-GrowthはSpark 2.2.0で導入 | E-07 | ○ |
| C-18 | PrefixSpanはSpark 2.4.0で導入 | E-07 | ○ |
| C-19 | サポート/信頼度/リフトの計算式 | E-04 | ○ |
| C-20 | ドライバーメモリに関する警告 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ドライバーメモリに関する警告は、transform()のScalaDocコメント（267-277行目）にWARNINGとして記載されているが、具体的なメモリ上限値は記載なし
  - 候補：実行時のメモリプロファイリング結果

## 5) リスクフラグ（レビュー観点）
- 0: パラメータ定義・API仕様は低リスク
- 0: 処理フローは行番号付きで低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] FP-Growth/PrefixSpanのパラメータデフォルト値がソースコードと一致しているか確認
- [ ] associationRulesの出力カラムが正確か確認
- [ ] transform()の推薦ロジックが正しく記述されているか確認
