---
generated_at: 2026-02-04 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：70-統計検定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **統計検定の計算式詳細**：一般的な定義を記載
  2. **Summarizerのパフォーマンスオーバーヘッド**：定性的記述

## 2) 参照した情報（Evidence一覧）

- E-01: `mllib/src/main/scala/org/apache/spark/ml/stat/ChiSquareTest.scala` 35-101行目
- E-02: `mllib/src/main/scala/org/apache/spark/ml/stat/Correlation.scala` 36-84行目
- E-03: `mllib/src/main/scala/org/apache/spark/ml/stat/KolmogorovSmirnovTest.scala` 40-116行目
- E-04: `mllib/src/main/scala/org/apache/spark/ml/stat/Summarizer.scala` 47-100行目
- E-05: `mllib/src/main/scala/org/apache/spark/ml/stat/ANOVATest.scala` 38-100行目
- E-06: `mllib/src/main/scala/org/apache/spark/ml/stat/FValueTest.scala` 33-100行目
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` No.70の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ChiSquareTestはobjectとして定義 | E-01（35行目） | ○ |
| C-02 | ChiSquareTestのfeaturesColはVector型 | E-01（74行目） | ○ |
| C-03 | ChiSquareTestのlabelColは数値型 | E-01（75行目） | ○ |
| C-04 | ChiSquareTestのflattenパラメータ | E-01（68-73行目） | ○ |
| C-05 | ChiSquareTestの出力はpValues/degreesOfFreedom/statistics | E-01（94-98行目） | ○ |
| C-06 | OldChiSqTest.computeChiSquaredに委譲 | E-01（83行目） | ○ |
| C-07 | Correlationのデフォルトはpearson | E-02（81-82行目） | ○ |
| C-08 | Correlationはpearsonとspearmanをサポート | E-02（47行目） | ○ |
| C-09 | OldStatistics.corrに委譲 | E-02（71行目） | ○ |
| C-10 | KSTestのテスト結果はpValueとstatistic | E-03（43-45行目） | ○ |
| C-11 | KSTestは両側検定 | E-03（31行目ScalaDoc） | ○ |
| C-12 | KSTestのカスタムCDF版と分布名指定版 | E-03（68-75行目, 105-115行目） | ○ |
| C-13 | getSampleRDD()でDouble型RDD生成 | E-03（47-51行目） | ○ |
| C-14 | SummaryBuilderの定義 | E-04（47-61行目） | ○ |
| C-15 | Summarizerのメトリクス一覧 | E-04（89行目以降ScalaDoc） | ○ |
| C-16 | ANOVATestはprivate[ml] | E-05（38行目） | ○ |
| C-17 | FValueTestはprivate[ml] | E-06（33行目） | ○ |
| C-18 | ANOVATestのflatten対応 | E-05（64-86行目） | ○ |
| C-19 | FValueTestのflatten対応 | E-06（65-90行目） | ○ |
| C-20 | Spearman相関のキャッシュ推奨 | E-02（61-63行目ScalaDoc注記） | ○ |
| C-21 | 統計検定の計算式詳細 | **根拠なし** | △ |
| C-22 | Summarizerのパフォーマンスオーバーヘッド | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 統計検定の計算式は一般的な定義を記載。Spark固有の実装差異がある可能性
  - 候補：mllib.stat.test内部実装
- Summarizerのパフォーマンスオーバーヘッドの記述はScalaDocのコメントに基づく
  - 候補：パフォーマンスベンチマーク結果

## 5) リスクフラグ（レビュー観点）
- 0: API仕様・入出力は低リスク
- 1: 計算式詳細は中リスク（一般的定義を記載）

## 6) レビュアーチェックリスト（最小）
- [ ] 各統計検定のAPI（メソッド名、パラメータ）が正確か確認
- [ ] 出力DataFrameのカラム名・型がソースコードと一致しているか確認
- [ ] ANOVATest/FValueTestのprivate[ml]スコープが正しいか確認
- [ ] Summarizerのメトリクス一覧が網羅的か確認
