---
generated_at: 2026-02-04 10:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：71-グラフ構造データ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **パフォーマンス要件のactiveFraction閾値0.8**: コードから確認済みだが具体的な性能数値の文書化なし

## 2) 参照した情報（Evidence一覧）

- E-01: `graphx/src/main/scala/org/apache/spark/graphx/Graph.scala`
- E-02: `graphx/src/main/scala/org/apache/spark/graphx/GraphOps.scala`
- E-03: `graphx/src/main/scala/org/apache/spark/graphx/impl/GraphImpl.scala`
- E-04: `graphx/src/main/scala/org/apache/spark/graphx/Edge.scala`
- E-05: `graphx/src/main/scala/org/apache/spark/graphx/EdgeTriplet.scala`
- E-06: `graphx/src/main/scala/org/apache/spark/graphx/PartitionStrategy.scala`
- E-07: `graphx/src/main/scala/org/apache/spark/graphx/GraphLoader.scala`
- E-08: `docs/code-to-docs/機能一覧/機能一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Graph抽象クラスはvertices, edges, tripletsの3つのRDDプロパティを持つ | E-01 (49, 62, 80行目) | ○ |
| C-02 | GraphImplはVertexRDDとReplicatedVertexViewで構成される | E-03 (34-37行目) | ○ |
| C-03 | mapVerticesで型保存時は差分レプリケーションが行われる | E-03 (122-138行目) | ○ |
| C-04 | aggregateMessagesはactiveFractionに基づきスキャン方式を切り替える | E-03 (210-238行目) | ○ |
| C-05 | activeFractionの閾値は0.8 | E-03 (213行目) | ○ |
| C-06 | EdgePartition2Dの頂点レプリケーション上限は2*sqrt(numParts) | E-06 (36行目のコメント) | ○ |
| C-07 | GraphLoader.edgeListFileはタブ区切りテキストファイルを読み込む | E-07 (60-105行目) | ○ |
| C-08 | Edge.scalaの@specializedアノテーションはプリミティブ型のボクシング回避 | E-04 (32行目) | ○ |
| C-09 | GraphOpsは暗黙変換で提供される | E-01 (541-542行目) | ○ |
| C-10 | Graph.applyはGraphImplに委譲される | E-01 (525-532行目) | ○ |
| C-11 | VertexIdはLong型のエイリアス | E-01 (package.scalaで定義) | ○ |
| C-12 | graphToGraphOps暗黙変換がGraphOpsを提供 | E-01 (541-542行目) | ○ |
| C-13 | partitionByはHashPartitionerを使用 | E-03 (104行目) | ○ |
| C-14 | subgraphはvpredとepredの両方を適用する | E-03 (158-169行目) | ○ |
| C-15 | outerJoinVerticesは型保存時に差分レプリケーションを行う | E-03 (246-265行目) | ○ |
| C-16 | CanonicalRandomVertexCutはsrc/dst方向に関係なく同一パーティション | E-06 (125-133行目) | ○ |
| C-17 | edgeListFileは#で始まる行をスキップする | E-07 (81行目) | ○ |
| C-18 | グラフ操作は不変であり新しいGraphを返す | E-01 (28-35行目のScaladoc) | ○ |
| C-19 | tripletsは遅延評価される | E-03 (45行目のlazy val) | ○ |
| C-20 | GraphXはScala APIのみ提供 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-20「GraphXはScala APIのみ提供」について、Python/Java向けAPIの有無に関する公式ドキュメントの参照が不足
  - 候補：公式ドキュメント / python/pyspark/ 配下のGraphX関連ファイル確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Graph.scalaの抽象メソッド一覧が設計書と一致しているか
- [ ] GraphImplのactiveFraction閾値0.8の妥当性確認
- [ ] パーティション戦略の説明がPartitionStrategy.scalaのコメントと一致しているか
