---
generated_at: 2026-02-04 10:20:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：74-強連結成分検出

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `graphx/src/main/scala/org/apache/spark/graphx/lib/StronglyConnectedComponents.scala`
- E-02: `graphx/src/main/scala/org/apache/spark/graphx/GraphOps.scala`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | numIter > 0 のバリデーション | E-01 (39-40行目) | ○ |
| C-02 | sccGraphは各頂点を自身のIDで初期化 | E-01 (43行目) | ○ |
| C-03 | sccWorkGraphは(vid, false)で初期化 | E-01 (45行目) | ○ |
| C-04 | 出次数0の頂点をisFinalにマーク | E-01 (56-57行目) | ○ |
| C-05 | 入次数0の頂点をisFinalにマーク | E-01 (58-59行目) | ○ |
| C-06 | 前方PregelでEdgeDirection.Outを使用 | E-01 (90行目) | ○ |
| C-07 | 前方PregelのvprogでsMath.min | E-01 (91行目) | ○ |
| C-08 | 後方PregelでEdgeDirection.Inを使用 | E-01 (104行目) | ○ |
| C-09 | カラールート判定: vid == myScc._1 | E-01 (108行目) | ○ |
| C-10 | 同じカラーかつdstが最終確定、srcが未確定の場合に送信 | E-01 (113-116行目) | ○ |
| C-11 | sccGraph.vertices.count()で明示マテリアライズ | E-01 (72行目) | ○ |
| C-12 | prevSccGraph.unpersist()でメモリ解放 | E-01 (75行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク

## 6) レビュアーチェックリスト（最小）
- [ ] トリミングループの終了条件（頂点数が減少しなくなるまで）の正確性を確認
- [ ] 前方伝播と後方伝播のメッセージ送信条件の正確性を確認
- [ ] 外部ループ（numIter）と内部Pregelの反復回数の関係を理解しているか確認
