---
generated_at: 2026-02-04 10:15:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：84-Standaloneクラスタマネージャ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **schedule()メソッドの詳細なスケジューリングアルゴリズム**：Master.scalaの後半部分の読み込みが必要
  2. **ZooKeeperリカバリの具体的な実装**：PersistenceEngine系クラスの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/deploy/master/Master.scala` 49-100行目
- E-02: `core/src/main/scala/org/apache/spark/deploy/worker/Worker.scala` 52-80行目
- E-03: `core/src/main/scala/org/apache/spark/deploy/DeployMessages.scala`
- E-04: `docs/code-to-docs/機能一覧/機能一覧.csv` 84行目
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` 画面24-29

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | MasterはThreadSafeRpcEndpointを継承 | E-01 (49-55行目) | ○ |
| C-02 | workers/apps/driversをHashSet/HashMapで管理 | E-01 (72-91行目) | ○ |
| C-03 | workerTimeoutMsでWorkerタイムアウト管理 | E-01 (62行目) | ○ |
| C-04 | retainedApplications/retainedDriversで保持数制限 | E-01 (63-64行目) | ○ |
| C-05 | maxDriversで最大ドライバー数制限 | E-01 (65行目) | ○ |
| C-06 | MetricsSystemでマスターメトリクス収集 | E-01 (95-98行目) | ○ |
| C-07 | forwardMessageThreadでメッセージ転送 | E-01 (57-58行目) | ○ |
| C-08 | recoveryModeでリカバリモード設定 | E-01 (69行目) | ○ |
| C-09 | WorkerはDecommissionシグナル対応 | E-02 (74-80行目) | ○ |
| C-10 | Workerはmasters配列で複数マスター管理 | E-02 (57行目) | ○ |
| C-11 | 関連画面24-29がMaster/Worker UIに対応 | E-05 | ○ |
| C-12 | REST APIサーバーをMasterが提供 | E-01 (34行目 StandaloneRestServer import) | ○ |
| C-13 | maxExecutorRetriesでExecutorリトライ制限 | E-01 (70行目) | ○ |
| C-14 | moduloAppNumberでアプリ番号生成 | E-01 (85行目) | ○ |
| C-15 | MasterWebUIでWeb管理画面提供 | E-01 (33行目 import) | ○ |
| C-16 | WorkerWebUIでWorker管理画面提供 | E-02 (39行目 import) | ○ |
| C-17 | schedule()メソッドの具体的なスケジューリングアルゴリズム | **根拠なし** | △ |
| C-18 | ZooKeeperリカバリの具体的な状態永続化実装 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- schedule()メソッドのスケジューリングアルゴリズム詳細
  - 候補：Master.scala のschedule()メソッド（後半部分）
- ZooKeeperベースの状態永続化実装
  - 候補：`core/src/main/scala/org/apache/spark/deploy/master/ZooKeeperPersistenceEngine.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造と初期化処理はソースコードから確認済み
- 1: 中リスク - スケジューリングアルゴリズムの詳細は未確認

## 6) レビュアーチェックリスト（最小）
- [ ] Master.scalaのschedule()メソッド全体を確認
- [ ] ZooKeeperPersistenceEngineの状態永続化実装を確認
- [ ] WorkerSelectionPolicyの実装詳細を確認
- [ ] ExecutorRunnerの起動・監視メカニズムを確認
