---
generated_at: 2026-02-04 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：87-Kafkaコネクタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **fixKafkaParams()の具体的な補正内容**：メソッド実装の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `connector/kafka-0-10/src/main/scala/org/apache/spark/streaming/kafka010/KafkaUtils.scala` 37-71行目
- E-02: `connector/kafka-0-10/src/main/scala/org/apache/spark/streaming/kafka010/DirectKafkaInputDStream.scala` 53-100行目
- E-03: `connector/kafka-0-10/src/main/scala/org/apache/spark/streaming/kafka010/KafkaRDD.scala`
- E-04: `connector/kafka-0-10/src/main/scala/org/apache/spark/streaming/kafka010/KafkaDataConsumer.scala`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 87行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | createRDDでバッチ読み取り用RDD生成 | E-01 (52-71行目) | ○ |
| C-02 | PreferBrokersはcreateRDDで禁止 | E-01 (60-62行目) | ○ |
| C-03 | fixKafkaParamsでパラメータ補正 | E-01 (67行目) | ○ |
| C-04 | DirectKafkaInputDStreamがInputDStreamを継承 | E-02 (53-58行目) | ○ |
| C-05 | CanCommitOffsetsインターフェース実装 | E-02 (58行目) | ○ |
| C-06 | initialRateでバックプレッシャー初期レート設定 | E-02 (60-61行目) | ○ |
| C-07 | executorKafkaParamsで実行用パラメータ管理 | E-02 (63-67行目) | ○ |
| C-08 | currentOffsetsでオフセット追跡 | E-02 (69行目) | ○ |
| C-09 | Consumer初期化はconsumerStrategy.onStart | E-02 (74-75行目) | ○ |
| C-10 | ConsumerRecordはシリアライズ不可（persist警告） | E-02 (80-84行目) | ○ |
| C-11 | getBrokersでパーティション-ホストマッピング取得 | E-02 (86-100行目) | ○ |
| C-12 | Direct方式でパーティション1:1マッピング | E-02, E-03 | ○ |
| C-13 | KafkaRDDパーティションがKafkaパーティションに対応 | E-03 | ○ |
| C-14 | KafkaDataConsumerでデータフェッチ | E-04 | ○ |
| C-15 | RateControllerでレート制御 | E-02 (35行目 import) | ○ |
| C-16 | fixKafkaParamsの具体的な補正内容 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- fixKafkaParamsメソッドの具体的な補正内容
  - 候補：KafkaUtils.scalaのfixKafkaParams()メソッドの後半部分

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Direct DStreamのコアロジックはソースコードから確認済み
- 0: 低リスク - オフセット管理の仕組みは明確

## 6) レビュアーチェックリスト（最小）
- [ ] DirectKafkaInputDStream.compute()のバッチ生成ロジックを確認
- [ ] KafkaDataConsumerのデータ取得とキャッシュメカニズムを確認
- [ ] fixKafkaParamsの補正内容（enable.auto.commit等）を確認
