---
generated_at: 2026-02-04 10:35:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：88-Kinesisコネクタ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **KinesisCheckpointerの具体的なチェックポイント間隔とリトライ動作**：実装詳細の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisInputDStream.scala` 35-100行目
- E-02: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisReceiver.scala` 47-85行目
- E-03: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisBackedBlockRDD.scala`
- E-04: `connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/SparkAWSCredentials.scala`
- E-05: `docs/code-to-docs/機能一覧/機能一覧.csv` 88行目

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | KinesisInputDStreamがReceiverInputDStreamを継承 | E-01 (35-50行目) | ○ |
| C-02 | パラメータ：streamName, endpointUrl, regionName等 | E-01 (36-49行目) | ○ |
| C-03 | createBlockRDDでKinesisBackedBlockRDD生成 | E-01 (52-78行目) | ○ |
| C-04 | allBlocksHaveRangesでSequenceNumberRanges検証 | E-01 (56行目) | ○ |
| C-05 | getReceiver()でKinesisReceiver返却 | E-01 (80-85行目) | ○ |
| C-06 | Builder.build()でパラメータ検証 | E-01 (88行目以降) | ○ |
| C-07 | KCL Schedulerを使用 | E-02 (49行目 説明) | ○ |
| C-08 | KinesisRecordProcessorでシャード別処理 | E-02 (55-56行目) | ○ |
| C-09 | BlockGeneratorにデータを挿入 | E-02 (57行目) | ○ |
| C-10 | SequenceNumberRangesをブロックメタデータとして記録 | E-02 (59-60行目) | ○ |
| C-11 | DynamoDBチェックポイント管理 | E-02 (62-63行目) | ○ |
| C-12 | SparkAWSCredentialsで認証管理 | E-04 | ○ |
| C-13 | Kinesis/DynamoDB/CloudWatch個別認証 | E-01 (46-48行目) | ○ |
| C-14 | MetricsLevelでCloudWatchメトリクス制御 | E-01 (48-49行目) | ○ |
| C-15 | KinesisReadConfigurationsで設定管理 | E-01 (72行目) | ○ |
| C-16 | KinesisCheckpointerの具体的なリトライ動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- KinesisCheckpointerのリトライとエラーハンドリング詳細
  - 候補：`connector/kinesis-asl/src/main/scala/org/apache/spark/streaming/kinesis/KinesisCheckpointer.scala`の全体読み込み

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Receiverパターンとブロック生成の仕組みはソースコードから確認済み
- 0: 低リスク - AWS SDK v2（software.amazon.kinesis）を使用していることが確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] KinesisReceiverのonStart()/onStop()メソッドを確認
- [ ] KinesisCheckpointerのチェックポイント処理を確認
- [ ] SparkAWSCredentialsの各認証方式の実装を確認
- [ ] KinesisBackedBlockRDDのデータ再取得メカニズムを確認
