---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 29
  claims_with_evidence: 29
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：画面一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：29 / 29、根拠なし：0
- 優先レビュー（高）
  1. **該当なし**：全主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/ui/SparkUI.scala` - SparkUI初期化コード。JobsTab/StagesTab/StorageTab/EnvironmentTab/ExecutorsTab/DriverLogTabの登録処理
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/JobsTab.scala` - JobsTabクラス。AllJobsPage/JobPageのattach
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` - AllJobsPageクラス。WebUIPage("")として登録
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` - JobPageクラス。WebUIPage("job")として登録
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/StagesTab.scala` - StagesTabクラス。AllStagesPage/StagePage/PoolPage/TaskThreadDumpPageのattach
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` - AllStagesPageクラス。WebUIPage("")として登録
- E-07: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` - StagePageクラス。WebUIPage("stage")として登録
- E-08: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` - PoolPageクラス。WebUIPage("pool")として登録
- E-09: `core/src/main/scala/org/apache/spark/ui/jobs/TaskThreadDumpPage.scala` - TaskThreadDumpPageクラス。WebUIPage("taskThreadDump")として登録
- E-10: `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` - StorageTabクラス。StoragePage/RDDPageのattach
- E-11: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` - StoragePageクラス。WebUIPage("")として登録
- E-12: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` - RDDPageクラス。WebUIPage("rdd")として登録
- E-13: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` - EnvironmentPageクラスとEnvironmentTabクラス。WebUIPage("")として登録
- E-14: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` - ExecutorsTabクラス。ExecutorsPage/ExecutorThreadDumpPage/ExecutorHeapHistogramPageのattach
- E-15: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorThreadDumpPage.scala` - ExecutorThreadDumpPageクラス。WebUIPage("threadDump")として登録
- E-16: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorHeapHistogramPage.scala` - ExecutorHeapHistogramPageクラス。WebUIPage("heapHistogram")として登録
- E-17: `core/src/main/scala/org/apache/spark/ui/DriverLogPage.scala` - DriverLogPageクラス。WebUIPage("")として登録。DRIVER_LOG_LOCAL_DIR設定時のみ有効
- E-18: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLTab.scala` - SQLTabクラス。AllExecutionsPage/ExecutionPageのattach
- E-19: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` - AllExecutionsPageクラス。WebUIPage("")として登録
- E-20: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` - ExecutionPageクラス。WebUIPage("execution")として登録
- E-21: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryTab.scala` - StreamingQueryTabクラス。StreamingQueryPage/StreamingQueryStatisticsPageのattach
- E-22: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryPage.scala` - StreamingQueryPageクラス。WebUIPage("")として登録
- E-23: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` - StreamingQueryStatisticsPageクラス。WebUIPage("statistics")として登録
- E-24: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingTab.scala` - StreamingTabクラス。StreamingPage/BatchPageのattach
- E-25: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` - StreamingPageクラス
- E-26: `streaming/src/main/scala/org/apache/spark/streaming/ui/BatchPage.scala` - BatchPageクラス。WebUIPage("batch")として登録
- E-27: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerTab.scala` - SparkConnectServerTabクラス。SparkConnectServerPage/SparkConnectServerSessionPageのattach
- E-28: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala` - SparkConnectServerPageクラス。WebUIPage("")として登録
- E-29: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerSessionPage.scala` - SparkConnectServerSessionPageクラス。WebUIPage("session")として登録
- E-30: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerTab.scala` - ThriftServerTabクラス。ThriftServerPage/ThriftServerSessionPageのattach
- E-31: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala` - ThriftServerPageクラス。WebUIPage("")として登録
- E-32: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerSessionPage.scala` - ThriftServerSessionPageクラス。WebUIPage("session")として登録
- E-33: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterWebUI.scala` - MasterWebUI初期化コード。MasterPage/ApplicationPage/LogPage/EnvironmentPageの登録処理
- E-34: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterPage.scala` - MasterPageクラス。WebUIPage("")として登録
- E-35: `core/src/main/scala/org/apache/spark/deploy/master/ui/ApplicationPage.scala` - ApplicationPageクラス。WebUIPage("app")として登録
- E-36: `core/src/main/scala/org/apache/spark/deploy/master/ui/LogPage.scala` - LogPageクラス。WebUIPage("logPage")として登録
- E-37: `core/src/main/scala/org/apache/spark/deploy/master/ui/EnvironmentPage.scala` - EnvironmentPageクラス。WebUIPage("Environment")として登録
- E-38: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerWebUI.scala` - WorkerWebUI初期化コード。LogPage/WorkerPageの登録処理
- E-39: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala` - WorkerPageクラス。WebUIPage("")として登録
- E-40: `core/src/main/scala/org/apache/spark/deploy/worker/ui/LogPage.scala` - LogPageクラス。WebUIPage("logPage")として登録

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | All Jobs画面が存在し、全ジョブ一覧を表示する | E-01, E-02, E-03 | ○ |
| C-02 | Job Detail画面が存在し、特定ジョブの詳細を表示する | E-02, E-04 | ○ |
| C-03 | All Stages画面が存在し、全ステージ一覧を表示する | E-01, E-05, E-06 | ○ |
| C-04 | Stage Detail画面が存在し、特定ステージの詳細を表示する | E-05, E-07 | ○ |
| C-05 | Pool Detail画面が存在し、FAIRスケジューラのプール情報を表示する | E-05, E-08 | ○ |
| C-06 | Task Thread Dump画面が存在し、タスクのスレッドダンプを表示する | E-05, E-09 | ○ |
| C-07 | Storage画面が存在し、RDDストレージ一覧を表示する | E-10, E-11 | ○ |
| C-08 | RDD Detail画面が存在し、特定RDDの詳細を表示する | E-10, E-12 | ○ |
| C-09 | Environment画面が存在し、環境情報を表示する | E-01, E-13 | ○ |
| C-10 | Executors画面が存在し、エグゼキュータ一覧を表示する | E-01, E-14 | ○ |
| C-11 | Executor Thread Dump画面が存在し、スレッドダンプを表示する | E-14, E-15 | ○ |
| C-12 | Executor Heap Histogram画面が存在し、ヒープヒストグラムを表示する | E-14, E-16 | ○ |
| C-13 | Driver Log画面が存在し、ドライバログを表示する（条件付き） | E-01, E-17 | ○ |
| C-14 | SQL All Executions画面が存在し、SQL実行一覧を表示する | E-18, E-19 | ○ |
| C-15 | SQL Execution Detail画面が存在し、特定SQL実行の詳細を表示する | E-18, E-20 | ○ |
| C-16 | Streaming Query List画面が存在し、クエリ一覧を表示する | E-21, E-22 | ○ |
| C-17 | Streaming Query Statistics画面が存在し、クエリ統計を表示する | E-21, E-23 | ○ |
| C-18 | DStreams Streaming Overview画面が存在し、ストリーミング概要を表示する | E-24, E-25 | ○ |
| C-19 | Batch Detail画面が存在し、バッチ詳細を表示する | E-24, E-26 | ○ |
| C-20 | Spark Connect Server Overview画面が存在する | E-27, E-28 | ○ |
| C-21 | Spark Connect Server Session Detail画面が存在する | E-27, E-29 | ○ |
| C-22 | ThriftServer Overview画面が存在する | E-30, E-31 | ○ |
| C-23 | ThriftServer Session Detail画面が存在する | E-30, E-32 | ○ |
| C-24 | Master Overview画面が存在し、クラスタ情報を表示する | E-33, E-34 | ○ |
| C-25 | Application Detail画面が存在し、アプリケーション詳細を表示する | E-33, E-35 | ○ |
| C-26 | Master Log画面が存在し、マスターログを表示する | E-33, E-36 | ○ |
| C-27 | Master Environment画面が存在し、環境情報を表示する | E-33, E-37 | ○ |
| C-28 | Worker Overview画面が存在し、ワーカー情報を表示する | E-38, E-39 | ○ |
| C-29 | Worker Log画面が存在し、ワーカーログを表示する | E-38, E-40 | ○ |

## 4) 不足情報（Unknown / Missing）
- 全主張に対してソースコードの根拠が確認されたため、不足情報はありません。
- ただし、History Server UIについてはSparkUI自体を再利用する仕組みのため独立した画面としては列挙していません。
  - 候補：`core/src/main/scala/org/apache/spark/deploy/history/` 配下のHistoryServer関連コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全画面がソースコードのPageクラス/Tabクラスから直接確認可能
- 0: 低リスク - 画面遷移はSparkUIのTab/Page登録パターンおよびページ内リンク構造から特定
- 1: 中リスク - History Server UIの画面がSparkUIを再利用する形で動作するため、別画面として含めるべきか判断が必要
- 1: 中リスク - Resource Managerごとの追加UI（YARN/Mesos/Kubernetes固有画面）が存在する可能性

## 6) レビュアーチェックリスト（最小）
- [ ] 画面一覧の29画面がプロジェクトのソースコードと一致しているか
- [ ] 各画面のテンプレートファイルパスが実際のファイルパスと一致しているか
- [ ] 条件付き画面（Driver Log/Thread Dump/Heap Histogram等）の有効化条件が正しいか
- [ ] History Server UIを独立した画面として追加する必要があるか検討
- [ ] Resource Manager固有UI（YARN等）の追加画面の有無を確認
- [ ] 画面遷移図の遷移パスがソースコード内のリンク構造と一致しているか
