# 画面遷移図

## Spark Application UI（SparkUI）

SparkUIはSparkアプリケーション実行時に提供されるWeb UIであり、Jobs/Stages/Storage/Environment/Executorsの基本タブに加え、SQL/Streaming/Connect/ThriftServerの拡張タブが条件付きで追加される。

```mermaid
graph TD
    subgraph SparkUI["Spark Application UI"]
        ROOT["/ (ルート)"] -->|リダイレクト| AllJobs

        subgraph JobsTab["Jobs タブ (/jobs/)"]
            AllJobs["All Jobs<br/>全ジョブ一覧"]
            JobDetail["Job Detail<br/>ジョブ詳細"]
            AllJobs -->|"ジョブID選択"| JobDetail
        end

        subgraph StagesTab["Stages タブ (/stages/)"]
            AllStages["All Stages<br/>全ステージ一覧"]
            StageDetail["Stage Detail<br/>ステージ詳細"]
            PoolDetail["Pool Detail<br/>プール詳細"]
            TaskThreadDump["Task Thread Dump<br/>タスクスレッドダンプ"]
            AllStages -->|"ステージID選択"| StageDetail
            AllStages -->|"プール名選択<br/>(FAIRスケジューラ時)"| PoolDetail
            StageDetail -->|"タスクのスレッドダンプ表示"| TaskThreadDump
        end

        subgraph StorageTab["Storage タブ (/storage/)"]
            StoragePage["Storage<br/>ストレージ一覧"]
            RDDDetail["RDD Detail<br/>RDD詳細"]
            StoragePage -->|"RDD ID選択"| RDDDetail
        end

        subgraph EnvironmentTab["Environment タブ (/environment/)"]
            EnvironmentPage["Environment<br/>環境情報"]
        end

        subgraph ExecutorsTab["Executors タブ (/executors/)"]
            ExecutorsPage["Executors<br/>エグゼキュータ一覧"]
            ExecutorThreadDump["Executor Thread Dump<br/>スレッドダンプ"]
            ExecutorHeapHistogram["Executor Heap Histogram<br/>ヒープヒストグラム"]
            ExecutorsPage -->|"Thread Dump選択"| ExecutorThreadDump
            ExecutorsPage -->|"Heap Histogram選択"| ExecutorHeapHistogram
        end

        subgraph DriverLogTab["Driver Log タブ (/driverlog/)<br/>※条件付き"]
            DriverLogPage["Driver Log<br/>ドライバログ"]
        end

        JobDetail -->|"ステージID選択"| StageDetail
        StageDetail -->|"エグゼキュータID選択"| ExecutorThreadDump

        subgraph SQLTab["SQL / DataFrame タブ (/SQL/)<br/>※SQLモジュール使用時"]
            AllExecutions["All Executions<br/>SQL実行一覧"]
            ExecutionDetail["Execution Detail<br/>SQL実行詳細"]
            AllExecutions -->|"実行ID選択"| ExecutionDetail
        end

        subgraph StreamingQueryTab["Structured Streaming タブ (/StreamingQuery/)<br/>※Structured Streaming使用時"]
            StreamingQueryList["Streaming Query List<br/>クエリ一覧"]
            StreamingQueryStats["Streaming Query Statistics<br/>クエリ統計"]
            StreamingQueryList -->|"クエリID選択"| StreamingQueryStats
        end

        subgraph DStreamTab["Streaming タブ (/streaming/)<br/>※DStreams使用時"]
            StreamingOverview["Streaming Overview<br/>ストリーミング概要"]
            BatchDetail["Batch Detail<br/>バッチ詳細"]
            StreamingOverview -->|"バッチID選択"| BatchDetail
        end

        subgraph ConnectTab["Connect タブ (/connect/)<br/>※Spark Connect Server使用時"]
            ConnectOverview["Connect Server Overview<br/>サーバー概要"]
            ConnectSessionDetail["Connect Session Detail<br/>セッション詳細"]
            ConnectOverview -->|"セッションID選択"| ConnectSessionDetail
        end

        subgraph ThriftServerTab["JDBC/ODBC Server タブ (/sqlserver/)<br/>※ThriftServer使用時"]
            ThriftOverview["ThriftServer Overview<br/>サーバー概要"]
            ThriftSessionDetail["ThriftServer Session Detail<br/>セッション詳細"]
            ThriftOverview -->|"セッションID選択"| ThriftSessionDetail
        end

        ExecutionDetail -->|"ジョブID選択"| JobDetail
        BatchDetail -->|"ジョブID選択"| JobDetail
    end
```

## Standalone Master UI（MasterWebUI）

Standalone ModeのマスターノードのWeb UI。クラスタ全体のリソース・アプリケーション管理を行う。

```mermaid
graph TD
    subgraph MasterUI["Standalone Master UI"]
        MasterOverview["Master Overview<br/>マスター概要"]
        MasterAppDetail["Application Detail<br/>アプリケーション詳細"]
        MasterLog["Master Log<br/>マスターログ"]
        MasterEnv["Master Environment<br/>マスター環境情報"]

        MasterOverview -->|"アプリケーションID選択"| MasterAppDetail
        MasterOverview -->|"ログ表示"| MasterLog
        MasterOverview -->|"Environment選択"| MasterEnv
        MasterOverview -->|"アプリケーションUI表示"| SparkUILink["Spark Application UI<br/>(プロキシ経由)"]
        MasterOverview -->|"ワーカー選択"| WorkerUILink["Worker UI<br/>(外部リンク)"]
    end
```

## Standalone Worker UI（WorkerWebUI）

Standalone Modeのワーカーノードの Web UI。ワーカーのリソース状況やエグゼキュータ/ドライバーのログを確認できる。

```mermaid
graph TD
    subgraph WorkerUI["Standalone Worker UI"]
        WorkerOverview["Worker Overview<br/>ワーカー概要"]
        WorkerLog["Worker Log<br/>ワーカーログ"]

        WorkerOverview -->|"エグゼキュータ/ドライバーのログ表示"| WorkerLog
    end
```

## 画面間の外部遷移関係

```mermaid
graph LR
    MasterUI["Master UI"] -->|"アプリUI表示"| SparkUI["Spark Application UI"]
    MasterUI -->|"ワーカー選択"| WorkerUI["Worker UI"]
    WorkerUI -->|"アプリUI表示"| SparkUI
```
