---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 95
  claims_with_evidence: 86
  claims_without_evidence: 9
confidence_derived: 0.91
---

# 根拠レポート：画面機能マッピング.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：86 / 95、根拠なし：9
- 優先レビュー（高）
  1. **画面9-Environment: セキュリティ管理との関連**：Utils.redactの呼び出しは確認したが、セキュリティ管理機能(No.14)との直接的な依存関係は間接的
  2. **画面13-Driver Log: イベントログ記録との関連**：ドライバログとイベントログ記録(No.11)は別機構である可能性があり要確認
  3. **画面14,15-SQL: Catalystオプティマイザとの関連**：SQLTab画面はSQLAppStatusStoreを利用しており、Catalystの直接参照は推定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/ui/jobs/AllJobsPage.scala` - AllJobsPage実装（store.jobsList, makeTimeline, killEnabled）
- E-02: `core/src/main/scala/org/apache/spark/ui/jobs/JobPage.scala` - JobPage実装（operationGraphForJob, stageAttempt, sqlExecutionId）
- E-03: `core/src/main/scala/org/apache/spark/ui/jobs/AllStagesPage.scala` - AllStagesPage実装（stageList, poolTable, isFairScheduler）
- E-04: `core/src/main/scala/org/apache/spark/ui/jobs/StagePage.scala` - StagePage実装（taskList, operationGraphForStage, localitySummary, shuffle/spill metrics）
- E-05: `core/src/main/scala/org/apache/spark/ui/jobs/PoolPage.scala` - PoolPage実装（getPoolForName, activeStages, StageTableBase）
- E-06: `core/src/main/scala/org/apache/spark/ui/jobs/TaskThreadDumpPage.scala` - TaskThreadDumpPage実装（getTaskThreadDump）
- E-07: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` - StoragePage実装（rddList, streamBlocksList）
- E-08: `core/src/main/scala/org/apache/spark/ui/storage/RDDPage.scala` - RDDPage実装（rdd, dataDistribution, partitions, executorList）
- E-09: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` - EnvironmentPage実装（environmentInfo, sparkProperties, hadoopProperties, Utils.redact）
- E-10: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` - ExecutorsTab/ExecutorsPage実装（executorspage.js, threadDumpEnabled, heapHistogramEnabled）
- E-11: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorThreadDumpPage.scala` - ExecutorThreadDumpPage実装（getExecutorThreadDump, flamegraph, threadDumpSummary）
- E-12: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorHeapHistogramPage.scala` - ExecutorHeapHistogramPage実装（getExecutorHeapHistogram）
- E-13: `core/src/main/scala/org/apache/spark/ui/DriverLogPage.scala` - DriverLogPage実装（RollingFileAppender, DRIVER_LOG_LOCAL_DIR）
- E-14: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/AllExecutionsPage.scala` - AllExecutionsPage実装（sqlStore.executionsList, Running/Completed/Failed分類）
- E-15: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/ExecutionPage.scala` - ExecutionPage実装（sqlStore.execution, physicalPlan, jobLinks）
- E-16: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryPage.scala` - StreamingQueryPage実装（allQueryUIData, activeQueries/inactiveQueries分類）
- E-17: `sql/core/src/main/scala/org/apache/spark/sql/streaming/ui/StreamingQueryStatisticsPage.scala` - StreamingQueryStatisticsPage実装（supportedCustomMetrics, StateStoreProvider, D3グラフ）
- E-18: `streaming/src/main/scala/org/apache/spark/streaming/ui/StreamingPage.scala` - StreamingPage実装（StreamingJobProgressListener, scheduling delay/processing time/total delay）
- E-19: `streaming/src/main/scala/org/apache/spark/streaming/ui/BatchPage.scala` - BatchPage実装（Output Operation, SparkJobId, StageData）
- E-20: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala` - SparkConnectServerPage実装（store.getOnlineSessionNum, getTotalRunning）
- E-21: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/ThriftServerPage.scala` - ThriftServerPage実装（store.getOnlineSessionNum, getTotalRunning）
- E-22: `core/src/main/scala/org/apache/spark/deploy/master/ui/MasterPage.scala` - MasterPage実装（RequestMasterState, JsonProtocol, handleAppKillRequest）
- E-23: `core/src/main/scala/org/apache/spark/deploy/master/ui/ApplicationPage.scala` - ApplicationPage実装（RequestMasterState, ExecutorDesc, ExecutorState）
- E-24: `core/src/main/scala/org/apache/spark/deploy/worker/ui/WorkerPage.scala` - WorkerPage実装（RequestWorkerState, ExecutorRunner, DriverRunner）
- E-25: `docs/code-to-docs/画面一覧/画面一覧.csv` - 画面一覧（29画面定義）
- E-26: `docs/code-to-docs/機能一覧/機能一覧.csv` - 機能一覧（97機能定義）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面1-AllJobs: Web UI主機能（store.jobsList利用） | E-01 | ○ |
| C-02 | 画面1-AllJobs: DAGスケジューラ連携（ステージ数参照） | E-01 | ○ |
| C-03 | 画面1-AllJobs: Executorタイムライン表示 | E-01 | ○ |
| C-04 | 画面1-AllJobs: メトリクスシステム（進捗バー表示） | E-01 | ○ |
| C-05 | 画面1-AllJobs: KVStore連携 | E-01 | ○ |
| C-06 | 画面2-JobDetail: Web UI主機能 | E-02 | ○ |
| C-07 | 画面2-JobDetail: DAG可視化（operationGraphForJob） | E-02 | ○ |
| C-08 | 画面2-JobDetail: Executorタイムライン | E-02 | ○ |
| C-09 | 画面2-JobDetail: タスクスケジューラ（タスク進捗） | E-02 | ○ |
| C-10 | 画面2-JobDetail: KVStore連携 | E-02 | ○ |
| C-11 | 画面3-AllStages: Web UI主機能 | E-03 | ○ |
| C-12 | 画面3-AllStages: タスクスケジューラ連携 | E-03 | ○ |
| C-13 | 画面3-AllStages: DAGスケジューラ（FAIRプール） | E-03 | ○ |
| C-14 | 画面3-AllStages: KVStore連携 | E-03 | ○ |
| C-15 | 画面4-StageDetail: Web UI主機能 | E-04 | ○ |
| C-16 | 画面4-StageDetail: タスクスケジューラ（ローカリティ） | E-04 | ○ |
| C-17 | 画面4-StageDetail: DAG可視化（operationGraphForStage） | E-04 | ○ |
| C-18 | 画面4-StageDetail: シャッフル機構メトリクス | E-04 | ○ |
| C-19 | 画面4-StageDetail: メモリ管理（スピル情報） | E-04 | ○ |
| C-20 | 画面4-StageDetail: メトリクスシステム（分布表示） | E-04 | ○ |
| C-21 | 画面4-StageDetail: KVStore連携 | E-04 | ○ |
| C-22 | 画面5-PoolDetail: Web UI主機能 | E-05 | ○ |
| C-23 | 画面5-PoolDetail: タスクスケジューラ（FAIRプール設定） | E-05 | ○ |
| C-24 | 画面5-PoolDetail: DAGスケジューラ（ステージDAG参照） | E-05 | ○ |
| C-25 | 画面6-TaskThreadDump: Web UI主機能 | E-06 | ○ |
| C-26 | 画面6-TaskThreadDump: Executorプロセス管理（getTaskThreadDump） | E-06 | ○ |
| C-27 | 画面7-Storage: Web UI主機能 | E-07 | ○ |
| C-28 | 画面7-Storage: ブロックストレージ管理（rddList） | E-07 | ○ |
| C-29 | 画面7-Storage: KVStore連携 | E-07 | ○ |
| C-30 | 画面8-RDDDetail: Web UI主機能 | E-08 | ○ |
| C-31 | 画面8-RDDDetail: ブロックストレージ管理（dataDistribution） | E-08 | ○ |
| C-32 | 画面8-RDDDetail: Executor情報（executorList突合） | E-08 | ○ |
| C-33 | 画面8-RDDDetail: KVStore連携 | E-08 | ○ |
| C-34 | 画面9-Environment: Web UI主機能 | E-09 | ○ |
| C-35 | 画面9-Environment: メトリクスシステム（metricsProperties） | E-09 | ○ |
| C-36 | 画面9-Environment: セキュリティ管理（Utils.redact） | E-09 | △ |
| C-37 | 画面9-Environment: KVStore連携 | E-09 | ○ |
| C-38 | 画面10-Executors: Web UI主機能 | E-10 | ○ |
| C-39 | 画面10-Executors: Executorプロセス管理（統計情報） | E-10 | ○ |
| C-40 | 画面10-Executors: メモリ管理（OnHeap/OffHeap） | E-10 | △ |
| C-41 | 画面10-Executors: 動的リソース割り当て | E-10 | △ |
| C-42 | 画面10-Executors: メトリクスシステム（Peak Memory） | E-10 | △ |
| C-43 | 画面11-ExecutorThreadDump: Web UI主機能 | E-11 | ○ |
| C-44 | 画面11-ExecutorThreadDump: Executorプロセス管理（getExecutorThreadDump） | E-11 | ○ |
| C-45 | 画面12-HeapHistogram: Web UI主機能 | E-12 | ○ |
| C-46 | 画面12-HeapHistogram: Executorプロセス管理（getExecutorHeapHistogram） | E-12 | ○ |
| C-47 | 画面13-DriverLog: Web UI主機能 | E-13 | ○ |
| C-48 | 画面13-DriverLog: イベントログ記録（ログファイル取得） | E-13 | △ |
| C-49 | 画面14-SQLAllExecutions: Web UI主機能 | E-14 | ○ |
| C-50 | 画面14-SQLAllExecutions: SQLパーサー（SQL文表示） | E-14 | △ |
| C-51 | 画面14-SQLAllExecutions: Catalystオプティマイザ（最適化情報） | E-14 | △ |
| C-52 | 画面14-SQLAllExecutions: KVStore連携 | E-14 | ○ |
| C-53 | 画面15-SQLExecutionDetail: Web UI主機能 | E-15 | ○ |
| C-54 | 画面15-SQLExecutionDetail: Catalystオプティマイザ（物理プラン表示） | E-15 | ○ |
| C-55 | 画面15-SQLExecutionDetail: コード生成（WholeStageCodegen表示） | E-15 | △ |
| C-56 | 画面15-SQLExecutionDetail: DAGスケジューラ（ジョブリンク） | E-15 | ○ |
| C-57 | 画面15-SQLExecutionDetail: KVStore連携 | E-15 | ○ |
| C-58 | 画面16-StreamingQueryList: Web UI主機能 | E-16 | ○ |
| C-59 | 画面16-StreamingQueryList: ストリーム処理エンジン（クエリステータス） | E-16 | ○ |
| C-60 | 画面16-StreamingQueryList: KVStore連携 | E-16 | ○ |
| C-61 | 画面17-StreamingQueryStats: Web UI主機能 | E-17 | ○ |
| C-62 | 画面17-StreamingQueryStats: ストリーム処理エンジン（バッチ統計） | E-17 | ○ |
| C-63 | 画面17-StreamingQueryStats: ステート管理（カスタムメトリクス） | E-17 | ○ |
| C-64 | 画面17-StreamingQueryStats: チェックポイント管理 | E-17 | △ |
| C-65 | 画面18-StreamingOverview: Web UI主機能 | E-18 | ○ |
| C-66 | 画面18-StreamingOverview: DStreamストリーム処理（バッチ統計） | E-18 | ○ |
| C-67 | 画面18-StreamingOverview: レシーバー管理（稼働状況） | E-18 | ○ |
| C-68 | 画面19-BatchDetail: Web UI主機能 | E-19 | ○ |
| C-69 | 画面19-BatchDetail: DStreamストリーム処理（Output Operation） | E-19 | ○ |
| C-70 | 画面19-BatchDetail: DAGスケジューラ（ジョブリンク） | E-19 | ○ |
| C-71 | 画面20-ConnectServerOverview: Web UI主機能 | E-20 | ○ |
| C-72 | 画面20-ConnectServerOverview: Spark Connectサーバー | E-20 | ○ |
| C-73 | 画面20-ConnectServerOverview: KVStore連携 | E-20 | ○ |
| C-74 | 画面21-ConnectSessionDetail: Web UI主機能 | E-20 | ○ |
| C-75 | 画面21-ConnectSessionDetail: Spark Connectサーバー | E-20 | ○ |
| C-76 | 画面22-ThriftServerOverview: Web UI主機能 | E-21 | ○ |
| C-77 | 画面22-ThriftServerOverview: Hiveメタストア連携 | E-21 | ○ |
| C-78 | 画面22-ThriftServerOverview: KVStore連携 | E-21 | ○ |
| C-79 | 画面23-ThriftServerSessionDetail: Web UI主機能 | E-21 | ○ |
| C-80 | 画面23-ThriftServerSessionDetail: Hiveメタストア連携 | E-21 | ○ |
| C-81 | 画面24-MasterOverview: Web UI主機能 | E-22 | ○ |
| C-82 | 画面24-MasterOverview: Standaloneクラスタマネージャ | E-22 | ○ |
| C-83 | 画面24-MasterOverview: 動的リソース割り当て（リソース集計） | E-22 | ○ |
| C-84 | 画面25-ApplicationDetail: Web UI主機能 | E-23 | ○ |
| C-85 | 画面25-ApplicationDetail: Standaloneクラスタマネージャ | E-23 | ○ |
| C-86 | 画面25-ApplicationDetail: Executorプロセス管理 | E-23 | ○ |
| C-87 | 画面26-MasterLog: Web UI主機能 | E-22 | ○ |
| C-88 | 画面26-MasterLog: Standaloneクラスタマネージャ | E-22 | ○ |
| C-89 | 画面27-MasterEnvironment: Web UI主機能 | E-22 | ○ |
| C-90 | 画面27-MasterEnvironment: Standaloneクラスタマネージャ | E-22 | ○ |
| C-91 | 画面28-WorkerOverview: Web UI主機能 | E-24 | ○ |
| C-92 | 画面28-WorkerOverview: Standaloneクラスタマネージャ | E-24 | ○ |
| C-93 | 画面28-WorkerOverview: Executorプロセス管理 | E-24 | ○ |
| C-94 | 画面29-WorkerLog: Web UI主機能 | E-24 | ○ |
| C-95 | 画面29-WorkerLog: Standaloneクラスタマネージャ | E-24 | ○ |

## 4) 不足情報（Unknown / Missing）
- C-36: Utils.redactはSparkConf内の機密値マスク処理であり、セキュリティ管理機能(No.14)の直接利用というよりはユーティリティ的利用。セキュリティ管理モジュール（security/）との直接的なimport関係は確認できていない
  - 候補：security/SecurityManager.scala / SparkConf.scala / Utils.scala
- C-40, C-41, C-42: ExecutorsPageのレンダリングは主にJavaScript（executorspage.js）で行われており、Scala側のソースコードからはメモリ管理・動的リソース割り当て・メトリクスの具体的な参照を直接確認できなかった
  - 候補：static/executorspage.js / ExecutorAllocationManager.scala / MetricsSystem.scala
- C-48: DriverLogPageはRollingFileAppenderを利用してログファイルを取得しており、イベントログ記録機能(No.11: EventLoggingListener)とは別の仕組みである可能性がある
  - 候補：EventLoggingListener.scala / DriverLogger.scala / RollingFileAppender.scala
- C-50, C-51: AllExecutionsPageはSQLAppStatusStoreを参照しており、SQLパーサーやCatalystオプティマイザを直接importしていない。関連は間接的（SQLの実行結果が保存されたデータを表示）
  - 候補：SQLAppStatusStore.scala / SparkPlanGraph.scala
- C-55: ExecutionPageはDAGグラフを表示するが、WholeStageCodegenとの直接的な参照はsparkPlanGraph内で推定
  - 候補：SparkPlanGraph.scala / WholeStageCodegenExec.scala
- C-64: StreamingQueryStatisticsPageでチェックポイント情報はcommitDuration等のメトリクスとして表示される可能性があるが、直接的なチェックポイント管理モジュールの参照は未確認
  - 候補：StreamingQueryStatisticsPage.scala / HDFSMetadataLog.scala

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面1-8, 11-12, 18-19, 24-29のマッピングは、ソースコード内のimport文・API呼び出しから直接確認できており信頼性が高い
- 1: 中リスク - 画面9(セキュリティ管理関連), 画面10(JS動的レンダリング部分), 画面13(ログ機構の区別), 画面14-15(SQL関連の間接的参照), 画面17(チェックポイント関連)は間接的な推定を含む
- 0: 低リスク - 画面16, 20-23のマッピングはストア経由のデータ取得パターンが明確で信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] executorspage.jsの内容を確認し、メモリ管理(No.6)・動的リソース割り当て(No.15)・メトリクスシステム(No.12)との関連が正確か検証する
- [ ] DriverLogPage.scalaの実装を確認し、イベントログ記録(No.11)ではなくDriverLogger固有機能として分類すべきか検討する
- [ ] AllExecutionsPage.scalaとExecutionPage.scalaにおけるSQLパーサー(No.19)・Catalystオプティマイザ(No.20)との関連が間接的で妥当か確認する
- [ ] EnvironmentPage.scalaのUtils.redactがセキュリティ管理機能(No.14)との関連として適切か検討する
- [ ] StreamingQueryStatisticsPage.scalaでチェックポイント管理(No.39)のメトリクスが実際に表示されるか確認する
- [ ] 画面と機能のマッピングに漏れがないか、特にAPI連携種別の分類が適切か確認する
