# 画面設計書 10-Executors（エグゼキュータ一覧）

## 概要

本ドキュメントは、Apache Spark Web UIの「Executors（エグゼキュータ一覧）」画面の設計書である。全エグゼキュータのリソース使用状況・タスク統計をJavaScript（executorspage.js）で動的にレンダリングして表示する。

### 本画面の処理概要

**業務上の目的・背景**：Sparkアプリケーションの全Executorのリソース使用状況をリアルタイムで監視するための画面である。各ExecutorのRDDストレージ使用量、ディスク使用量、アクティブタスク数、失敗タスク数、実行時間、OnHeap/OffHeapメモリ使用状況などを確認できる。Executorの動的追加・削除イベントの情報も含まれる。パフォーマンスチューニング、リソース配分の最適化、Executor障害の検出に使用される。

**画面へのアクセス方法**：SparkアプリケーションWeb UIのナビゲーションバーから「Executors」タブを選択してアクセスする。

**主要な操作・処理内容**：
1. Executorのリソース使用状況・タスク統計の一覧表示（DataTables使用の動的テーブル）
2. Executor Peak Memory Metricsの表示
3. OnHeap/OffHeapメモリ使用状況の表示
4. Thread Dumpページへの遷移（threadDumpEnabled時）
5. Heap Histogramページへの遷移（heapHistogramEnabled時）

**画面遷移**：
- この画面からの遷移先：Executor Thread Dump画面（Thread Dump選択時）、Executor Heap Histogram画面（Heap Histogram選択時）
- この画面への遷移元：全画面からのナビゲーションバー経由

**権限による表示制御**：Thread Dump機能は`spark.ui.threadDumpsEnabled`設定で制御される。Heap Histogram機能は`spark.ui.heapHistogramEnabled`設定で制御される。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 17 | Spark Web UI | 主機能 | 全Executorのリソース使用状況・タスク統計をJavaScript（executorspage.js）で動的レンダリングする主処理 |
| 5 | Executorプロセス管理 | 主機能 | 各ExecutorのRDD Storage・Disk Used・Active Tasks・Failed Tasks・Duration等の統計情報を取得・表示 |
| 6 | メモリ管理 | 補助機能 | ExecutorのOnHeap/OffHeapメモリ使用状況を表示 |
| 15 | 動的リソース割り当て | 補助機能 | Executorの動的追加・削除イベント情報を表示 |
| 12 | メトリクスシステム | 補助機能 | Executor Peak Memory Metricsを取得・表示 |

## 画面種別

一覧

## URL/ルーティング

- パス: `/executors/`
- クラス: `ExecutorsPage` (WebUIPage(""))
- タブ: `ExecutorsTab` (SparkUITab(parent, "executors"))

## 入出力項目

| 項目名 | 入出力 | 型 | 説明 |
|--------|--------|------|------|
| executorId | 入力（URLパラメータ、任意） | String | 特定ExecutorのThread Dump/Heap Histogram表示用（子ページ遷移時） |

## 表示項目

### Executor一覧テーブル（JavaScript動的レンダリング）

executorspage.jsにより動的に生成される。REST API（/api/v1/applications/{appId}/allexecutors）からデータを取得してDataTablesで表示する。

サーバーサイドのScalaコードは`<div id="active-executors"></div>`コンテナのみを提供し、テーブルの実体はJavaScript側で構築される。

### 表示される主な情報（executorspage.jsで構築）

以下はexecutorspage.jsが構築するテーブルの主要カラム（REST APIのExecutorSummaryデータに基づく）：

- Executor ID
- Address (hostPort)
- Status (Active/Dead)
- RDD Blocks
- Storage Memory (used / total)
- Disk Used
- Cores
- Active Tasks
- Failed Tasks
- Complete Tasks
- Total Tasks
- Task Time (duration)
- Input
- Shuffle Read
- Shuffle Write
- Logs (stdout/stderr)

## イベント仕様

### 1-Thread Dump表示

threadDumpEnabledがtrueの場合、executorspage.js内でThread Dumpリンクが表示される。クリックするとExecutor Thread Dump画面に遷移する。JavaScript側でsetThreadDumpEnabled関数により制御される。

### 2-Heap Histogram表示

heapHistogramEnabledがtrueの場合、Heap Histogramリンクが表示される。クリックするとExecutor Heap Histogram画面に遷移する。JavaScript側でsetHeapHistogramEnabled関数により制御される。

### 3-テーブルソート・検索

DataTablesライブラリにより、各カラムでのソートとテーブル検索機能が提供される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| ページ表示 | REST API (AppStatusStore) | SELECT | Executor一覧データをREST API経由で取得（JavaScript側） |

### テーブル別更新項目詳細

本画面はデータの読み取り専用である。サーバーサイドのHTMLレンダリングではKVStoreへのアクセスは行わず、JavaScript側がREST APIを呼び出してデータを取得する。

## メッセージ仕様

特記すべきサーバーサイドのメッセージはない。JavaScriptの動的レンダリングでエラーが発生した場合はブラウザコンソールにエラーが出力される。

## 例外処理

サーバーサイドでの特記すべき例外処理はない。全てのデータ取得・表示処理はJavaScript側（executorspage.js）で行われる。

## 備考

- 本画面のサーバーサイドコードは非常にシンプルで、HTMLコンテナとJavaScriptのロードのみを担当する（ExecutorsPage.renderは約25行）
- テーブルの構築・データ取得は全てexecutorspage.jsが担当し、REST APIからExecutorデータを非同期取得する
- ExecutorsTabクラスのinit()メソッドで、threadDumpEnabledとheapHistogramEnabledの設定に基づいてサブページが登録される
- threadDumpEnabled = sc.isDefined && conf.get(UI_THREAD_DUMPS_ENABLED)
- heapHistogramEnabled = sc.isDefined && conf.get(UI_HEAP_HISTOGRAM_ENABLED)
- useDataTables=trueでDataTablesライブラリが使用される
- utils.jsもscript moduleとして読み込まれる

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | ExecutorSummaryクラス（id, hostPort, isActive, rddBlocks, memoryUsed, diskUsed, totalCores, maxTasks, activeTasks, failedTasks, completedTasks, totalTasks, totalDuration, totalInputBytes, totalShuffleRead, totalShuffleWrite等） |

**読解のコツ**: ExecutorSummaryはREST APIで返されるJSONデータの構造と一致する。executorspage.jsはこのデータを直接パースしてテーブルを構築する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ExecutorsTab（27行目）とExecutorsPage（48行目）を理解する |

**主要処理フロー**:
1. **27-46行目**: ExecutorsTab.init()でthreadDumpEnabled/heapHistogramEnabledを判定し、対応するサブページを登録
2. **32-33行目**: threadDumpEnabled = sc.isDefined && conf.get(UI_THREAD_DUMPS_ENABLED)
3. **34-35行目**: heapHistogramEnabled = sc.isDefined && conf.get(UI_HEAP_HISTOGRAM_ENABLED)
4. **37行目**: ExecutorsPage登録（threadDumpEnabled/heapHistogramEnabled状態を渡す）
5. **38-39行目**: threadDumpEnabled時にExecutorThreadDumpPage登録
6. **41-43行目**: heapHistogramEnabled時にExecutorHeapHistogramPage登録

#### Step 3: ExecutorsPageのレンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ExecutorsPage.render（54行目）がHTMLコンテナとJavaScriptを出力 |

**主要処理フロー**:
1. **55-59行目**: UIUtils.formatImportJavaScriptでexecutorspage.jsからsetThreadDumpEnabled/setHeapHistogramEnabledをインポート
2. **60-66行目**: JavaScript文字列を構築（setThreadDumpEnabled/setHeapHistogramEnabled呼び出し）
3. **67-74行目**: HTMLコンテナ（<div id="active-executors"></div>）とscriptタグを出力
4. **76行目**: UIUtils.headerSparkPage(useDataTables = true)でページをラップ

#### Step 4: JavaScriptの動的レンダリングを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | executorspage.js | `core/src/main/resources/org/apache/spark/ui/static/executorspage.js` | REST API呼び出し、DataTablesによるテーブル構築、threadDump/heapHistogramリンク生成 |

### プログラム呼び出し階層図

```
ExecutorsTab.init()
    |
    +-- new ExecutorsPage(threadDumpEnabled, heapHistogramEnabled)
    +-- (if threadDumpEnabled) new ExecutorThreadDumpPage()
    +-- (if heapHistogramEnabled) new ExecutorHeapHistogramPage()

ExecutorsPage.render(request)
    |
    +-- UIUtils.formatImportJavaScript(executorspage.js)
    +-- setThreadDumpEnabled(boolean)         ... JavaScript変数設定
    +-- setHeapHistogramEnabled(boolean)       ... JavaScript変数設定
    |
    +-- <div id="active-executors"></div>      ... コンテナHTML
    +-- <script src="utils.js"></script>       ... ユーティリティJS
    +-- <script src="executorspage.js"></script> ... メインJS
    |
    +-- UIUtils.headerSparkPage(useDataTables=true)

executorspage.js (ブラウザ側)
    |
    +-- fetch(/api/v1/applications/{appId}/allexecutors)
    |     ... REST API呼び出し
    |
    +-- DataTable構築                          ... テーブルレンダリング
    +-- threadDump/heapHistogramリンク生成
```

### データフロー図

```
[入力]                  [処理]                           [出力]

HttpServletRequest ---> ExecutorsPage.render()
                            |
                        HTML + JavaScript               --> ブラウザ
                            |
                        executorspage.js (ブラウザ側)
                            |
REST API             --> /api/v1/.../allexecutors    --> JSON(ExecutorSummary[])
                            |
                            v
                        DataTables テーブル              --> 画面表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ExecutorsTab.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` | ソース | ExecutorsTab定義とExecutorsPageクラス |
| ExecutorThreadDumpPage.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorThreadDumpPage.scala` | ソース | Executor Thread Dumpサブページ |
| ExecutorHeapHistogramPage.scala | `core/src/main/scala/org/apache/spark/ui/exec/ExecutorHeapHistogramPage.scala` | ソース | Executor Heap Histogramサブページ |
| executorspage.js | `core/src/main/resources/org/apache/spark/ui/static/executorspage.js` | JavaScript | テーブル動的レンダリング（メインロジック） |
| utils.js | `core/src/main/resources/org/apache/spark/ui/static/utils.js` | JavaScript | UIユーティリティ |
| AppStatusStore.scala | `core/src/main/scala/org/apache/spark/status/AppStatusStore.scala` | ソース | REST API経由でのデータ提供元 |
| api.scala | `core/src/main/scala/org/apache/spark/status/api/v1/api.scala` | ソース | ExecutorSummaryデータモデル |
| UIUtils.scala | `core/src/main/scala/org/apache/spark/ui/UIUtils.scala` | ソース | HTML生成ユーティリティ |
