---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 17
  claims_without_evidence: 3
confidence_derived: 0.85
---

# 根拠レポート：10-Executors（エグゼキュータ一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.85**
  - 根拠あり：17 / 20、根拠なし：3
- 優先レビュー（高）
  1. **executorspage.jsのテーブルカラム定義**：JavaScript側の直接読解なし
  2. **REST APIの呼び出しURL**：JavaScript側の直接確認なし
  3. **Peak Memory Metricsの表示詳細**：JavaScript側の処理未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/exec/ExecutorsTab.scala` （ExecutorsTab/ExecutorsPage全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.10の行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.10の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /executors/ | E-01 (27行目: SparkUITab(parent, "executors"), 52行目: WebUIPage("")) | ○ |
| C-02 | threadDumpEnabled = sc.isDefined && UI_THREAD_DUMPS_ENABLED | E-01 (32-33行目) | ○ |
| C-03 | heapHistogramEnabled = sc.isDefined && UI_HEAP_HISTOGRAM_ENABLED | E-01 (34-35行目) | ○ |
| C-04 | ExecutorsPageにthreadDumpEnabled/heapHistogramEnabledを渡す | E-01 (37行目) | ○ |
| C-05 | threadDumpEnabled時にExecutorThreadDumpPage登録 | E-01 (38-39行目) | ○ |
| C-06 | heapHistogramEnabled時にExecutorHeapHistogramPage登録 | E-01 (41-43行目) | ○ |
| C-07 | HTMLコンテナは<div id="active-executors"></div> | E-01 (69行目) | ○ |
| C-08 | executorspage.jsをscript moduleで読み込み | E-01 (71-72行目) | ○ |
| C-09 | utils.jsをscript moduleで読み込み | E-01 (70行目) | ○ |
| C-10 | setThreadDumpEnabled関数呼び出し | E-01 (64行目) | ○ |
| C-11 | setHeapHistogramEnabled関数呼び出し | E-01 (65行目) | ○ |
| C-12 | useDataTables=trueでページラップ | E-01 (76行目) | ○ |
| C-13 | formatImportJavaScriptでインポート | E-01 (55-59行目) | ○ |
| C-14 | ページタイトルは"Executors" | E-01 (76行目) | ○ |
| C-15 | サーバーサイドはHTMLコンテナとJS読み込みのみ | E-01 (54-77行目: renderメソッド全体) | ○ |
| C-16 | ExecutorsTabクラスのinit()で初期化 | E-01 (29-44行目) | ○ |
| C-17 | JavaScript moduleとして読み込み | E-01 (71行目: type="module") | ○ |
| C-18 | テーブルカラムにExecutor ID/Address/Status/RDD Blocks等が含まれる | **根拠なし**（executorspage.jsの直接読解なし） | △ |
| C-19 | REST APIの呼び出しURL /api/v1/.../allexecutors | **根拠なし**（executorspage.jsの直接読解なし） | △ |
| C-20 | Peak Memory Metricsが表示される | **根拠なし**（executorspage.jsの直接読解なし、マッピングCSVに記載あり） | △ |

## 4) 不足情報（Unknown / Missing）
- executorspage.jsの処理内容（テーブルカラム定義、REST API呼び出し、Peak Memory Metrics表示）
  - 候補：`core/src/main/resources/org/apache/spark/ui/static/executorspage.js`
- ExecutorSummaryのREST APIエンドポイント定義
  - 候補：`core/src/main/scala/org/apache/spark/status/api/v1/ApiRootResource.scala`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - サーバーサイドのScalaコードは完全に確認済み
- 2: 高リスク - テーブルのカラム構成・REST API呼び出し等、画面の主要表示ロジックがJavaScript側にあり、直接確認していない

## 6) レビュアーチェックリスト（最小）
- [ ] executorspage.jsのテーブルカラム定義が設計書と一致しているか確認
- [ ] REST APIの呼び出しURLとレスポンス形式を確認
- [ ] Peak Memory Metricsの表示項目と形式を確認
- [ ] DataTablesのソート・検索機能が正しく動作するか確認
- [ ] threadDump/heapHistogramリンクの遷移先URLが正しいか確認
