---
generated_at: 2026-02-03 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-Storage（ストレージ一覧）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/storage/StoragePage.scala` （StoragePageクラス全体）
- E-02: `core/src/main/scala/org/apache/spark/ui/storage/StorageTab.scala` （StorageTabクラス）
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.7の行）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.7の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /storage/ | E-01 (32行目: WebUIPage("")) + E-02 (25行目: SparkUITab(parent, "storage")) | ○ |
| C-02 | store.rddList()でRDD一覧取得 | E-01 (35行目) | ○ |
| C-03 | store.streamBlocksList()でブロック一覧取得 | E-01 (36行目) | ○ |
| C-04 | RDDが空ならテーブル非表示 | E-01 (43-45行目: if rdds.isEmpty Nil) | ○ |
| C-05 | RDDテーブルのカラムは7つ | E-01 (68-75行目: rddHeader) | ○ |
| C-06 | RDD名リンクはRDD Detail画面に遷移 | E-01 (93-94行目: /storage/rdd/?id=) | ○ |
| C-07 | Fraction Cachedは%.2f%%フォーマット | E-01 (101行目) | ○ |
| C-08 | Size in Memory/Diskにsorttable_customkey | E-01 (102-103行目) | ○ |
| C-09 | ストリームブロック空ならセクション非表示 | E-01 (109-110行目: if blocks.isEmpty Nil) | ○ |
| C-10 | Executor別集約テーブルのカラムは5つ | E-01 (136-141行目: executorMetricsTableHeader) | ○ |
| C-11 | ExecutorStreamSummaryクラスで集約 | E-01 (237-248行目) | ○ |
| C-12 | ブロックテーブルのカラムは5つ | E-01 (179-184行目: streamBlockTableHeader) | ○ |
| C-13 | ブロックはgroupByでグループ化 | E-01 (113行目: blocks.groupBy(_.name)) | ○ |
| C-14 | Blocksテーブルはソート不可 | E-01 (174行目: sortable = false) | ○ |
| C-15 | ストレージレベル判定: useDisk -> Memory -> Memory Serialized | E-01 (224-232行目) | ○ |
| C-16 | 不正なStorageLevelでIllegalStateException | E-01 (231行目) | ○ |
| C-17 | レプリケーション数をrowspan表示 | E-01 (207-214行目: firstSubrow判定でrowspan設定) | ○ |
| C-18 | ツールチップはToolTipsオブジェクトから取得 | E-01 (28行目: import ToolTips._) | ○ |
| C-19 | RDDテーブルは折りたたみ可能 | E-01 (48-54行目: collapse-aggregated-rdds) | ○ |
| C-20 | ページタイトルは"Storage" | E-01 (37行目) | ○ |
| C-21 | RDDテーブルIDは"storage-by-rdd-table" | E-01 (60行目) | ○ |
| C-22 | Executor集約テーブルIDは"storage-by-executor-stream-blocks" | E-01 (132行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - StoragePage.scalaの全処理が直接確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] ToolTipsオブジェクトの各定数値が正確か確認
- [ ] bytesToString関数のフォーマット仕様を確認
