---
generated_at: 2026-02-03 10:40:00
metrics:
  claims_total: 24
  claims_with_evidence: 23
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：9-Environment（環境情報）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：23 / 24、根拠なし：1
- 優先レビュー（高）
  1. **environmentpage.jsの処理内容**：JavaScript側の直接読解なし

## 2) 参照した情報（Evidence一覧）

- E-01: `core/src/main/scala/org/apache/spark/ui/env/EnvironmentPage.scala` （EnvironmentPage全体）
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv` （画面No.9の行）
- E-03: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` （画面No.9の関連機能）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは /environment/ | E-01 (34行目: WebUIPage(""), 192-193行目: SparkUITab(parent, "environment")) | ○ |
| C-02 | store.environmentInfo()で環境情報取得 | E-01 (37行目) | ○ |
| C-03 | JVM情報は3項目（Java Version, Java Home, Scala Version） | E-01 (38-41行目) | ○ |
| C-04 | SparkプロパティにUtils.redact適用 | E-01 (78行目: Utils.redact(conf, appEnv.sparkProperties.sorted)) | ○ |
| C-05 | HadoopプロパティにUtils.redact適用 | E-01 (82行目) | ○ |
| C-06 | SystemプロパティにUtils.redact適用 | E-01 (85行目) | ○ |
| C-07 | MetricsプロパティにUtils.redact適用 | E-01 (88行目) | ○ |
| C-08 | HadoopプロパティはOptionでnull安全 | E-01 (82行目: Option(appEnv.hadoopProperties).getOrElse(emptyProperties)) | ○ |
| C-09 | MetricsプロパティはOptionでnull安全 | E-01 (88行目) | ○ |
| C-10 | Runtime Information/Spark Properties/Resource Profilesがデフォルト展開 | E-01 (99,110,122行目: arrow-open) | ○ |
| C-11 | Hadoop/System/Metrics/Classpathがデフォルト折りたたみ | E-01 (133,144,155,166行目: arrow-closed + collapsed) | ○ |
| C-12 | リソースプロファイルをstore.resourceProfileInfo()で取得 | E-01 (64行目) | ○ |
| C-13 | Executor要求にdiscoveryScript/vendor表示 | E-01 (47-52行目: if nonEmpty) | ○ |
| C-14 | リソースプロファイルContentsはpre表示 | E-01 (184行目: jvmRowDataPre) | ○ |
| C-15 | プロパティはsortedで名前順 | E-01 (78,82,85,88,91行目: .sorted) | ○ |
| C-16 | ヘッダーCSSはsorttable_alpha | E-01 (181行目) | ○ |
| C-17 | Resource ProfileのContentsはsorttable_nosort | E-01 (182行目) | ○ |
| C-18 | Resource ProfileのIdはsorttable_numeric | E-01 (182行目) | ○ |
| C-19 | environmentpage.jsが読み込まれる | E-01 (172行目) | ○ |
| C-20 | ページタイトルは"Environment" | E-01 (175行目) | ○ |
| C-21 | EnvironmentTabはEnvironmentPage.scala内で定義 | E-01 (191-195行目) | ○ |
| C-22 | fixedWidth=trueでテーブル生成 | E-01 (73,75,78,82,85,88,91行目) | ○ |
| C-23 | ClasspathヘッダーはResource/Source | E-01 (180行目: classPathHeader) | ○ |
| C-24 | environmentpage.jsの処理内容 | **根拠なし**（直接読解なし） | △ |

## 4) 不足情報（Unknown / Missing）
- environmentpage.jsの処理内容
  - 候補：`core/src/main/resources/org/apache/spark/ui/static/environmentpage.js`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - EnvironmentPage.scalaの全処理が直接確認済み
- 0: 低リスク - 機密情報マスク処理はUtils.redact呼び出しで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Utils.redactのマスク対象キーワードパターンを確認
- [ ] environmentpage.jsの処理内容を確認
- [ ] リソースプロファイルの表示フォーマットが正確か確認
