---
generated_at: 2026-02-04 12:00:00
metrics:
  claims_total: 60
  claims_with_evidence: 48
  claims_without_evidence: 12
confidence_derived: 0.80
---

# 根拠レポート：結合テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された結合テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：48 / 60、根拠なし：12
- 優先レビュー（高）
  1. **IT-051 Kubernetes Pod管理**：実際のKubernetes連携コードの詳細まで検証不足
  2. **IT-052 YARN リソースアロケーション**：実際のYARN連携コードの詳細まで検証不足
  3. **IT-056 Kinesis ストリーム読み取り**：Kinesis連携の実装詳細未確認
  4. **IT-049/050 Streaming ステートストア/チェックポイント**：ストリーミング実行エンジン内部の詳細検証不足
  5. **IT-060 SecurityManager**：セキュリティ関連の具体的テスト手順の根拠が不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` - Spark Connect gRPCサービス定義（executePlan, analyzePlan, config, addArtifacts, artifactStatus, interrupt, reattachExecute, releaseExecute, releaseSession, fetchErrorDetails, cloneSession）
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectExecutePlanHandler.scala` - ExecutePlanハンドラー実装
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectSessionManager.scala` - セッション管理実装（getOrCreateIsolatedSession, cloneSession, periodicMaintenance, closeSession）
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/PreSharedKeyAuthenticationInterceptor.scala` - 認証インターセプター
- E-05: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/DB2IntegrationSuite.scala` - DB2統合テスト（Basic test, Numeric types, Date types, String types, Basic write test, query JDBC option, SPARK-30062, SPARK-42534, SPARK-48269）
- E-06: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/SharedJDBCIntegrationSuite.scala` - 共有JDBC統合テスト（SPARK-52184, SPARK-53386）
- E-07: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/PostgresIntegrationSuite.scala` - PostgreSQL V2統合テスト
- E-08: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/MySQLIntegrationSuite.scala` - MySQL V2統合テスト
- E-09: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/OracleIntegrationSuite.scala` - Oracle V2統合テスト
- E-10: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/MsSqlServerIntegrationSuite.scala` - MsSQL V2統合テスト
- E-11: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/join/` - V2 JDBC Join Pushdown統合テスト群
- E-12: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/v2/*NamespaceSuite.scala` - V2 JDBCネームスペーステスト群
- E-13: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/MariaDBKrbIntegrationSuite.scala` - MariaDB Kerberos統合テスト
- E-14: `connector/docker-integration-tests/src/test/scala/org/apache/spark/sql/jdbc/DB2KrbIntegrationSuite.scala` - DB2 Kerberos統合テスト
- E-15: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaSourceProvider.scala` - Kafkaソースプロバイダー実装
- E-16: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaMicroBatchStream.scala` - Kafka MicroBatchStream実装
- E-17: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaContinuousStream.scala` - Kafka ContinuousStream実装
- E-18: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaBatch.scala` - Kafkaバッチ読み取り実装
- E-19: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/KafkaWrite.scala` / `KafkaBatchWrite.scala` / `KafkaStreamingWrite.scala` - Kafka書き込み実装
- E-20: `connector/kafka-0-10-sql/src/main/scala/org/apache/spark/sql/kafka010/producer/CachedKafkaProducer.scala` - Kafkaプロデューサーキャッシュ
- E-21: `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` - DAGスケジューラー実装
- E-22: `core/src/main/scala/org/apache/spark/rpc/` - RPCフレームワーク実装
- E-23: `core/src/main/scala/org/apache/spark/HeartbeatReceiver.scala` - ハートビート受信実装
- E-24: `core/src/main/scala/org/apache/spark/MapOutputTracker.scala` - マップ出力トラッカー実装
- E-25: `sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/jdbc/JDBCRelation.scala` - JDBC関連データソース実装
- E-26: `sql/core/src/main/scala/org/apache/spark/sql/execution/datasources/DataSource.scala` - DataSource実装
- E-27: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/` - HiveThriftServer2実装群
- E-28: `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/` - Structured Streaming実行エンジン
- E-29: `resource-managers/kubernetes/core/src/main/scala/org/apache/spark/deploy/k8s/` - Kubernetesリソースマネージャー
- E-30: `resource-managers/yarn/src/main/scala/org/apache/spark/deploy/yarn/` - YARNリソースマネージャー
- E-31: `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` - Executor動的アロケーション
- E-32: `core/src/main/scala/org/apache/spark/SecurityManager.scala` / `SSLOptions.scala` - セキュリティ管理
- E-33: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/` - Spark Connect UI実装
- E-34: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectStreamingQueryCache.scala` - ストリーミングクエリキャッシュ
- E-35: `connector/avro/` - Avroコネクター
- E-36: `connector/protobuf/` - Protobufコネクター
- E-37: `connector/kinesis-asl/` - Kinesisコネクター
- E-38: `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` - イベントログ
- E-39: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectExecutionManager.scala` - 実行管理

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | IT-001: ExecutePlanリクエストによるプラン実行 | E-01, E-02 | ○ |
| C-02 | IT-002: AnalyzePlanリクエストによるプラン解析 | E-01 | ○ |
| C-03 | IT-003: Configリクエストによる設定の取得・更新 | E-01 | ○ |
| C-04 | IT-004: アーティファクト追加リクエスト | E-01 | ○ |
| C-05 | IT-005: アーティファクトステータス確認 | E-01 | ○ |
| C-06 | IT-006: 実行中オペレーションの中断 | E-01 | ○ |
| C-07 | IT-007: 実行再接続 | E-01 | ○ |
| C-08 | IT-008: 実行リソース解放 | E-01 | ○ |
| C-09 | IT-009: セッション解放 | E-01 | ○ |
| C-10 | IT-010: セッション複製 | E-01, E-03 | ○ |
| C-11 | IT-011: エラー詳細取得 | E-01 | ○ |
| C-12 | IT-012: セッション管理ライフサイクル | E-03 | ○ |
| C-13 | IT-013: ExecuteHolder作成・管理 | E-02, E-39 | ○ |
| C-14 | IT-014: PreSharedKey認証インターセプター | E-01, E-04 | ○ |
| C-15 | IT-015: DB2 JDBC読み取り | E-05 | ○ |
| C-16 | IT-016: DB2 JDBC書き込み | E-05 | ○ |
| C-17 | IT-017: JDBCクエリオプション | E-05 | ○ |
| C-18 | IT-018: JDBC Truncate付きOverwrite | E-05 | ○ |
| C-19 | IT-019: JDBC Limit Pushdown | E-05 | ○ |
| C-20 | IT-020: JDBC Boolean型マッピング | E-05 | ○ |
| C-21 | IT-021: DB2 GRAPHIC型・BINARY型 | E-05 | ○ |
| C-22 | IT-022: 外部エンジン構文エラー | E-06 | ○ |
| C-23 | IT-023: セミコロン付きクエリ | E-06 | ○ |
| C-24 | IT-024: V2 PostgreSQL操作 | E-07 | ○ |
| C-25 | IT-025: V2 MySQL操作 | E-08 | ○ |
| C-26 | IT-026: V2 Oracle操作 | E-09 | ○ |
| C-27 | IT-027: V2 MsSQL操作 | E-10 | ○ |
| C-28 | IT-028: V2 Join Pushdown | E-11 | ○ |
| C-29 | IT-029: Namespace操作 | E-12 | ○ |
| C-30 | IT-030: Kerberos認証 | E-13, E-14 | ○ |
| C-31 | IT-031: Kafkaソースプロバイダー初期化 | E-15 | ○ |
| C-32 | IT-032: KafkaSource作成 | E-15 | ○ |
| C-33 | IT-033: Kafka MicroBatchStream | E-16 | ○ |
| C-34 | IT-034: Kafka ContinuousStream | E-17 | ○ |
| C-35 | IT-035: Kafkaバッチ読み取り | E-18 | ○ |
| C-36 | IT-036: Kafka書き込み | E-19, E-20 | ○ |
| C-37 | IT-037: Kafkaストリーミング書き込み | E-19, E-20 | ○ |
| C-38 | IT-038: DAGScheduler-TaskScheduler連携 | E-21 | ○ |
| C-39 | IT-039: シャッフル障害復旧 | E-21 | ○ |
| C-40 | IT-040: HeartbeatReceiver通信 | E-22, E-23 | ○ |
| C-41 | IT-041: MapOutputTracker同期 | E-24 | ○ |
| C-42 | IT-042: BlockManager格納・取得 | **根拠なし** | △ |
| C-43 | IT-043: ContextCleanerリソース管理 | **根拠なし** | △ |
| C-44 | IT-044: SparkSession-Catalog操作 | **根拠なし** | △ |
| C-45 | IT-045: DataSource ファイル形式読み書き | E-26 | ○ |
| C-46 | IT-046: Hive Metastore連携 | **根拠なし** | △ |
| C-47 | IT-047: HiveThriftServer JDBC接続 | E-27 | ○ |
| C-48 | IT-048: HiveThriftServerメタデータ操作 | E-27 | ○ |
| C-49 | IT-049: Streamingステートストア | **根拠なし** | △ |
| C-50 | IT-050: Streamingチェックポイント | **根拠なし** | △ |
| C-51 | IT-051: Kubernetes Pod管理 | **根拠なし** | △ |
| C-52 | IT-052: YARN リソースアロケーション | **根拠なし** | △ |
| C-53 | IT-053: EventLogging-History Server | E-38 | ○ |
| C-54 | IT-054: Spark Connect UI連携 | E-33 | ○ |
| C-55 | IT-055: Spark Connectストリーミングキャッシュ | E-34 | ○ |
| C-56 | IT-056: Kinesisストリーム読み取り | **根拠なし** | △ |
| C-57 | IT-057: Avro DataSource連携 | E-35 | ○ |
| C-58 | IT-058: Protobuf DataSource連携 | E-36 | ○ |
| C-59 | IT-059: Executor動的アロケーション | E-31 | ○ |
| C-60 | IT-060: SecurityManager認証・認可 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **BlockManager連携 (C-42)**: BlockManagerのソースコードを直接閲覧していないため、詳細なテスト手順の根拠が不足
  - 候補：`core/src/main/scala/org/apache/spark/storage/BlockManager.scala` / テストスイートの確認
- **ContextCleaner連携 (C-43)**: ContextCleanerのソースコードを直接閲覧していないため、クリーンアップ対象やタイミングの根拠が不足
  - 候補：`core/src/main/scala/org/apache/spark/ContextCleaner.scala` / テストスイートの確認
- **Catalog操作 (C-44)**: SessionCatalog/ExternalCatalogの具体的な実装を未確認
  - 候補：`sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/` の確認
- **Hive Metastore (C-46)**: HiveExternalCatalogの実装詳細を未確認
  - 候補：`sql/hive/src/main/scala/org/apache/spark/sql/hive/` の確認
- **Streamingステートストア/チェックポイント (C-49, C-50)**: ストリーミング実行エンジンの内部実装の詳細確認が不足
  - 候補：`sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/state/` / `sql/core/src/main/scala/org/apache/spark/sql/execution/streaming/checkpointing/`
- **Kubernetes/YARN連携 (C-51, C-52)**: リソースマネージャーの実装は存在を確認したが、テスト手順の詳細根拠が不足
  - 候補：`resource-managers/kubernetes/` / `resource-managers/yarn/` のテストスイート
- **Kinesisストリーム (C-56)**: Kinesisコネクターのディレクトリ存在は確認したが、実装詳細は未確認
  - 候補：`connector/kinesis-asl/src/main/scala/` の確認
- **SecurityManager (C-60)**: SecurityManager/SSLOptionsの存在は確認したが、テスト手順の詳細根拠が不足
  - 候補：`core/src/main/scala/org/apache/spark/SecurityManager.scala` の詳細確認

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: IT-051 (Kubernetes), IT-052 (YARN) - 外部リソースマネージャーとの連携はインフラ依存性が高く、テスト環境構築の難易度が高い
- **リスク2（高）**: IT-060 (SecurityManager) - セキュリティに関わるため、テストケースの正確性が重要
- **リスク1（中）**: IT-042 (BlockManager), IT-043 (ContextCleaner), IT-044 (Catalog) - コアコンポーネント連携のテスト手順に根拠不足がある
- **リスク1（中）**: IT-049, IT-050 (Streaming) - ステートフルストリーミングの結合テストは内部状態管理の理解が必要
- **リスク1（中）**: IT-046 (Hive Metastore) - Hive連携は設定依存性が高い
- **リスク0（低）**: IT-001〜IT-014 (Spark Connect gRPC) - ソースコードを直接確認済みで根拠が明確
- **リスク0（低）**: IT-015〜IT-023 (DB2 JDBC) - テストスイートのソースコードを直接確認済み
- **リスク0（低）**: IT-031〜IT-037 (Kafka) - ソースコードの存在と構造を確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Spark Connect gRPCテストケース（IT-001〜IT-014）のテスト手順がSparkConnectService.scalaのメソッドシグネチャと一致しているか
- [ ] DB2統合テストケース（IT-015〜IT-021）のテスト手順がDB2IntegrationSuite.scalaの実際のテストケースと対応しているか
- [ ] JDBC V2テストケース（IT-024〜IT-029）でカバーされるデータベースが、docker-integration-testsディレクトリ内の実際のテストスイートと一致しているか
- [ ] Kafkaテストケース（IT-031〜IT-037）がKafkaSourceProvider/KafkaWrite等の主要なAPI境界を網羅しているか
- [ ] コアコンポーネント連携テスト（IT-038〜IT-043）の前提条件と期待結果が実装と整合しているか
- [ ] Kubernetes/YARN連携テスト（IT-051, IT-052）のテスト手順がリソースマネージャー実装の実際のインターフェースに基づいているか
- [ ] 全60テストケースの優先度設定が、プロジェクトの重要度とリスクに基づいて適切であるか
- [ ] 根拠なし（△）の12件について、追加のソースコード調査により根拠を補完する必要があるか判断する
