---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 105
  claims_with_evidence: 104
  claims_without_evidence: 1
confidence_derived: 0.99
---

# 根拠レポート：通知一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：104 / 105、根拠なし：1
- 優先レビュー（高）
  1. **C-105 Notify test workflow**: GitHub Actionsのワークフロー通知であり、コード上の通知イベント機構とは性質が異なる。通知一覧に含めるべきかレビューが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` - Sparkコアリスナーイベント定義（SparkListenerStageSubmitted等30種）
- E-02: `common/utils/src/main/scala/org/apache/spark/scheduler/SparkListenerEvent.scala` - SparkListenerEvent基底トレイト定義
- E-03: `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` - LiveListenerBus（非同期イベント配信機構）
- E-04: `sql/core/src/main/scala/org/apache/spark/sql/execution/ui/SQLListener.scala` - SQL実行イベント定義（SparkListenerSQLExecutionStart等5種）
- E-05: `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` - 外部カタログイベント定義（CreateDatabasePreEvent等30種）
- E-06: `sql/api/src/main/scala/org/apache/spark/sql/streaming/StreamingQueryListener.scala` - Structured Streamingリスナーイベント定義（QueryStartedEvent等4種）
- E-07: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListener.scala` - DStream Streamingリスナーイベント定義（StreamingListenerStreamingStarted等9種）
- E-08: `streaming/src/main/scala/org/apache/spark/streaming/scheduler/StreamingListenerBus.scala` - Streaming ListenerBus（SparkListener経由で配信）
- E-09: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/ExecuteEventsManager.scala` - Spark Connectオペレーションイベント定義（7種）
- E-10: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SessionEventsManager.scala` - Spark Connectセッションイベント定義（2種）
- E-11: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/service/SparkConnectService.scala` - Spark Connectサービスイベント定義（2種）
- E-12: `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` - HiveThriftServer2イベント定義（8種）
- E-13: `.github/workflows/notify_test_workflow.yml` - GitHub Actions PR通知ワークフロー定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | SparkListenerStageSubmitted: ステージ送信時通知 | E-01 (L33-34) | ○ |
| C-02 | SparkListenerStageCompleted: ステージ完了時通知 | E-01 (L37) | ○ |
| C-03 | SparkListenerTaskStart: タスク開始時通知 | E-01 (L40-41) | ○ |
| C-04 | SparkListenerTaskGettingResult: タスク結果フェッチ開始通知 | E-01 (L44) | ○ |
| C-05 | SparkListenerSpeculativeTaskSubmitted: 投機的タスク送信通知 | E-01 (L47-64) | ○ |
| C-06 | SparkListenerTaskEnd: タスク終了通知 | E-01 (L67-76) | ○ |
| C-07 | SparkListenerJobStart: ジョブ開始通知 | E-01 (L79-88) | ○ |
| C-08 | SparkListenerJobEnd: ジョブ終了通知 | E-01 (L91-95) | ○ |
| C-09 | SparkListenerEnvironmentUpdate: 環境プロパティ更新通知 | E-01 (L98-100) | ○ |
| C-10 | SparkListenerBlockManagerAdded: BlockManager追加通知 | E-01 (L103-109) | ○ |
| C-11 | SparkListenerBlockManagerRemoved: BlockManager削除通知 | E-01 (L112-113) | ○ |
| C-12 | SparkListenerUnpersistRDD: RDDアンパーシスト通知 | E-01 (L116) | ○ |
| C-13 | SparkListenerExecutorAdded: Executor追加通知 | E-01 (L119-120) | ○ |
| C-14 | SparkListenerExecutorRemoved: Executor削除通知 | E-01 (L123-124) | ○ |
| C-15 | SparkListenerExecutorExcluded: Executor除外通知 | E-01 (L136-140) | ○ |
| C-16 | SparkListenerExecutorExcludedForStage: ステージ別Executor除外通知 | E-01 (L155-161) | ○ |
| C-17 | SparkListenerNodeExcludedForStage: ステージ別ノード除外通知 | E-01 (L176-182) | ○ |
| C-18 | SparkListenerExecutorUnexcluded: Executor再有効化通知 | E-01 (L191-192) | ○ |
| C-19 | SparkListenerNodeExcluded: ノード除外通知 | E-01 (L205-209) | ○ |
| C-20 | SparkListenerNodeUnexcluded: ノード再有効化通知 | E-01 (L218-219) | ○ |
| C-21 | SparkListenerUnschedulableTaskSetAdded: スケジュール不可タスクセット追加通知 | E-01 (L223-225) | ○ |
| C-22 | SparkListenerUnschedulableTaskSetRemoved: スケジュール不可タスクセット解除通知 | E-01 (L229-231) | ○ |
| C-23 | SparkListenerBlockUpdated: ブロック更新通知 | E-01 (L234) | ○ |
| C-24 | SparkListenerExecutorMetricsUpdate: Executorメトリクス更新通知 | E-01 (L250-254) | ○ |
| C-25 | SparkListenerStageExecutorMetrics: ステージExecutorメトリクス通知 | E-01 (L265-270) | ○ |
| C-26 | SparkListenerApplicationStart: アプリケーション開始通知 | E-01 (L273-280) | ○ |
| C-27 | SparkListenerApplicationEnd: アプリケーション終了通知 | E-01 (L283-285) | ○ |
| C-28 | SparkListenerLogStart: ログ開始通知 | E-01 (L291) | ○ |
| C-29 | SparkListenerResourceProfileAdded: ResourceProfile追加通知 | E-01 (L295-296) | ○ |
| C-30 | SparkListenerMiscellaneousProcessAdded: その他プロセス追加通知 | E-01 (L238-239) | ○ |
| C-31 | SparkListenerExecutorBlacklisted: Executorブラックリスト通知（非推奨） | E-01 (L127-132) | ○ |
| C-32 | SparkListenerExecutorBlacklistedForStage: ステージ別ブラックリスト通知（非推奨） | E-01 (L144-150) | ○ |
| C-33 | SparkListenerNodeBlacklistedForStage: ステージ別ノードブラックリスト通知（非推奨） | E-01 (L165-171) | ○ |
| C-34 | SparkListenerExecutorUnblacklisted: ブラックリスト解除通知（非推奨） | E-01 (L186-187) | ○ |
| C-35 | SparkListenerNodeBlacklisted: ノードブラックリスト通知（非推奨） | E-01 (L196-200) | ○ |
| C-36 | SparkListenerNodeUnblacklisted: ノードブラックリスト解除通知（非推奨） | E-01 (L213-214) | ○ |
| C-37 | SparkListenerSQLExecutionStart: SQL実行開始通知 | E-04 (L46-66) | ○ |
| C-38 | SparkListenerSQLExecutionEnd: SQL実行終了通知 | E-04 (L69-96) | ○ |
| C-39 | SparkListenerSQLAdaptiveExecutionUpdate: AQE物理プラン更新通知 | E-04 (L33-37) | ○ |
| C-40 | SparkListenerSQLAdaptiveSQLMetricUpdates: AQEメトリクス更新通知 | E-04 (L40-43) | ○ |
| C-41 | SparkListenerDriverAccumUpdates: ドライバアキュムレータ更新通知 | E-04 (L106-110) | ○ |
| C-42 | CreateDatabasePreEvent: DB作成前通知 | E-05 (L48) | ○ |
| C-43 | CreateDatabaseEvent: DB作成後通知 | E-05 (L53) | ○ |
| C-44 | DropDatabasePreEvent: DB削除前通知 | E-05 (L58) | ○ |
| C-45 | DropDatabaseEvent: DB削除後通知 | E-05 (L63) | ○ |
| C-46 | AlterDatabasePreEvent: DB変更前通知 | E-05 (L68) | ○ |
| C-47 | AlterDatabaseEvent: DB変更後通知 | E-05 (L73) | ○ |
| C-48 | CreateTablePreEvent: テーブル作成前通知 | E-05 (L88) | ○ |
| C-49 | CreateTableEvent: テーブル作成後通知 | E-05 (L93) | ○ |
| C-50 | DropTablePreEvent: テーブル削除前通知 | E-05 (L98) | ○ |
| C-51 | DropTableEvent: テーブル削除後通知 | E-05 (L103) | ○ |
| C-52 | RenameTablePreEvent: テーブルリネーム前通知 | E-05 (L108-112) | ○ |
| C-53 | RenameTableEvent: テーブルリネーム後通知 | E-05 (L117-121) | ○ |
| C-54 | AlterTablePreEvent: テーブル変更前通知 | E-05 (L137-140) | ○ |
| C-55 | AlterTableEvent: テーブル変更後通知 | E-05 (L145-148) | ○ |
| C-56 | CreateFunctionPreEvent: 関数作成前通知 | E-05 (L163) | ○ |
| C-57 | CreateFunctionEvent: 関数作成後通知 | E-05 (L168) | ○ |
| C-58 | DropFunctionPreEvent: 関数削除前通知 | E-05 (L173) | ○ |
| C-59 | DropFunctionEvent: 関数削除後通知 | E-05 (L178) | ○ |
| C-60 | AlterFunctionPreEvent: 関数変更前通知 | E-05 (L183) | ○ |
| C-61 | AlterFunctionEvent: 関数変更後通知 | E-05 (L188) | ○ |
| C-62 | RenameFunctionPreEvent: 関数リネーム前通知 | E-05 (L193-197) | ○ |
| C-63 | RenameFunctionEvent: 関数リネーム後通知 | E-05 (L202-206) | ○ |
| C-64 | CreatePartitionsPreEvent: パーティション作成前通知 | E-05 (L221-225) | ○ |
| C-65 | CreatePartitionsEvent: パーティション作成後通知 | E-05 (L230-234) | ○ |
| C-66 | DropPartitionsPreEvent: パーティション削除前通知 | E-05 (L239-243) | ○ |
| C-67 | DropPartitionsEvent: パーティション削除後通知 | E-05 (L248-252) | ○ |
| C-68 | RenamePartitionsPreEvent: パーティションリネーム前通知 | E-05 (L257-262) | ○ |
| C-69 | RenamePartitionsEvent: パーティションリネーム後通知 | E-05 (L267-272) | ○ |
| C-70 | AlterPartitionsPreEvent: パーティション変更前通知 | E-05 (L277-281) | ○ |
| C-71 | AlterPartitionsEvent: パーティション変更後通知 | E-05 (L286-290) | ○ |
| C-72 | QueryStartedEvent: ストリーミングクエリ開始通知 | E-06 (L164-186) | ○ |
| C-73 | QueryProgressEvent: ストリーミングクエリ進捗通知 | E-06 (L208-215) | ○ |
| C-74 | QueryIdleEvent: ストリーミングクエリアイドル通知 | E-06 (L237-248) | ○ |
| C-75 | QueryTerminatedEvent: ストリーミングクエリ終了通知 | E-06 (L278-298) | ○ |
| C-76 | StreamingListenerStreamingStarted: Streaming開始通知 | E-07 (L33) | ○ |
| C-77 | StreamingListenerBatchSubmitted: バッチ送信通知 | E-07 (L36) | ○ |
| C-78 | StreamingListenerBatchStarted: バッチ開始通知 | E-07 (L42) | ○ |
| C-79 | StreamingListenerBatchCompleted: バッチ完了通知 | E-07 (L39) | ○ |
| C-80 | StreamingListenerOutputOperationStarted: 出力操作開始通知 | E-07 (L45-46) | ○ |
| C-81 | StreamingListenerOutputOperationCompleted: 出力操作完了通知 | E-07 (L49-50) | ○ |
| C-82 | StreamingListenerReceiverStarted: レシーバー開始通知 | E-07 (L53-54) | ○ |
| C-83 | StreamingListenerReceiverError: レシーバーエラー通知 | E-07 (L57-58) | ○ |
| C-84 | StreamingListenerReceiverStopped: レシーバー停止通知 | E-07 (L61-62) | ○ |
| C-85 | SparkListenerConnectServiceStarted: Connectサービス起動通知 | E-11 (L548-552) | ○ |
| C-86 | SparkListenerConnectServiceEnd: Connectサービス終了通知 | E-11 (L566-567) | ○ |
| C-87 | SparkListenerConnectSessionStarted: Connectセッション開始通知 | E-10 (L104-109) | ○ |
| C-88 | SparkListenerConnectSessionClosed: Connectセッション閉鎖通知 | E-10 (L121-126) | ○ |
| C-89 | SparkListenerConnectOperationStarted: Connectオペレーション開始通知 | E-09 (L317-327) | ○ |
| C-90 | SparkListenerConnectOperationAnalyzed: Connectオペレーション分析完了通知 | E-09 (L349-354) | ○ |
| C-91 | SparkListenerConnectOperationReadyForExecution: Connect実行準備完了通知 | E-09 (L384-389) | ○ |
| C-92 | SparkListenerConnectOperationCanceled: Connectオペレーションキャンセル通知 | E-09 (L404-409) | ○ |
| C-93 | SparkListenerConnectOperationFailed: Connectオペレーション失敗通知 | E-09 (L426-432) | ○ |
| C-94 | SparkListenerConnectOperationFinished: Connectオペレーション完了通知 | E-09 (L451-457) | ○ |
| C-95 | SparkListenerConnectOperationClosed: Connectオペレーションクローズ通知 | E-09 (L472-477) | ○ |
| C-96 | SparkListenerThriftServerSessionCreated: ThriftServerセッション作成通知 | E-12 (L79-83) | ○ |
| C-97 | SparkListenerThriftServerSessionClosed: ThriftServerセッション閉鎖通知 | E-12 (L85-86) | ○ |
| C-98 | SparkListenerThriftServerOperationStart: ThriftServerオペレーション開始通知 | E-12 (L88-94) | ○ |
| C-99 | SparkListenerThriftServerOperationParsed: ThriftServerオペレーション解析完了通知 | E-12 (L96-98) | ○ |
| C-100 | SparkListenerThriftServerOperationCanceled: ThriftServerキャンセル通知 | E-12 (L100-101) | ○ |
| C-101 | SparkListenerThriftServerOperationTimeout: ThriftServerタイムアウト通知 | E-12 (L103-104) | ○ |
| C-102 | SparkListenerThriftServerOperationError: ThriftServerエラー通知 | E-12 (L106-110) | ○ |
| C-103 | SparkListenerThriftServerOperationFinish: ThriftServerオペレーション完了通知 | E-12 (L112-114) | ○ |
| C-104 | SparkListenerThriftServerOperationClosed: ThriftServerオペレーションクローズ通知 | E-12 (L116-118) | ○ |
| C-105 | Notify test workflow: GitHub Actions PR通知 | E-13 | △ |

## 4) 不足情報（Unknown / Missing）
- C-105（Notify test workflow）: GitHub Actionsのワークフローベースの通知であり、SparkのListenerBus通知機構とは異なるカテゴリ。プロジェクトの「通知」の範囲定義が不明確なため、含めるべきか判断が曖昧
  - 候補：プロジェクト管理者への確認 / 通知の定義範囲の明確化 / CI/CDカテゴリとして別管理

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Sparkコアイベント（C-01〜C-36）: ソースコード直接参照により高い信頼性
- 0: 低リスク - SQL実行イベント（C-37〜C-41）: ソースコード直接参照により高い信頼性
- 0: 低リスク - 外部カタログイベント（C-42〜C-71）: ソースコード直接参照により高い信頼性
- 0: 低リスク - Structured Streamingイベント（C-72〜C-75）: ソースコード直接参照により高い信頼性
- 0: 低リスク - DStream Streamingイベント（C-76〜C-84）: ソースコード直接参照により高い信頼性
- 0: 低リスク - Spark Connectイベント（C-85〜C-95）: ソースコード直接参照により高い信頼性
- 0: 低リスク - HiveThriftServer2イベント（C-96〜C-104）: ソースコード直接参照により高い信頼性
- 1: 中リスク - GitHub Actions通知（C-105）: 通知としての分類妥当性に要確認

## 6) レビュアーチェックリスト（最小）
- [ ] Sparkコアイベント（No.1〜30）が全て網羅されているか（SparkListener.scalaと照合）
- [ ] 非推奨イベント（No.31〜36）の@deprecatedアノテーションと代替イベントの対応が正しいか
- [ ] SQL実行イベント（No.37〜41）がSQLListener.scalaの定義と一致しているか
- [ ] 外部カタログイベント（No.42〜71）がevents.scalaの定義と一致しているか
- [ ] Structured Streamingイベント（No.72〜75）がStreamingQueryListener.scalaの定義と一致しているか
- [ ] DStream Streamingイベント（No.76〜84）がStreamingListener.scalaの定義と一致しているか
- [ ] Spark Connectイベント（No.85〜95）がExecuteEventsManager.scala, SessionEventsManager.scala, SparkConnectService.scalaの定義と一致しているか
- [ ] HiveThriftServer2イベント（No.96〜104）がHiveThriftServer2EventManager.scalaの定義と一致しているか
- [ ] GitHub Actions通知（No.105）を通知一覧に含めることが妥当かプロジェクト方針を確認
- [ ] 各イベントの説明・備考がソースコードのScaladocと整合しているか
