# 通知設計書 10-SparkListenerBlockManagerAdded

## 概要

本ドキュメントは、Apache Sparkのコアイベント通知である`SparkListenerBlockManagerAdded`の設計について記述する。このイベントは、新しいBlockManagerがクラスタに参加した際に発火するイベント通知である。

### 本通知の処理概要

SparkListenerBlockManagerAddedは、ExecutorがBlockManagerを登録し、クラスタのストレージリソースとして利用可能になったことをリスナーに通知するイベントである。

**業務上の目的・背景**：BlockManagerはSparkのストレージサブシステムの中核であり、RDDのキャッシュデータ、シャッフルデータ、ブロードキャスト変数などを管理する。新しいExecutorがクラスタに参加するとBlockManagerがドライバに登録され、このイベントが発火する。Spark UIの「Storage」タブや「Executors」タブでストレージ容量の表示に利用される。動的リソース割り当てにおいて、利用可能なストレージ容量の追跡にも活用される。

**通知の送信タイミング**：BlockManagerMasterEndpointの`register`メソッド内で、新しいBlockManagerの情報がドライバ側のマップに登録された後に発火する（BlockManagerMasterEndpoint.scala L743-744）。

**通知の受信者**：SparkListenerInterfaceを実装し、LiveListenerBusに登録されたすべてのリスナーが受信する。

**通知内容の概要**：time（登録時刻）、blockManagerId（BlockManagerId: executorId, host, port）、maxMem（最大メモリ: onHeap + offHeap）、maxOnHeapMem（最大オンヒープメモリ、Option型）、maxOffHeapMem（最大オフヒープメモリ、Option型）を含む。

**期待されるアクション**：受信したリスナーは、新しいBlockManagerの情報をUIに反映する、イベントログに記録する、クラスタの利用可能ストレージ容量を更新する。

## 通知種別

アプリ内通知（Sparkイベントバス経由の非同期インプロセス通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

LiveListenerBusに登録された全リスナーに対してブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、Sparkイベントバス経由のインプロセス通知である。

### 本文テンプレート

```
イベントクラス: SparkListenerBlockManagerAdded
シリアライズ形式: JSON（Jackson, @JsonTypeInfo）

{
  "Event": "org.apache.spark.scheduler.SparkListenerBlockManagerAdded",
  "Block Manager ID": {
    "Executor ID": "<string>",
    "Host": "<string>",
    "Port": <int>
  },
  "Maximum Memory": <long>,
  "Maximum Onheap Memory": <long>,
  "Maximum Offheap Memory": <long>,
  "Timestamp": <long>
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | インプロセス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | 登録時刻（ミリ秒） | System.currentTimeMillis() (BlockManagerMasterEndpoint内) | Yes |
| blockManagerId | BlockManager識別子（executorId, host, port） | BlockManagerId | Yes |
| maxMem | 最大メモリ（onHeap + offHeap） | maxOnHeapMemSize + maxOffHeapMemSize | Yes |
| maxOnHeapMem | 最大オンヒープメモリ | Option[Long]、Some(maxOnHeapMemSize) | No（Option型、デフォルトNone） |
| maxOffHeapMem | 最大オフヒープメモリ | Option[Long]、Some(maxOffHeapMemSize) | No（Option型、デフォルトNone） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ストレージ管理 | BlockManagerMasterEndpoint.register | 新しいBlockManagerの登録成功時 | BlockManagerMasterEndpoint.scala L743-744 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 再登録失敗（Executor喪失済み） | BlockManagerの再登録時にExecutorが既に喪失している場合、イベントは発火するが再登録自体は無効化される（L746-758） |
| LiveListenerBus停止後 | イベントは配信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executorが起動] --> B[BlockManager初期化]
    B --> C[BlockManagerMaster.registerBlockManager]
    C --> D[BlockManagerMasterEndpoint.register]
    D --> E[blockManagerInfo Mapに登録]
    E --> F{pushBasedShuffle有効?}
    F -->|Yes| G[addMergerLocation]
    F -->|No| H[スキップ]
    G --> I[SparkListenerBlockManagerAdded生成]
    H --> I
    I --> J[listenerBus.post]
    J --> K[各リスナーのonBlockManagerAdded呼び出し]
    K --> L[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| KVStore | AppStatusListenerがBlockManager情報を格納 | UI表示用（Executorsタブ） |

### テーブル別参照項目詳細

#### KVStore

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| ExecutorSummaryWrapper | Executorのストレージ情報 | executorIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KVStore | INSERT/UPDATE | BlockManager情報をExecutorサマリに反映 |
| イベントログファイル | APPEND | イベントをJSON記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | ExecutorSummaryWrapper | maxMemory, onHeapMem, offHeapMem | AppStatusListenerによる更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キューオーバーフロー | イベント生成速度超過 | イベントドロップ |
| リスナー例外 | onBlockManagerAdded内で例外 | 例外キャッチ、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| キュー容量 | デフォルト10,000イベント |

### 配信時間帯

時間帯制限なし。Executor起動時に発火。

## セキュリティ考慮事項

- BlockManagerIdにはexecutorId、host、port等のインフラ情報が含まれる
- メモリ容量情報はシステムのリソース情報であり、直接的な機密情報ではないが、インフラ構成の推定に利用可能

## 備考

- SparkListenerBlockManagerAddedは5フィールドのケースクラスである（SparkListener.scala L103-109）
- maxOnHeapMemとmaxOffHeapMemはOption[Long]型でデフォルト値はNone。後方互換性のためにOption型となっている
- maxMemはmaxOnHeapMemSize + maxOffHeapMemSizeの合計値として計算される（BlockManagerMasterEndpoint.scala L743-744）
- BlockManagerMasterEndpointからのpost時にはSome(maxOnHeapMemSize)とSome(maxOffHeapMemSize)が明示的に渡される
- 再登録シナリオ（Executor再起動時）では、再登録失敗時にBlockManagerIdのexecutorIdが"invalid"に設定される場合がある（L757-758）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | L103-109: SparkListenerBlockManagerAddedケースクラス。5フィールド（time, blockManagerId, maxMem, maxOnHeapMem, maxOffHeapMem）。maxOnHeapMemとmaxOffHeapMemはOption[Long]でデフォルトNone |

**読解のコツ**: BlockManagerId（executorId: String, host: String, port: Int）の構造も確認する。`storage`パッケージに定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BlockManagerMasterEndpoint.scala | `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` | L737-744: register メソッド内。blockManagerInfoマップへの登録後にSparkListenerBlockManagerAddedをpost。L743-744: `listenerBus.post(SparkListenerBlockManagerAdded(time, id, maxOnHeapMemSize + maxOffHeapMemSize, Some(maxOnHeapMemSize), Some(maxOffHeapMemSize)))` |

**主要処理フロー**:
1. **L737**: blockManagerInfoにBlockManagerInfoオブジェクトを登録
2. **L740-741**: pushBasedShuffleが有効な場合、addMergerLocationを呼び出し
3. **L743-744**: `SparkListenerBlockManagerAdded`を生成しpost。maxMemはonHeap+offHeapの合計値
4. **L746-758**: 再登録シナリオの処理（Executor喪失時はinvalidなIDを返す）

#### Step 3: イベントディスパッチを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | L48-49: SparkListenerBlockManagerAddedのパターンマッチ → listener.onBlockManagerAdded()呼び出し |

### プログラム呼び出し階層図

```
Executor (BlockManager初期化)
    |
    +-- BlockManager.register()
            |
            +-- BlockManagerMaster.registerBlockManager()
                    |
                    +-- [RPC] BlockManagerMasterEndpoint.register() [L737]
                            |
                            +-- blockManagerInfo(id) = new BlockManagerInfo(...)
                            |
                            +-- listenerBus.post(SparkListenerBlockManagerAdded(...)) [L743]
                                    |
                                    +-- LiveListenerBus.post()
                                            |
                                            +-- AsyncEventQueue.post() [各キュー]
                                                    |
                                                    +-- listener.onBlockManagerAdded()
                                                            |
                                                            +-- AppStatusListener (Executor情報更新)
                                                            +-- EventLoggingListener (イベントログ)
```

### データフロー図

```
[入力]                              [処理]                           [出力]

BlockManagerMasterEndpoint       LiveListenerBus                  各リスナー
(time, blockManagerId,          (AsyncEventQueue x N)
 maxOnHeapMemSize,
 maxOffHeapMemSize)
                                                                  AppStatusListener
time -----------------------> SparkListenerBlockManagerAdded ----> (KVStore: Executor情報)
blockManagerId                                                    EventLoggingListener
maxMem (onHeap + offHeap)                                         (イベントログ)
Some(maxOnHeapMem)
Some(maxOffHeapMem)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | SparkListenerBlockManagerAddedケースクラス定義（L103-109） |
| BlockManagerMasterEndpoint.scala | `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` | ソース | registerメソッドからのイベント発火（L737-744） |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ（L48-49） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期配信制御 |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | Executor/Storage情報の更新 |
| BlockManagerId.scala | `core/src/main/scala/org/apache/spark/storage/BlockManagerId.scala` | ソース | BlockManagerId（executorId, host, port）の定義 |
