# 通知設計書 100-SparkListenerThriftServerOperationCanceled

## 概要

本ドキュメントは、Apache SparkのHive ThriftServer2モジュールにおける `SparkListenerThriftServerOperationCanceled` イベント通知の設計を記述する。このイベントは、ThriftServerオペレーションがキャンセルされた際に発火する内部イベントである。

### 本通知の処理概要

本通知は、Hive ThriftServer2で実行中のオペレーション（SQL文の実行）がユーザやシステムによってキャンセルされた際に発火するイベントを定義する。

**業務上の目的・背景**：長時間実行中のクエリのキャンセルは、リソースの解放やユーザの操作ミスへの対応として頻繁に発生する。本通知により、管理者はThriftServer UIでキャンセルされたオペレーションを追跡でき、キャンセル頻度の分析や異常なキャンセルパターンの検出に活用できる。

**通知の送信タイミング**：SparkExecuteStatementOperationのcancel()メソッド内で、操作が非終了状態（!isTerminal）である場合にHiveThriftServer2EventManager.onStatementCanceled()が呼び出されて発火する。setStateでOperationState.CANCELEDに設定された後、cleanup()で関連リソースが解放される。

**通知の受信者**：HiveThriftServer2Listenerが主たる受信者であり、LiveListenerBus経由で非同期に配信される。

**通知内容の概要**：id（オペレーションID）、finishTime（キャンセル時刻）を含む。

**期待されるアクション**：受信したリスナーは、当該オペレーションのfinishTimestampを設定し、stateをCANCELEDに更新する。UI上でキャンセル状態が表示される。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのドロップポリシーに依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerに対してブロードキャストされる。HiveThriftServer2ListenerがonOtherEventメソッドでパターンマッチにより受信する。

## 通知テンプレート

### メール通知の場合

本通知はメール通知ではなく、Sparkイベントバス上のインプロセスイベントであるため、メールテンプレートは該当しない。

### 本文テンプレート

```
イベントクラス: SparkListenerThriftServerOperationCanceled
フィールド:
  id: {id}
  finishTime: {finishTime}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| id | オペレーションID | statementId | Yes |
| finishTime | キャンセル時刻（ミリ秒） | System.currentTimeMillis() | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API（内部） | SparkExecuteStatementOperation.cancel() | getStatus.getState.isTerminal == false | ユーザによるキャンセル要求 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| オペレーションが既に終了状態 | getStatus.getState.isTerminalがtrueの場合はキャンセル処理自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[キャンセル要求] --> B[SparkExecuteStatementOperation.cancel]
    B --> C{getStatus.getState.isTerminal?}
    C -->|Yes| D[処理スキップ]
    C -->|No| E[setState OperationState.CANCELED]
    E --> F[cleanup - リソース解放]
    F --> G[HiveThriftServer2.eventManager.onStatementCanceled]
    G --> H[SparkListenerThriftServerOperationCanceled生成]
    H --> I[LiveListenerBus.post]
    I --> J[HiveThriftServer2Listener.onOperationCanceled]
    J --> K{executionListにid存在?}
    K -->|Yes| L[finishTimestamp設定 / state = CANCELED]
    K -->|No| M[ログ警告出力]
    L --> N[updateLiveStore - KVStore更新]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executionList (ConcurrentHashMap) | オペレーション実行データ管理 | インメモリ。execIdをキーとする |

### テーブル別参照項目詳細

#### executionList (ConcurrentHashMap)

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| LiveExecutionData | オペレーションの状態管理 | idで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| ElementTrackingStore (KVStore) | UPDATE | ExecutionInfoのfinishTimestamp, stateを更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | finishTimestamp | e.finishTime | キャンセル時刻 |
| UPDATE | state | ExecutionState.CANCELED | キャンセル状態 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 不明なオペレーション | executionListにidが存在しない場合 | ログ警告を出力し、処理をスキップ |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | なし |
| 1日あたり上限 | なし |

### 配信時間帯

制限なし。ThriftServerが稼働中であれば常に配信可能。

## セキュリティ考慮事項

- private[thriftserver]スコープで定義されており、thriftserverパッケージ外からは直接アクセスできない
- idのみを含み、SQL文やユーザ情報は含まない
- 本イベントはSpark JVMプロセス内部のイベントバスで配信される

## 備考

- cancel()メソッドはsynchronizedブロック内で実行されるため、スレッドセーフである
- キャンセル処理ではsetState(OperationState.CANCELED) -> cleanup() -> onStatementCanceled()の順で実行される
- SparkExecuteStatementOperationの303行目付近でイベントが発火する
- cleanup()メソッドでSparkContext.cancelJobGroupを呼び出し、関連するSparkジョブをキャンセルする

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 100-101行目: SparkListenerThriftServerOperationCanceled case classの定義。id, finishTimeフィールド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | 56-57行目: onStatementCanceled()メソッド。idのみを引数に取り、System.currentTimeMillis()をfinishTimeとして設定 |

#### Step 3: 呼び出し元を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkExecuteStatementOperation.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` | 298-305行目: cancel()メソッド。synchronized内で、isTerminal判定 -> setState(CANCELED) -> cleanup() -> onStatementCanceled()の順で実行 |

**主要処理フロー**:
1. **299行目**: isTerminal判定 - 既に終了状態ならスキップ
2. **301行目**: setState(OperationState.CANCELED) - Hiveオペレーション状態更新
3. **302行目**: cleanup() - SparkContext.cancelJobGroup等のリソース解放
4. **303行目**: HiveThriftServer2.eventManager.onStatementCanceled(statementId)

#### Step 4: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | 183-192行目: onOperationCanceledメソッド。finishTimestampとstateをCANCELEDに更新 |

**主要処理フロー**:
- **186行目**: executionData.finishTimestamp = e.finishTime
- **187行目**: executionData.state = ExecutionState.CANCELED

### プログラム呼び出し階層図

```
キャンセル要求
    |
    +-- SparkExecuteStatementOperation.cancel() [synchronized]
            |
            +-- !getStatus.getState.isTerminal 判定
            |
            +-- setState(OperationState.CANCELED)
            |
            +-- cleanup() -- SparkContext.cancelJobGroup等
            |
            +-- HiveThriftServer2.eventManager.onStatementCanceled(statementId)
                    |
                    +-- postLiveListenerBus(SparkListenerThriftServerOperationCanceled(...))
                            |
                            +-- HiveThriftServer2Listener.onOperationCanceled()
                                    |
                                    +-- executionData.finishTimestamp = finishTime
                                    +-- executionData.state = CANCELED
                                    +-- updateLiveStore()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

キャンセル要求             -->  SparkExecuteStatementOperation   -->  LiveListenerBus
 (JDBC/ODBCクライアント)         .cancel()                            (イベント配信)
                                   |
                                   v
                          HiveThriftServer2EventManager       -->  HiveThriftServer2Listener
                           .onStatementCanceled()                   (状態更新)
                                   |                                    |
                                   v                                    v
                          SparkListenerThriftServer           LiveExecutionData
                          OperationCanceled                    .state = CANCELED
                           {id, finishTime}                    .finishTimestamp = finishTime
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| HiveThriftServer2EventManager.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2EventManager.scala` | ソース | イベントクラス定義およびイベント発火ロジック |
| HiveThriftServer2Listener.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2Listener.scala` | ソース | イベント受信・UI状態更新ロジック |
| SparkExecuteStatementOperation.scala | `sql/hive-thriftserver/src/main/scala/org/apache/spark/sql/hive/thriftserver/SparkExecuteStatementOperation.scala` | ソース | キャンセル処理とイベント発火の起点 |
| HiveThriftServer2ListenerSuite.scala | `sql/hive-thriftserver/src/test/scala/org/apache/spark/sql/hive/thriftserver/ui/HiveThriftServer2ListenerSuite.scala` | テスト | リスナーの単体テスト |
