# 通知設計書 15-SparkListenerExecutorExcluded

## 概要

本ドキュメントは、Apache SparkのSparkListenerExecutorExcludedイベント通知の設計仕様を記載する。このイベントはドライバがExecutorをアプリケーションレベルで除外（exclude）した際に発火し、LiveListenerBus経由で非同期に配信される。Spark 3.1.0で導入された。

### 本通知の処理概要

SparkListenerExecutorExcludedは、HealthTrackerがタスク失敗やフェッチ失敗に基づいてExecutorをアプリケーション全体から除外した際にリスナーバスへ通知を行うイベントである。

**業務上の目的・背景**：Sparkクラスタでは、特定のExecutorが繰り返しタスク失敗を引き起こす場合、そのExecutorに問題（ハードウェア障害、ネットワーク不具合等）があると判断される。HealthTrackerはこのようなExecutorをアプリケーション全体から除外し、以後のタスクスケジューリングから除外する。この通知により、Spark UIでのExecutor除外ステータスの表示、イベントログへの記録が可能となり、クラスタ管理者が問題のあるExecutorを把握できる。

**通知の送信タイミング**：HealthTrackerの以下の2つのメソッドで発火する。(1) updateExcludedForSuccessfulTaskSet（291行目）: タスクセット完了後にExecutorの累積失敗数が閾値（MAX_FAILURES_PER_EXEC）を超えた場合。(2) updateExcludedForFetchFailure（254行目）: フェッチ失敗発生時にExecutorを即座に除外する場合。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（UI更新）、EventLoggingListener（イベントログ）である。

**通知内容の概要**：除外された時刻、ExecutorのID、タスク失敗数が含まれる。

**期待されるアクション**：受信者はExecutorの除外ステータスをUIに反映する。クラスタ管理者は問題のあるExecutorを特定し、必要に応じてノードの調査や交換を行う。

## 通知種別

アプリ内イベント通知（SparkListenerEvent）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueue使用） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

LiveListenerBusに登録された全てのAsyncEventQueueに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッド（82行目）で`listener.onExecutorExcluded(executorExcluded)`が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。本通知はSpark内部のイベントバスを通じたプログラム間通知である。

### 本文テンプレート

```
イベント種別: SparkListenerExecutorExcluded
JSON形式:
{
  "Event": "SparkListenerExecutorExcluded",
  "Timestamp": <timestamp>,
  "Executor ID": "<executorId>",
  "Task Failures": <taskFailures>
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | Executor除外時刻（ミリ秒） | clock.getTimeMillis() | Yes |
| executorId | 除外されたExecutorのID | HealthTracker内部処理 | Yes |
| taskFailures | タスク失敗数 | ExecutorFailureList.numUniqueTaskFailures またはハードコード値1（フェッチ失敗時） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | タスクセット完了 | Executorの累積タスク失敗数 >= MAX_FAILURES_PER_EXEC かつ未除外 | HealthTracker.updateExcludedForSuccessfulTaskSet 291行目 |
| 内部処理 | フェッチ失敗 | EXCLUDE_FETCH_FAILURE_ENABLED=true かつ Executor未除外 かつ シャッフルサービス無効 | HealthTracker.updateExcludedForFetchFailure 254行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Executor既に除外済み | executorIdToExcludedStatusに既にエントリがある場合は再除外しない |
| excludeOnFailure無効 | HealthTrackerが生成されていない場合（設定無効時） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスク失敗/フェッチ失敗発生] --> B{トリガー種別}
    B -->|タスクセット完了| C[HealthTracker.updateExcludedForSuccessfulTaskSet]
    B -->|フェッチ失敗| D[HealthTracker.updateExcludedForFetchFailure]
    C --> E{累積失敗数 >= MAX_FAILURES_PER_EXEC?}
    E -->|Yes かつ未除外| F[executorIdToExcludedStatusに追加]
    E -->|No| G[処理なし]
    D --> H{Executor未除外?}
    H -->|Yes| F
    H -->|No| G
    F --> I[listenerBus.post SparkListenerExecutorExcluded]
    I --> J[後続処理: killExcludedExecutor]
    I --> K[ノード除外判定へ連鎖]
    I --> L[LiveListenerBus.post]
    L --> M{受信リスナー}
    M -->|AppStatusListener| N[Executor除外ステータス更新]
    M -->|EventLoggingListener| O[イベントログ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executorIdToExcludedStatus（インメモリMap） | 既に除外済みかの確認 | HealthTracker内部のHashMap |
| executorIdToFailureList（インメモリMap） | 累積失敗数の確認 | HealthTracker内部のHashMap |

### テーブル別参照項目詳細

#### executorIdToExcludedStatus

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| executorId | 除外済みチェック | containsメソッドで存在確認 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| executorIdToExcludedStatus（インメモリMap） | INSERT | ExcludedExecutor(node, expiryTime)を追加 |
| nodeToExcludedExecs（インメモリMap） | UPDATE | ノード上の除外Executor集合に追加 |
| KVStore（AppStatusListener経由） | UPDATE | Executor除外ステータスの更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | SparkListenerExecutorExcluded | イベントログに書き込み |
| INSERT | Timestamp | clock.getTimeMillis() | 除外時刻 |
| INSERT | Executor ID | executorId | 除外されたExecutorのID |
| INSERT | Task Failures | taskFailures | タスク失敗数 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー満杯 | AsyncEventQueueのキャパシティ超過 | イベントがドロップされる |
| リスナー例外 | リスナーのonExecutorExcludedで例外発生 | ListenerBusが例外をキャッチしログに記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

イベントにはExecutorIDとタスク失敗数が含まれる。機密情報は含まれないが、Executor除外の頻度や傾向はクラスタの健全性を示す情報となるため、Spark UIのACLによるアクセス制御が推奨される。

## 備考

- 本イベントはSpark 3.1.0で導入され、@Since("3.1.0")アノテーションが付与されている。
- 後方互換性のため、SparkListenerExecutorBlacklisted（@deprecated）も同時に発火される。
- 除外にはEXCLUDE_ON_FAILURE_TIMEOUT_MILLISで設定されたタイムアウト（デフォルト1時間）があり、タイムアウト後にSparkListenerExecutorUnexcludedが発火される。
- EXCLUDE_ON_FAILURE_KILL_ENABLEDがtrueの場合、除外と同時にExecutorのkillまたはデコミッションが実行される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 136-140行目: case class SparkListenerExecutorExcluded(time, executorId, taskFailures)の定義 |

**読解のコツ**: @Since("3.1.0")アノテーションが付与されており、SparkListenerExecutorBlacklistedの後継である。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 264-316行目: updateExcludedForSuccessfulTaskSet。タスクセット完了時の累積失敗チェック |
| 2-2 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 220-262行目: updateExcludedForFetchFailure。フェッチ失敗時の即座の除外 |

**主要処理フロー**（updateExcludedForSuccessfulTaskSet）:
1. **271行目**: 失敗情報の集約
2. **284行目**: 累積失敗数 >= MAX_FAILURES_PER_EXEC のチェック
3. **288行目**: executorIdToExcludedStatusへの追加
4. **290-291行目**: SparkListenerExecutorBlacklisted（後方互換）とSparkListenerExecutorExcludedの発火
5. **294行目**: killExcludedExecutorの呼び出し

#### Step 3: 受信リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 297行目: onExecutorExcludedでupdateExecExclusionStatus(executorId, true)を呼び出し |
| 3-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 197行目: イベントログに記録 |

### プログラム呼び出し階層図

```
タスク失敗 / フェッチ失敗
    |
    +-- HealthTracker.updateExcludedForSuccessfulTaskSet()
    |       |
    |       +-- executorIdToExcludedStatus.put(exec, ExcludedExecutor)
    |       +-- listenerBus.post(SparkListenerExecutorBlacklisted) [後方互換]
    |       +-- listenerBus.post(SparkListenerExecutorExcluded)
    |       +-- killExcludedExecutor(exec)
    |       +-- nodeToExcludedExecs更新 --> ノード除外判定
    |
    +-- HealthTracker.updateExcludedForFetchFailure()
            |
            +-- executorIdToExcludedStatus.put(exec, ExcludedExecutor)
            +-- listenerBus.post(SparkListenerExecutorBlacklisted) [後方互換]
            +-- listenerBus.post(SparkListenerExecutorExcluded)
            +-- killExcludedExecutor(exec)
```

### データフロー図

```
[入力]                      [処理]                            [出力]

タスク失敗情報 -----------> HealthTracker -----------------> SparkListenerExecutorExcluded
(executorId,                 .updateExcluded*()                イベント
 failureCount,                    |
 host)                            v
                            executorIdToExcludedStatus更新
                                  |
                                  v
                            LiveListenerBus.post() ---------> AsyncEventQueue
                                                                   |
                                                                   v
                                                             AppStatusListener --> 除外ステータス更新
                                                             EventLoggingListener --> ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントcase classの定義 |
| HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | ソース | イベントの発火元（Executor除外ロジック） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期イベントバス |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | 除外ステータスのUI更新 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
| JsonProtocol.scala | `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` | ソース | JSON変換 |
