# 通知設計書 16-SparkListenerExecutorExcludedForStage

## 概要

本ドキュメントは、Apache SparkのSparkListenerExecutorExcludedForStageイベント通知の設計仕様を記載する。このイベントはドライバが特定ステージでExecutorを除外した際に発火し、LiveListenerBus経由で非同期に配信される。Spark 3.1.0で導入された。

### 本通知の処理概要

SparkListenerExecutorExcludedForStageは、TaskSetExcludelistが特定のステージにおいてExecutorの失敗数が閾値を超えた際に、そのExecutorをステージレベルで除外したことをリスナーバスへ通知するイベントである。

**業務上の目的・背景**：アプリケーションレベルの除外（SparkListenerExecutorExcluded）とは異なり、ステージレベルの除外は特定のステージに限定される。あるExecutorが特定ステージのタスクで繰り返し失敗する場合、そのステージに限ってExecutorを除外することで、他のステージへの影響を最小限にしつつ障害を回避する。この通知により、Spark UIでのステージ単位のExecutor除外情報の表示が可能となる。

**通知の送信タイミング**：TaskSetExcludelist.updateExcludedForFailedTaskメソッド内で、Executorの失敗タスク数がMAX_FAILURES_PER_EXEC_STAGEに達した際に発火する（152行目）。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（UI更新）とEventLoggingListener（イベントログ）である。

**通知内容の概要**：除外時刻、ExecutorのID、タスク失敗数、ステージID、ステージ試行IDが含まれる。

**期待されるアクション**：受信者はステージレベルのExecutor除外情報をUIに反映する。タスクスケジューラは当該ステージの残りタスクを他のExecutorにスケジュールする。

## 通知種別

アプリ内イベント通知（SparkListenerEvent）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueue使用） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

LiveListenerBusに登録された全てのAsyncEventQueueに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッド（78行目）で`listener.onExecutorExcludedForStage(executorExcludedForStage)`が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
イベント種別: SparkListenerExecutorExcludedForStage
JSON形式:
{
  "Event": "SparkListenerExecutorExcludedForStage",
  "Timestamp": <timestamp>,
  "Executor ID": "<executorId>",
  "Task Failures": <taskFailures>,
  "Stage ID": <stageId>,
  "Stage Attempt ID": <stageAttemptId>
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | 除外時刻（ミリ秒） | clock.getTimeMillis() | Yes |
| executorId | 除外されたExecutorのID | TaskSetExcludelist内部処理 | Yes |
| taskFailures | ステージ内のユニークタスク失敗数 | execFailures.numUniqueTasksWithFailures | Yes |
| stageId | ステージID | TaskSetExcludelistのコンストラクタ引数 | Yes |
| stageAttemptId | ステージ試行ID | TaskSetExcludelistのコンストラクタ引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | タスク失敗 | Executorのステージ内ユニーク失敗タスク数 >= MAX_FAILURES_PER_EXEC_STAGE | TaskSetExcludelist.updateExcludedForFailedTask 152行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| Executor既にステージ除外済み | excludedExecsに既に含まれている場合は再除外しない（HashSet.addがfalseを返す） |
| isDryRun=true | dryRunモード時は除外処理自体が行われない（情報収集のみ） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスク失敗発生] --> B[TaskSetExcludelist.updateExcludedForFailedTask]
    B --> C[execFailures更新]
    C --> D{numUniqueTasksWithFailures >= MAX_FAILURES_PER_EXEC_STAGE?}
    D -->|Yes| E{excludedExecs.add成功?}
    E -->|Yes| F[listenerBus.post SparkListenerExecutorExcludedForStage]
    F --> G{ノード除外判定}
    G -->|numFailExec >= MAX_FAILED_EXEC_PER_NODE_STAGE| H[SparkListenerNodeExcludedForStage発火]
    D -->|No| I[処理なし]
    E -->|No| I
    F --> J[LiveListenerBus.post]
    J --> K{受信リスナー}
    K -->|AppStatusListener| L[ステージExecutor除外情報更新]
    K -->|EventLoggingListener| M[イベントログ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| execToFailures（インメモリMap） | Executor毎の失敗情報 | TaskSetExcludelist内部のHashMap |
| excludedExecs（インメモリSet） | 既にステージ除外済みかの確認 | TaskSetExcludelist内部のHashSet |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| excludedExecs（インメモリSet） | INSERT | 除外Executor IDの追加 |
| KVStore（AppStatusListener経由） | UPDATE | ステージのExecutor除外情報更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | SparkListenerExecutorExcludedForStage | イベントログに書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー満杯 | AsyncEventQueueのキャパシティ超過 | イベントがドロップされる |
| リスナー例外 | リスナーで例外発生 | ListenerBusが例外をキャッチしログに記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

イベントにはExecutorID、ステージID、失敗数が含まれる。機密情報は含まれない。

## 備考

- 本イベントはSpark 3.1.0で導入された。
- 後方互換のためSparkListenerExecutorBlacklistedForStage（@deprecated）も同時に発火される（150行目）。
- ステージレベルの除外はステージの存続期間に限定され、タイムアウトによる自動復帰はない（アプリケーションレベルの除外とは異なる）。
- 同一ノード上で複数のExecutorが除外された場合、SparkListenerNodeExcludedForStageの発火に連鎖する可能性がある。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 155-161行目: case class SparkListenerExecutorExcludedForStage(time, executorId, taskFailures, stageId, stageAttemptId)の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TaskSetExcludeList.scala | `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` | 110-168行目: updateExcludedForFailedTaskメソッド。タスク失敗時の除外判定ロジック |

**主要処理フロー**:
1. **116行目**: execFailuresの取得・更新
2. **137行目**: numUniqueTasksWithFailures >= MAX_FAILURES_PER_EXEC_STAGEのチェック
3. **139行目**: excludedExecs.add(exec)
4. **149-152行目**: SparkListenerExecutorBlacklistedForStageとSparkListenerExecutorExcludedForStageの発火
5. **154行目**: ノード除外判定（MAX_FAILED_EXEC_PER_NODE_STAGE）

#### Step 3: 受信リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 306-309行目: onExecutorExcludedForStageでupdateExclusionStatusForStageを呼び出し |
| 3-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 206-208行目: イベントログに記録 |

### プログラム呼び出し階層図

```
TaskSetManager.handleFailedTask()
    |
    +-- TaskSetExcludelist.updateExcludedForFailedTask()
            |
            +-- execToFailures更新
            +-- excludedExecs.add(exec)
            +-- listenerBus.post(SparkListenerExecutorBlacklistedForStage) [後方互換]
            +-- listenerBus.post(SparkListenerExecutorExcludedForStage)
            +-- ノード除外判定
                    |
                    +-- excludedNodes.add(host)
                    +-- listenerBus.post(SparkListenerNodeExcludedForStage) [連鎖]
```

### データフロー図

```
[入力]                      [処理]                                [出力]

タスク失敗情報 -----------> TaskSetExcludelist -----------------> SparkListenerExecutorExcludedForStage
(host, exec,                 .updateExcludedForFailedTask()        イベント
 taskIndex,                       |
 failureReason)                   v
                            excludedExecs更新
                                  |
                                  v
                            LiveListenerBus.post() -------------> AsyncEventQueue
                                                                       |
                                                                       v
                                                                 AppStatusListener --> ステージUI更新
                                                                 EventLoggingListener --> ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントcase classの定義 |
| TaskSetExcludeList.scala | `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` | ソース | イベントの発火元（ステージレベル除外ロジック） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期イベントバス |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | ステージUI更新 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
