# 通知設計書 17-SparkListenerNodeExcludedForStage

## 概要

本ドキュメントは、Apache SparkのSparkListenerNodeExcludedForStageイベント通知の設計仕様を記載する。このイベントはドライバが特定ステージでノード（ホスト）を除外した際に発火し、LiveListenerBus経由で非同期に配信される。Spark 3.1.0で導入された。

### 本通知の処理概要

SparkListenerNodeExcludedForStageは、TaskSetExcludelistが特定ステージにおいてノード上の複数Executorが除外された結果、ノード全体をステージレベルで除外したことをリスナーバスへ通知するイベントである。

**業務上の目的・背景**：あるノード上の複数のExecutorがステージのタスク実行で繰り返し失敗する場合、そのノード自体に問題がある可能性が高い。ノードレベルでの除外により、そのノード上の全Executorを当該ステージのタスクスケジューリングから除外し、障害の影響を迅速に回避する。この通知により、Spark UIでのノード単位のステージ除外情報の表示が可能となる。

**通知の送信タイミング**：TaskSetExcludelist.updateExcludedForFailedTaskメソッド内で、ノード上の除外Executor数がMAX_FAILED_EXEC_PER_NODE_STAGEに達した際に発火する（163行目）。SparkListenerExecutorExcludedForStageの発火に連鎖して発生する。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（UI更新）とEventLoggingListener（イベントログ）である。

**通知内容の概要**：除外時刻、ノードのホストID、Executor失敗数、ステージID、ステージ試行IDが含まれる。

**期待されるアクション**：受信者はノードレベルのステージ除外情報をUIに反映する。タスクスケジューラはそのノード上の全Executorを当該ステージのスケジューリングから除外する。

## 通知種別

アプリ内イベント通知（SparkListenerEvent）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueue使用） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

LiveListenerBusに登録された全てのAsyncEventQueueに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッド（80行目）で`listener.onNodeExcludedForStage(nodeExcludedForStage)`が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
イベント種別: SparkListenerNodeExcludedForStage
JSON形式:
{
  "Event": "SparkListenerNodeExcludedForStage",
  "Timestamp": <timestamp>,
  "Host ID": "<hostId>",
  "Executor Failures": <executorFailures>,
  "Stage ID": <stageId>,
  "Stage Attempt ID": <stageAttemptId>
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | 除外時刻（ミリ秒） | clock.getTimeMillis() | Yes |
| hostId | 除外されたノードのホスト名 | TaskSetExcludelist内部処理 | Yes |
| executorFailures | ノード上の除外Executor数 | excludedExecutorsOnNode.size | Yes |
| stageId | ステージID | TaskSetExcludelistのコンストラクタ引数 | Yes |
| stageAttemptId | ステージ試行ID | TaskSetExcludelistのコンストラクタ引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Executor除外の連鎖 | ノード上の除外Executor数 >= MAX_FAILED_EXEC_PER_NODE_STAGE | TaskSetExcludelist 163行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ノード既にステージ除外済み | excludedNodesに既に含まれている場合は再除外しない |
| isDryRun=true | dryRunモード時は除外処理が行われない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[SparkListenerExecutorExcludedForStage発火] --> B[ノード除外判定]
    B --> C{excludedExecutorsOnNode.size >= MAX_FAILED_EXEC_PER_NODE_STAGE?}
    C -->|Yes| D{excludedNodes.add成功?}
    D -->|Yes| E[listenerBus.post SparkListenerNodeBlacklistedForStage 後方互換]
    E --> F[listenerBus.post SparkListenerNodeExcludedForStage]
    C -->|No| G[処理なし]
    D -->|No| G
    F --> H[LiveListenerBus.post]
    H --> I{受信リスナー}
    I -->|AppStatusListener| J[ノード除外情報更新]
    I -->|EventLoggingListener| K[イベントログ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| excludedExecs（インメモリSet） | ノード上の除外Executor数の算出 | TaskSetExcludelist内部のHashSet |
| nodeToExecsWithFailures（インメモリMap） | ノード上の失敗Executor集合 | TaskSetExcludelist内部のHashMap |
| excludedNodes（インメモリSet） | 既にノード除外済みかの確認 | TaskSetExcludelist内部のHashSet |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| excludedNodes（インメモリSet） | INSERT | 除外ノードの追加 |
| KVStore（AppStatusListener経由） | UPDATE | ステージのノード除外情報更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | SparkListenerNodeExcludedForStage | イベントログに書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー満杯 | AsyncEventQueueのキャパシティ超過 | イベントがドロップされる |
| リスナー例外 | リスナーで例外発生 | ListenerBusが例外をキャッチしログに記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

イベントにはホストID、ステージID、Executor失敗数が含まれる。機密情報は含まれない。

## 備考

- 本イベントはSpark 3.1.0で導入された。
- 後方互換のためSparkListenerNodeBlacklistedForStage（@deprecated）も同時に発火される（160-161行目）。
- SparkListenerExecutorExcludedForStageの発火に連鎖して発生するため、必ずExecutorレベルの除外が先に行われる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 176-182行目: case class SparkListenerNodeExcludedForStage(time, hostId, executorFailures, stageId, stageAttemptId)の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | TaskSetExcludeList.scala | `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` | 153-164行目: ノード除外判定ロジック。SparkListenerExecutorExcludedForStage発火後の連鎖処理 |

**主要処理フロー**:
1. **144行目**: excludedExecutorsOnNodeの算出（execsWithFailuresOnNode.intersect(excludedExecs)）
2. **153行目**: numFailExec >= MAX_FAILED_EXEC_PER_NODE_STAGEのチェック
3. **155行目**: excludedNodes.add(host)
4. **160-163行目**: SparkListenerNodeBlacklistedForStageとSparkListenerNodeExcludedForStageの発火

#### Step 3: 受信リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 315-317行目: onNodeExcludedForStageでupdateNodeExclusionStatusForStageを呼び出し |
| 3-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 215-216行目: イベントログに記録 |

### プログラム呼び出し階層図

```
TaskSetExcludelist.updateExcludedForFailedTask()
    |
    +-- Executor除外判定
    |       +-- SparkListenerExecutorExcludedForStage発火
    |
    +-- ノード除外判定
            |
            +-- excludedExecutorsOnNode算出
            +-- excludedNodes.add(host)
            +-- listenerBus.post(SparkListenerNodeBlacklistedForStage) [後方互換]
            +-- listenerBus.post(SparkListenerNodeExcludedForStage)
                    |
                    +-- LiveListenerBus.post(event)
                            |
                            +-- AppStatusListener.onNodeExcludedForStage()
                            +-- EventLoggingListener.onNodeExcludedForStage()
```

### データフロー図

```
[入力]                           [処理]                              [出力]

Executor除外イベント ---------> TaskSetExcludelist ---------------> SparkListenerNodeExcludedForStage
(ノード上の除外Executor数        ノード除外判定                        イベント
 が閾値到達)                          |
                                     v
                               LiveListenerBus.post() -----------> AsyncEventQueue
                                                                        |
                                                                        v
                                                                  AppStatusListener --> ステージUI更新
                                                                  EventLoggingListener --> ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントcase classの定義 |
| TaskSetExcludeList.scala | `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` | ソース | イベントの発火元 |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期イベントバス |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | ステージUI更新 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
