# 通知設計書 18-SparkListenerExecutorUnexcluded

## 概要

本ドキュメントは、Apache SparkのSparkListenerExecutorUnexcludedイベント通知の設計仕様を記載する。このイベントは以前除外されたExecutorが再有効化された際に発火し、LiveListenerBus経由で非同期に配信される。

### 本通知の処理概要

SparkListenerExecutorUnexcludedは、HealthTrackerがタイムアウトに基づいて除外Executorを再有効化した際にリスナーバスへ通知を行うイベントである。

**業務上の目的・背景**：Sparkの除外メカニズムでは、問題のあるExecutorを一時的にタスクスケジューリングから除外するが、EXCLUDE_ON_FAILURE_TIMEOUT_MILLIS（デフォルト1時間）の経過後に自動的に再有効化される。これは一時的な障害からの回復を想定した設計である。この通知により、Spark UIでのExecutor除外ステータスの解除表示、イベントログへの記録が可能となる。

**通知の送信タイミング**：HealthTracker.applyExcludeOnFailureTimeoutメソッド内で、executorIdToExcludedStatusのexpiryTimeが現在時刻を過ぎたExecutorに対して`listenerBus.post(SparkListenerExecutorUnexcluded(now, exec))`が呼び出される（121行目）。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（UI更新）とEventLoggingListener（イベントログ）である。

**通知内容の概要**：再有効化された時刻とExecutorのIDが含まれる。

**期待されるアクション**：受信者はExecutorの除外ステータスを解除し、UIに反映する。タスクスケジューラは当該Executorへのタスク割り当てを再開する。

## 通知種別

アプリ内イベント通知（SparkListenerEvent）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueue使用） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

LiveListenerBusに登録された全てのAsyncEventQueueに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッド（84行目）で`listener.onExecutorUnexcluded(executorUnexcluded)`が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
イベント種別: SparkListenerExecutorUnexcluded
JSON形式:
{
  "Event": "SparkListenerExecutorUnexcluded",
  "Timestamp": <timestamp>,
  "Executor ID": "<executorId>"
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | 再有効化時刻（ミリ秒） | clock.getTimeMillis() | Yes |
| executorId | 再有効化されたExecutorのID | executorIdToExcludedStatusのキー | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | タイムアウト到達 | Executorの除外expiryTimeが現在時刻を過ぎた場合 | HealthTracker.applyExcludeOnFailureTimeout 121行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| タイムアウト未到達 | expiryTimeが現在時刻を超えていない場合はイベント発火しない |
| nextExpiryTime未到達 | 最短のexpiryTimeが現在時刻を超えていない場合、applyExcludeOnFailureTimeout自体がスキップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TaskSchedulerImpl.resourceOffers等のタイミング] --> B[HealthTracker.applyExcludeOnFailureTimeout]
    B --> C{now > nextExpiryTime?}
    C -->|Yes| D[executorIdToExcludedStatus.filter expiryTime < now]
    C -->|No| E[処理スキップ]
    D --> F{対象Executor存在?}
    F -->|Yes| G[executorIdToExcludedStatusから削除]
    G --> H[listenerBus.post SparkListenerExecutorUnblacklisted 後方互換]
    H --> I[listenerBus.post SparkListenerExecutorUnexcluded]
    I --> J[nodeToExcludedExecsから削除]
    F -->|No| K[処理なし]
    I --> L[LiveListenerBus.post]
    L --> M{受信リスナー}
    M -->|AppStatusListener| N[Executor除外ステータス解除]
    M -->|EventLoggingListener| O[イベントログ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| executorIdToExcludedStatus（インメモリMap） | タイムアウト判定 | HealthTracker内部のHashMap |

### テーブル別参照項目詳細

#### executorIdToExcludedStatus

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| executorId | 再有効化対象の特定 | expiryTime < now でフィルタ |
| ExcludedExecutor.expiryTime | タイムアウト判定 | 現在時刻との比較 |
| ExcludedExecutor.node | ノード情報のクリーンアップ | 対応するノードのExec集合更新用 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| executorIdToExcludedStatus（インメモリMap） | DELETE | タイムアウト到達Executorのエントリ削除 |
| nodeToExcludedExecs（インメモリMap） | UPDATE | ノード上の除外Executor集合から削除 |
| KVStore（AppStatusListener経由） | UPDATE | Executor除外ステータスの解除 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | SparkListenerExecutorUnexcluded | イベントログに書き込み |
| INSERT | Timestamp | clock.getTimeMillis() | 再有効化時刻 |
| INSERT | Executor ID | executorId | 再有効化されたExecutorのID |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー満杯 | AsyncEventQueueのキャパシティ超過 | イベントがドロップされる |
| リスナー例外 | リスナーで例外発生 | ListenerBusが例外をキャッチしログに記録 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

イベントにはExecutorIDのみが含まれ、機密情報は含まれない。

## 備考

- SparkListenerExecutorExcludedと対になるイベントである。
- 後方互換のためSparkListenerExecutorUnblacklisted（@deprecated）も同時に発火される（120行目）。
- EXCLUDE_ON_FAILURE_TIMEOUT_MILLISのデフォルト値は1時間（"1h"）。
- applyExcludeOnFailureTimeoutは定期的に呼び出され（TaskSchedulerImplのresourceOffers時等）、nextExpiryTimeによる最適化でほとんどの呼び出しでは処理がスキップされる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 191行目: case class SparkListenerExecutorUnexcluded(time, executorId)の定義 |
| 1-2 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 520行目: ExcludedExecutor(node, expiryTime)のcase class定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 105-143行目: applyExcludeOnFailureTimeoutメソッド。タイムアウト判定と再有効化処理 |

**主要処理フロー**:
1. **109行目**: now > nextExpiryTimeのチェック（最適化）
2. **111行目**: executorIdToExcludedStatus.filter(_._2.expiryTime < now) -- タイムアウト到達Executorの抽出
3. **117行目**: executorIdToExcludedStatus.remove(exec) -- 除外リストからの削除
4. **120行目**: SparkListenerExecutorUnblacklisted発火（後方互換）
5. **121行目**: SparkListenerExecutorUnexcluded発火
6. **122行目**: nodeToExcludedExecsから削除

#### Step 3: 受信リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 338行目: onExecutorUnexcludedでupdateExecExclusionStatus(executorId, false)を呼び出し |
| 3-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 223行目: イベントログに記録 |

### プログラム呼び出し階層図

```
TaskSchedulerImpl.resourceOffers() (定期呼び出し)
    |
    +-- HealthTracker.applyExcludeOnFailureTimeout()
            |
            +-- executorIdToExcludedStatus.filter(expiryTime < now)
            +-- executorIdToExcludedStatus.remove(exec)
            +-- listenerBus.post(SparkListenerExecutorUnblacklisted) [後方互換]
            +-- listenerBus.post(SparkListenerExecutorUnexcluded)
                    |
                    +-- LiveListenerBus.post(event)
                            |
                            +-- AppStatusListener.onExecutorUnexcluded()
                            +-- EventLoggingListener.onExecutorUnexcluded()
            +-- nodeToExcludedExecs更新
            +-- updateNextExpiryTime()
```

### データフロー図

```
[入力]                       [処理]                             [出力]

タイムアウト到達 ----------> HealthTracker -----------------> SparkListenerExecutorUnexcluded
(now > expiryTime)           .applyExcludeOnFailureTimeout()    イベント
                                  |
                                  v
                            executorIdToExcludedStatus削除
                                  |
                                  v
                            LiveListenerBus.post() ----------> AsyncEventQueue
                                                                    |
                                                                    v
                                                              AppStatusListener --> 除外ステータス解除
                                                              EventLoggingListener --> ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントcase classの定義 |
| HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | ソース | イベントの発火元（タイムアウト処理） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期イベントバス |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | 除外ステータス解除 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
