# 通知設計書 19-SparkListenerNodeExcluded

## 概要

本ドキュメントは、Apache SparkのSparkListenerNodeExcludedイベント通知の設計仕様を記載する。このイベントはドライバがノード（ホスト）をアプリケーションレベルで除外した際に発火し、LiveListenerBus経由で非同期に配信される。Spark 3.1.0で導入された。

### 本通知の処理概要

SparkListenerNodeExcludedは、HealthTrackerがノード上の複数Executorの除外に基づいてノード全体をアプリケーションレベルで除外した際、あるいはフェッチ失敗時にシャッフルサービス有効なノードを除外した際にリスナーバスへ通知を行うイベントである。

**業務上の目的・背景**：あるノード上で複数のExecutorが繰り返し失敗し除外される場合、そのノード自体にハードウェアやネットワークの問題がある可能性が高い。ノードレベルでの除外により、クラスタマネージャに対して当該ノードへの新規Executor割り当てを抑止し、障害の影響を根本的に排除する。また、外部シャッフルサービス有効時のフェッチ失敗は、ノード上の全Executorに影響するため即座にノードを除外する。この通知により、Spark UIでのノード除外情報の表示が可能となる。

**通知の送信タイミング**：HealthTrackerの以下の2つのメソッドで発火する。(1) updateExcludedForSuccessfulTaskSet（310行目）: ノード上の除外Executor数がMAX_FAILED_EXEC_PER_NODEに達した場合。(2) updateExcludedForFetchFailure（241行目）: シャッフルサービス有効時のフェッチ失敗で即座にノードを除外する場合。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（UI更新）とEventLoggingListener（イベントログ）である。

**通知内容の概要**：除外時刻、ノードのホストID、Executor失敗数が含まれる。

**期待されるアクション**：受信者はノードの除外ステータスをUIに反映する。EXCLUDE_ON_FAILURE_KILL_ENABLEDがtrueの場合、ノード上の全Executorがkillまたはデコミッションされる。

## 通知種別

アプリ内イベント通知（SparkListenerEvent）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueue使用） |
| 優先度 | 中 |
| リトライ | なし |

### 送信先決定ロジック

LiveListenerBusに登録された全てのAsyncEventQueueに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッド（86行目）で`listener.onNodeExcluded(nodeExcluded)`が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。

### 本文テンプレート

```
イベント種別: SparkListenerNodeExcluded
JSON形式:
{
  "Event": "SparkListenerNodeExcluded",
  "Timestamp": <timestamp>,
  "Host ID": "<hostId>",
  "Executor Failures": <executorFailures>
}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | 除外時刻（ミリ秒） | clock.getTimeMillis() | Yes |
| hostId | 除外されたノードのホスト名 | HealthTracker内部処理 | Yes |
| executorFailures | ノード上の除外Executor数 | excludedExecsOnNode.sizeまたはハードコード値1（フェッチ失敗時） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | Executor除外の連鎖 | ノード上の除外Executor数 >= MAX_FAILED_EXEC_PER_NODE かつ ノード未除外 | HealthTracker.updateExcludedForSuccessfulTaskSet 310行目 |
| 内部処理 | フェッチ失敗 | EXCLUDE_FETCH_FAILURE_ENABLED=true かつ SHUFFLE_SERVICE_ENABLED=true かつ ノード未除外 | HealthTracker.updateExcludedForFetchFailure 241行目 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| ノード既に除外済み | nodeIdToExcludedExpiryTimeに既にエントリがある場合は再除外しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executor除外/フェッチ失敗] --> B{トリガー種別}
    B -->|Executor除外連鎖| C[HealthTracker.updateExcludedForSuccessfulTaskSet]
    B -->|フェッチ失敗| D[HealthTracker.updateExcludedForFetchFailure]
    C --> E{excludedExecsOnNode.size >= MAX_FAILED_EXEC_PER_NODE?}
    E -->|Yes かつ未除外| F[nodeIdToExcludedExpiryTimeに追加]
    D --> G{シャッフルサービス有効 かつ ノード未除外?}
    G -->|Yes| F
    F --> H[listenerBus.post SparkListenerNodeBlacklisted 後方互換]
    H --> I[listenerBus.post SparkListenerNodeExcluded]
    I --> J[_excludedNodeList更新]
    J --> K[killExecutorsOnExcludedNode]
    E -->|No| L[処理なし]
    G -->|No| L
    I --> M[LiveListenerBus.post]
    M --> N{受信リスナー}
    N -->|AppStatusListener| O[ノード除外ステータス更新]
    N -->|EventLoggingListener| P[イベントログ書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| nodeIdToExcludedExpiryTime（インメモリMap） | 既にノード除外済みかの確認 | HealthTracker内部のHashMap |
| nodeToExcludedExecs（インメモリMap） | ノード上の除外Executor数の確認 | HealthTracker内部のHashMap |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| nodeIdToExcludedExpiryTime（インメモリMap） | INSERT | ノード除外エントリ（expiryTime付き）の追加 |
| _excludedNodeList（AtomicReference） | UPDATE | 除外ノードリストのスナップショット更新 |
| KVStore（AppStatusListener経由） | UPDATE | ノード除外ステータスの更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| INSERT | Event | SparkListenerNodeExcluded | イベントログに書き込み |
| INSERT | Timestamp | clock.getTimeMillis() | 除外時刻 |
| INSERT | Host ID | hostId | 除外されたノードのホスト名 |
| INSERT | Executor Failures | executorFailures | Executor失敗数 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キュー満杯 | AsyncEventQueueのキャパシティ超過 | イベントがドロップされる |
| リスナー例外 | リスナーで例外発生 | ListenerBusが例外をキャッチしログに記録 |
| Executor kill失敗 | killExecutorsOnExcludedNodeでの失敗 | エラーログを出力。ノード除外自体は維持される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0回 |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

イベントにはホストIDとExecutor失敗数が含まれる。ホスト名はクラスタ内部のネットワーク情報であり、Spark UIのACLによるアクセス制御が推奨される。

## 備考

- 本イベントはSpark 3.1.0で導入された（@Since("3.1.0")）。
- 後方互換のためSparkListenerNodeBlacklisted（@deprecated）も同時に発火される。
- SparkListenerNodeUnexcludedと対になるイベントであり、EXCLUDE_ON_FAILURE_TIMEOUT_MILLISの経過後に自動的に解除される。
- EXCLUDE_ON_FAILURE_KILL_ENABLEDがtrueかつEXCLUDE_ON_FAILURE_DECOMMISSION_ENABLEDがtrueの場合、ノード上のExecutorはkillではなくデコミッションされる。
- _excludedNodeListはAtomicReferenceで管理されており、excludedNodeList()メソッドはスレッドセーフにアクセス可能。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 205-209行目: case class SparkListenerNodeExcluded(time, hostId, executorFailures)の定義 |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 296-316行目: updateExcludedForSuccessfulTaskSet内のノード除外判定 |
| 2-2 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 220-262行目: updateExcludedForFetchFailure内のノード除外 |

**主要処理フロー**（updateExcludedForSuccessfulTaskSet）:
1. **298-299行目**: nodeToExcludedExecsの更新
2. **302行目**: excludedExecsOnNode.size >= MAX_FAILED_EXEC_PER_NODEのチェック
3. **307行目**: nodeIdToExcludedExpiryTime.put
4. **309-310行目**: SparkListenerNodeBlacklisted（後方互換）とSparkListenerNodeExcludedの発火
5. **311行目**: _excludedNodeList.setでスナップショット更新
6. **312行目**: killExecutorsOnExcludedNode

#### Step 3: 受信リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 346行目: onNodeExcludedでupdateNodeExcluded(hostId, true)を呼び出し |
| 3-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 232行目: イベントログに記録 |

### プログラム呼び出し階層図

```
Executor除外 / フェッチ失敗
    |
    +-- HealthTracker.updateExcludedForSuccessfulTaskSet()
    |       |
    |       +-- nodeToExcludedExecs更新
    |       +-- nodeIdToExcludedExpiryTime.put(node, expiryTime)
    |       +-- listenerBus.post(SparkListenerNodeBlacklisted) [後方互換]
    |       +-- listenerBus.post(SparkListenerNodeExcluded)
    |       +-- _excludedNodeList.set()
    |       +-- killExecutorsOnExcludedNode()
    |
    +-- HealthTracker.updateExcludedForFetchFailure()
            |
            +-- nodeIdToExcludedExpiryTime.put(host, expiryTime)
            +-- listenerBus.post(SparkListenerNodeBlacklisted) [後方互換]
            +-- listenerBus.post(SparkListenerNodeExcluded)
            +-- _excludedNodeList.set()
            +-- killExecutorsOnExcludedNode()
```

### データフロー図

```
[入力]                        [処理]                              [出力]

Executor除外連鎖 ----------> HealthTracker -----------------> SparkListenerNodeExcluded
or フェッチ失敗               .updateExcluded*()                 イベント
(host, executorFailures)           |
                                   v
                             nodeIdToExcludedExpiryTime更新
                             _excludedNodeList更新
                                   |
                                   v
                             LiveListenerBus.post() ---------> AsyncEventQueue
                                                                    |
                                                                    v
                                                              AppStatusListener --> ノード除外表示
                                                              EventLoggingListener --> ログ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントcase classの定義 |
| HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | ソース | イベントの発火元（ノード除外ロジック） |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期イベントバス |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | ノード除外ステータス表示 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
