# 通知設計書 2-SparkListenerStageCompleted

## 概要

本ドキュメントは、Apache Sparkのコアイベント通知である`SparkListenerStageCompleted`の設計について記述する。このイベントは、ステージの実行が完了（成功または失敗）した際にDAGSchedulerから発火するイベント通知である。

### 本通知の処理概要

SparkListenerStageCompletedは、Sparkジョブ実行におけるステージ完了通知であり、ステージが成功終了または失敗終了したタイミングをリスナーに伝達する。

**業務上の目的・背景**：ステージの完了は、Sparkアプリケーションの進捗追跡において重要なマイルストーンである。Spark UIのステージ一覧更新、イベントログへの記録、動的リソース割り当ての再計算、カスタム監視ツールへの通知など、複数のコンポーネントがこのイベントを利用して処理を行う。ステージの成功・失敗情報はジョブ全体の成否に直結する。

**通知の送信タイミング**：DAGScheduler内の`markStageAsFinished`メソッドで、ステージの最終状態が確定した後に発火する（DAGScheduler.scala L3263）。ステージの正常完了時だけでなく、エラーによる失敗時にも発火する。失敗時は`stageInfo.failureReason`にエラーメッセージが設定される。

**通知の受信者**：SparkListenerInterfaceを実装し、LiveListenerBusに登録されたすべてのリスナーが受信する。主な受信者は、AppStatusListener（Spark UI更新）、EventLoggingListener（イベントログ記録）、ExecutorAllocationManager（動的リソース割り当て）である。

**通知内容の概要**：StageInfo（ステージID、名前、タスク数、完了時間、失敗理由、タスクメトリクスの集約値など）を含む。

**期待されるアクション**：受信したリスナーは、ステージの完了状態をUIに反映する、イベントログに記録する、Executorのピークメトリクスを集約・記録する、動的リソース割り当ての再評価を行うなどの処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由の非同期インプロセス通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由、AsyncEventQueueで別スレッド配信） |
| 優先度 | 中（通常のイベントキューで処理） |
| リトライ | 無し（キュー溢れ時はイベントドロップ） |

### 送信先決定ロジック

LiveListenerBusに登録された全リスナーに対してブロードキャスト配信される。リスナーは`shared`、`appStatus`、`executorManagement`、`eventLog`の各キューに分類され、各キューは独立したスレッドで配信処理を行う。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、Sparkイベントバス経由のインプロセス通知である。

### 本文テンプレート

```
イベントクラス: SparkListenerStageCompleted
シリアライズ形式: JSON（Jackson, @JsonTypeInfo）

{
  "Event": "org.apache.spark.scheduler.SparkListenerStageCompleted",
  "Stage Info": { ... }
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | インプロセス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| stageInfo | ステージの詳細情報（完了時刻、失敗理由含む） | DAGScheduler.stage.latestInfo | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューラ内部処理 | DAGScheduler.markStageAsFinished | ステージ完了時（成功・失敗問わず） | DAGScheduler.scala L3263 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| LiveListenerBus停止後 | `stopped`フラグがtrueの場合、イベントは配信されない |
| キュー容量超過 | AsyncEventQueueの容量を超えた場合、イベントはドロップされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスクセット完了/ステージ失敗] --> B[DAGScheduler.markStageAsFinished]
    B --> C{失敗理由あり?}
    C -->|Yes| D[stageInfo.stageFailed設定]
    C -->|No| E[正常完了]
    D --> F[SparkListenerStageCompleted生成]
    E --> F
    F --> G[listenerBus.post]
    G --> H[AsyncEventQueue経由で非同期配信]
    H --> I[各リスナーのonStageCompleted呼び出し]
    I --> J[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| KVStore（InMemoryStore/LevelDB） | AppStatusListenerがステージ完了情報を格納 | Spark UIのバックエンドストア |

### テーブル別参照項目詳細

#### KVStore

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| StageDataWrapper | ステージの完了状態情報 | stageId, stageAttemptIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KVStore | UPDATE | AppStatusListenerがStageDataWrapperの状態をCOMPLETE/FAILEDに更新 |
| イベントログファイル | APPEND | EventLoggingListenerがJSON形式でイベントを追記 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | StageDataWrapper.status | COMPLETE または FAILED | AppStatusListenerによるKVStore更新 |
| APPEND | イベントログJSON | シリアライズされたイベント | EventLoggingListenerによるログファイル追記 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キューオーバーフロー | イベント生成速度がリスナー処理速度を上回った場合 | イベントがドロップされ、droppedEventsCounterが増加 |
| リスナー例外 | リスナーのonStageCompletedが例外をスローした場合 | ListenerBusで例外をキャッチしログに記録。他リスナーへの配信は継続 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| キュー容量 | デフォルト10,000イベント（設定変更可能） |

### 配信時間帯

時間帯による制限はない。SparkContext起動中は常時配信可能。

## セキュリティ考慮事項

- StageInfoにはユーザーコードの呼び出し元情報（callSite）が含まれる
- 失敗時のエラーメッセージにはスタックトレース情報が含まれる可能性がある
- イベントログファイルのアクセス制御が必要

## 備考

- SparkListenerStageCompletedはstageInfoのみをフィールドに持つシンプルなケースクラスである（SparkListener.scala L37）
- ステージの成功・失敗は`stageInfo.failureReason`（Option[String]）で判別可能
- markStageAsFinished内で`outputCommitCoordinator.stageEnd`が呼ばれた後にイベントが発火される
- `willRetry`がfalseの場合のみoutputCommitCoordinator.stageEndが呼ばれる

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | L37: `case class SparkListenerStageCompleted(stageInfo: StageInfo)`。stageInfoのみの1フィールドケースクラス |

**読解のコツ**: StageInfoクラスの構造（stageId, attemptNumber, name, numTasks, completionTime, failureReasonなど）も併せて確認するとよい。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | L3263: markStageAsFinished内でのpost。L3255-3258: 失敗時のstageFailedメッセージ設定 |

**主要処理フロー**:
1. **L3255**: 失敗理由がある場合、`stage.latestInfo.stageFailed(errorMessage.get)`を呼び出し
2. **L3259**: プッシュベースシャッフルの情報を更新
3. **L3260-3261**: willRetryがfalseの場合、outputCommitCoordinator.stageEndを呼び出し
4. **L3263**: `SparkListenerStageCompleted(stage.latestInfo)`を生成しpost
5. **L3264**: runningStagesからステージを除去

#### Step 3: イベントディスパッチを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | L34-35: SparkListenerStageCompletedのパターンマッチ → listener.onStageCompleted()呼び出し |

### プログラム呼び出し階層図

```
DAGScheduler.markStageAsFinished() [DAGScheduler.scala L3263]
    |
    +-- listenerBus.post(SparkListenerStageCompleted(stage.latestInfo))
            |
            +-- LiveListenerBus.post()
                    |
                    +-- postToQueues()
                            |
                            +-- AsyncEventQueue.post() [各キュー]
                                    |
                                    +-- [配信スレッド] doPostEvent()
                                            |
                                            +-- listener.onStageCompleted()
```

### データフロー図

```
[入力]                     [処理]                           [出力]

DAGScheduler           LiveListenerBus                  各リスナー
(stage.latestInfo)    (AsyncEventQueue x N)

StageInfo ----------> SparkListenerStageCompleted ----> AppStatusListener
 - stageId                                              (KVStore更新)
 - completionTime                                      EventLoggingListener
 - failureReason                                        (イベントログ)
                                                        ExecutorAllocationManager
                                                        (リソース再計算)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | SparkListenerStageCompletedケースクラス定義 |
| DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | ソース | markStageAsFinishedからのイベント発火 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期配信制御 |
| AsyncEventQueue.scala | `core/src/main/scala/org/apache/spark/scheduler/AsyncEventQueue.scala` | ソース | 非同期イベントキュー |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | Spark UI用ステータス更新リスナー |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ記録 |
