# 通知設計書 22-SparkListenerUnschedulableTaskSetRemoved

## 概要

本ドキュメントは、Apache SparkにおけるSparkListenerUnschedulableTaskSetRemovedイベント通知の設計仕様を定義する。このイベントは、以前スケジュール不可能であったタスクセットが再びスケジュール可能になった場合に発火し、動的リソース割り当てマネージャにその状態変化を通知する。

### 本通知の処理概要

本通知は、excludeOnFailure機能によりスケジュール不可能だったタスクセットが、新しいExecutorの参加や除外の解除により再びスケジュール可能となった際に発火するイベントである。

**業務上の目的・背景**：SparkListenerUnschedulableTaskSetAddedの対となるイベントであり、タスクセットのスケジュール可能性が回復したことを通知する。これにより、ExecutorAllocationManagerは不要になったExecutor追加要求を解除し、リソースの過剰割り当てを防止できる。正確なリソース管理のためにスケジュール不可タスクセットの追加・削除の両方を追跡する必要がある。

**通知の送信タイミング**：スケジュール不可能だったタスクセットに対して、少なくとも1つのタスクがスケジュール可能になったことを検出した際に、DAGSchedulerのイベントキューにUnschedulableTaskSetRemovedメッセージが投入され発火する。

**通知の受信者**：LiveListenerBusに登録されたすべてのSparkListenerInterface実装クラスが受信対象。主要な受信者はExecutorAllocationManager内のリスナーであり、unschedulableTaskSetsセットからの該当ステージの削除を行う。

**通知内容の概要**：stageId（ステージID）およびstageAttemptId（ステージ試行ID）の2つのフィールドを含み、どのステージのどの試行がスケジュール可能に復帰したかを特定できる。

**期待されるアクション**：ExecutorAllocationManagerがunschedulableTaskSetsからステージを削除する。これにより、スケジュール不可状態に基づく追加的なExecutor要求が解除され、リソース管理が適正化される。

## 通知種別

アプリ内イベント通知（Sparkイベントリスナーバス経由の非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無（イベントバスのキュー管理に依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerInterface実装リスナーに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッドにおいて、SparkListenerUnschedulableTaskSetRemovedイベントとパターンマッチし、listener.onUnschedulableTaskSetRemoved()が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。本通知はSparkの内部イベントバスを介したプログラマティック通知であり、メール等の外部通知チャネルは使用しない。

### 本文テンプレート

```
イベント: SparkListenerUnschedulableTaskSetRemoved
ステージID: {stageId}
ステージ試行ID: {stageAttemptId}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| stageId | スケジュール可能に復帰したタスクセットが属するステージのID | DAGSchedulerイベント | Yes |
| stageAttemptId | ステージの試行回数ID | DAGSchedulerイベント | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューライベント | タスクセットのスケジュール可能性回復 | excludeOnFailureが有効かつ動的割り当て有効 | 除外されたExecutor/ノードの解除や新規Executorの追加により、少なくとも1つのタスクがスケジュール可能になった場合 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 動的割り当て無効 | spark.dynamicAllocation.enabledがfalseの場合、本イベントは発火しない |
| 対応するAddイベント未発火 | SparkListenerUnschedulableTaskSetAddedが先行して発火していない場合、本イベントも発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスクセットがスケジュール可能に復帰] --> B[DAGSchedulerEventProcessLoop: UnschedulableTaskSetRemoved]
    B --> C[DAGScheduler.handleUnschedulableTaskSetRemoved]
    C --> D[listenerBus.post SparkListenerUnschedulableTaskSetRemoved]
    D --> E[SparkListenerBus.doPostEvent]
    E --> F[listener.onUnschedulableTaskSetRemoved]
    F --> G[ExecutorAllocationManager: unschedulableTaskSets削除]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。本通知はインメモリのイベントバスを使用し、データベースへのアクセスは行わない。

### 更新テーブル一覧

該当なし。ただし、EventLoggingListenerが有効な場合はイベントログファイル（JSON形式）に書き込まれる。

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonUnschedulableTaskSetRemoved実装で例外発生 | ListenerBusが例外をキャッチしログ出力。他リスナーへの配信は継続 |
| イベントキュー溢れ | LiveListenerBusのキューが満杯 | イベントがドロップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（イベント発生頻度に依存） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。Sparkアプリケーションの実行中、条件が満たされれば随時発火する。

## セキュリティ考慮事項

本通知にはステージIDとステージ試行IDのみが含まれ、個人情報や機密データは含まれない。

## 備考

- Since 3.1.0で導入されたイベントである。
- SparkListenerUnschedulableTaskSetAddedの対となるイベントである。
- ExecutorAllocationManagerでは、このイベント受信時にunschedulableTaskSetsセットをクリアする（行859: "Clear unschedulableTaskSets since atleast one task becomes schedulable now"）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントのデータ構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 行227-231: SparkListenerUnschedulableTaskSetRemovedケースクラスの定義。stageIdとstageAttemptIdの2フィールドを持つ |

**読解のコツ**: SparkListenerUnschedulableTaskSetAddedと同一のフィールド構成を持つ。@Since("3.1.0")アノテーション付き。

#### Step 2: エントリーポイントを理解する

DAGSchedulerでのイベント発火メカニズムを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | 行3563-3564: DAGSchedulerEventProcessLoopにおけるUnschedulableTaskSetRemovedメッセージの処理 |
| 2-2 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | 行1308-1311: handleUnschedulableTaskSetRemovedメソッド。listenerBus.postでイベントを発火 |

**主要処理フロー**:
1. **行3563**: DAGSchedulerEventProcessLoopがUnschedulableTaskSetRemovedメッセージを受信
2. **行3564**: dagScheduler.handleUnschedulableTaskSetRemoved(stageId, stageAttemptId)を呼び出し
3. **行1311**: listenerBus.post(SparkListenerUnschedulableTaskSetRemoved(stageId, stageAttemptId))でイベント発火

#### Step 3: イベント配信層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | 行96-97: doPostEventでSparkListenerUnschedulableTaskSetRemovedをパターンマッチし、listener.onUnschedulableTaskSetRemovedを呼び出す |

#### Step 4: 主要リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ExecutorAllocationManager.scala | `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` | 行853-859: onUnschedulableTaskSetRemovedのオーバーライド。unschedulableTaskSetsからステージを削除 |

**主要処理フロー**:
- **行855**: stageIdを取得
- **行856**: stageAttemptIdを取得
- **行857**: StageAttemptオブジェクトを生成
- **行859**: unschedulableTaskSetsをクリア（少なくとも1つのタスクがスケジュール可能になったため）

### プログラム呼び出し階層図

```
TaskSetManager (スケジュール可能性回復検出)
    |
    +-- DAGSchedulerEventProcessLoop.onReceive
           |
           +-- UnschedulableTaskSetRemoved(stageId, stageAttemptId)
                  |
                  +-- DAGScheduler.handleUnschedulableTaskSetRemoved
                         |
                         +-- listenerBus.post(SparkListenerUnschedulableTaskSetRemoved)
                                |
                                +-- SparkListenerBus.doPostEvent
                                       |
                                       +-- listener.onUnschedulableTaskSetRemoved
                                              |
                                              +-- ExecutorAllocationManager.onUnschedulableTaskSetRemoved
                                                     |
                                                     +-- unschedulableTaskSets.clear()
```

### データフロー図

```
[入力]                          [処理]                                      [出力]

stageId, stageAttemptId ------> DAGScheduler.handleUnschedulableTaskSetRemoved ---> SparkListenerUnschedulableTaskSetRemoved
                                       |
                                       v
                                LiveListenerBus (非同期キュー)
                                       |
                                       v
                                ExecutorAllocationManager -----------------------> unschedulableTaskSetsクリア
                                EventLoggingListener ----------------------------> イベントログ (JSON)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントケースクラスおよびリスナーインターフェース定義 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベント配信のディスパッチロジック |
| DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | ソース | イベント発火元（handleUnschedulableTaskSetRemoved） |
| ExecutorAllocationManager.scala | `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` | ソース | 主要リスナー。unschedulableTaskSetsの管理 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログへの永続化 |
| JsonProtocol.scala | `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` | ソース | イベントのJSON直列化・逆直列化 |
