# 通知設計書 23-SparkListenerBlockUpdated

## 概要

本ドキュメントは、Apache SparkにおけるSparkListenerBlockUpdatedイベント通知の設計仕様を定義する。このイベントは、ブロック（RDDパーティションやブロードキャスト変数など）の更新情報がBlockManagerMasterEndpointで処理された際に発火し、ストレージ状態の変化をリスナーに通知する。

### 本通知の処理概要

本通知は、Sparkのストレージ管理において、ブロックの追加・更新・削除などのステータス変更が発生した際に、BlockManagerMasterEndpointからLiveListenerBusを経由して配信されるイベントである。

**業務上の目的・背景**：Sparkのストレージシステムでは、RDDパーティションのキャッシュ、ブロードキャスト変数の配布、シャッフルデータの管理など、さまざまなブロック操作が行われる。これらの変更をリアルタイムで追跡することにより、Spark UI上でのストレージ状態の表示、動的リソース割り当てにおけるExecutorのキャッシュデータ保持状況の把握、およびイベントログへの記録が可能となる。

**通知の送信タイミング**：BlockManagerMasterEndpointがupdateBlockInfoメッセージを受信し、ブロック情報の更新に成功した場合に発火する。更新が失敗した場合（戻り値がfalse）にはイベントは発火しない（SPARK-30594対応）。

**通知の受信者**：LiveListenerBusに登録されたすべてのSparkListenerInterface実装クラスが受信対象。主要な受信者はAppStatusListener（Spark UIのストレージ表示更新）、ExecutorMonitor（動的割り当て時のExecutorキャッシュ追跡）、EventLoggingListener（イベントログ永続化、spark.eventLog.logBlockUpdates.enabled=trueの場合のみ）である。

**通知内容の概要**：BlockUpdatedInfoオブジェクトを含み、blockManagerId（どのBlockManagerか）、blockId（どのブロックか）、storageLevel（ストレージレベル）、memSize（メモリサイズ）、diskSize（ディスクサイズ）などの情報が格納される。

**期待されるアクション**：Spark UIがストレージタブの情報を更新する。ExecutorMonitorがExecutorのキャッシュ状態を更新し、キャッシュデータを持つExecutorの解放を抑制する。

## 通知種別

アプリ内イベント通知（Sparkイベントリスナーバス経由の非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 低（高頻度で発生するため） |
| リトライ | 無（イベントバスのキュー管理に依存） |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerInterface実装リスナーに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッドにおいて、SparkListenerBlockUpdatedイベントとパターンマッチし、listener.onBlockUpdated()が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。本通知はSparkの内部イベントバスを介したプログラマティック通知である。

### 本文テンプレート

```
イベント: SparkListenerBlockUpdated
BlockManager ID: {blockManagerId}
Block ID: {blockId}
Storage Level: {storageLevel}
Memory Size: {memSize}
Disk Size: {diskSize}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| blockUpdatedInfo | ブロック更新情報を包含するオブジェクト | BlockManagerMasterEndpoint | Yes |
| blockUpdatedInfo.blockManagerId | 更新元のBlockManagerを識別するID | UpdateBlockInfo メッセージ | Yes |
| blockUpdatedInfo.blockId | 更新対象のブロックID | UpdateBlockInfo メッセージ | Yes |
| blockUpdatedInfo.storageLevel | ストレージレベル（メモリ/ディスク/オフヒープ等） | UpdateBlockInfo メッセージ | Yes |
| blockUpdatedInfo.memSize | メモリ上のサイズ（バイト） | UpdateBlockInfo メッセージ | Yes |
| blockUpdatedInfo.diskSize | ディスク上のサイズ（バイト） | UpdateBlockInfo メッセージ | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| ストレージ操作 | BlockManagerMasterEndpoint.updateBlockInfo成功 | updateBlockInfoがtrueを返した場合 | ブロック情報の更新が成功した場合にのみ発火（SPARK-30594） |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| updateBlockInfo失敗 | ブロック情報の更新が失敗した場合（戻り値false）、イベントは発火しない |
| EventLogging時のフラグ | spark.eventLog.logBlockUpdates.enabledがfalseの場合、EventLoggingListenerでのログ記録はスキップされる（ただしイベント自体は発火する） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[Executor: BlockManager.reportBlockStatus] --> B[BlockManagerMasterEndpoint: UpdateBlockInfo受信]
    B --> C{updateBlockInfo成功?}
    C -->|成功| D[listenerBus.post SparkListenerBlockUpdated]
    C -->|失敗| E[イベントスキップ]
    D --> F[SparkListenerBus.doPostEvent]
    F --> G[listener.onBlockUpdated]
    G --> H[AppStatusListener: ストレージ情報更新]
    G --> I[ExecutorMonitor: キャッシュ追跡更新]
    G --> J[EventLoggingListener: ログ記録 条件付き]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。本通知はインメモリのイベントバスを使用する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| AppStatusStore (KVStore) | UPDATE | AppStatusListenerがRDDストレージ情報を更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonBlockUpdated実装で例外発生 | ListenerBusが例外をキャッチしログ出力 |
| イベントキュー溢れ | LiveListenerBusのキューが満杯 | イベントがドロップされる |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ブロック操作頻度に依存。高頻度で発生し得る） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ブロック操作が発生するたびに即座に発火する。

## セキュリティ考慮事項

本通知にはブロックID、ストレージレベル、サイズ情報が含まれるが、ブロックの実データは含まれない。個人情報や機密データへの直接的なアクセスリスクはない。

## 備考

- SPARK-30594: updateBlockInfoがfalseを返した場合にイベントを発火しないよう修正された。
- EventLoggingListenerではspark.eventLog.logBlockUpdates.enabled（デフォルトfalse）により記録可否が制御される。
- BasicEventFilterBuilderでは、ブロック更新イベントのフィルタリングにblockManagerIdを使用する（行167）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 行234: SparkListenerBlockUpdatedケースクラスの定義。BlockUpdatedInfoを含む |
| 1-2 | BlockUpdatedInfo | `core/src/main/scala/org/apache/spark/storage/BlockUpdatedInfo.scala` | BlockUpdatedInfoのフィールド（blockManagerId, blockId, storageLevel, memSize, diskSize） |

**読解のコツ**: BlockUpdatedInfoはUpdateBlockInfoメッセージから生成されるラッパーオブジェクトである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | BlockManagerMasterEndpoint.scala | `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` | 行145-152: UpdateBlockInfoメッセージ処理。updateBlockInfoが成功した場合のみSparkListenerBlockUpdatedを発火 |

**主要処理フロー**:
1. **行146**: handleResult関数の定義
2. **行147-148**: SPARK-30594のコメント - updateBlockInfoがfalseを返す場合はイベントを発火しない
3. **行149-150**: 成功時にlistenerBus.post(SparkListenerBlockUpdated(BlockUpdatedInfo(_updateBlockInfo)))を呼び出し

#### Step 3: イベント配信層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | 行90-91: doPostEventでSparkListenerBlockUpdatedをパターンマッチ |

#### Step 4: 主要リスナーの処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ExecutorMonitor.scala | `core/src/main/scala/org/apache/spark/scheduler/dynalloc/ExecutorMonitor.scala` | 行383-388: onBlockUpdatedのオーバーライド。Executorのキャッシュ状態を追跡 |
| 4-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 行244-248: shouldLogBlockUpdatesフラグに基づき条件付きでログ記録 |

### プログラム呼び出し階層図

```
BlockManager.reportBlockStatus (Executor)
    |
    +-- BlockManagerMasterEndpoint.receiveAndReply
           |
           +-- case UpdateBlockInfo
                  |
                  +-- updateBlockInfo (成功時のみ)
                         |
                         +-- listenerBus.post(SparkListenerBlockUpdated)
                                |
                                +-- SparkListenerBus.doPostEvent
                                       |
                                       +-- listener.onBlockUpdated
                                              |
                                              +-- AppStatusListener (ストレージ情報更新)
                                              +-- ExecutorMonitor (キャッシュ追跡)
                                              +-- EventLoggingListener (条件付きログ記録)
```

### データフロー図

```
[入力]                          [処理]                                  [出力]

UpdateBlockInfo ----------> BlockManagerMasterEndpoint ---------> SparkListenerBlockUpdated
(blockManagerId,               |                                       |
 blockId,                      v                                       v
 storageLevel,           updateBlockInfo                         AppStatusStore更新
 memSize,                (成功/失敗判定)                          ExecutorMonitor更新
 diskSize)                                                       イベントログ (条件付き)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントケースクラス定義 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベント配信ディスパッチ |
| BlockManagerMasterEndpoint.scala | `core/src/main/scala/org/apache/spark/storage/BlockManagerMasterEndpoint.scala` | ソース | イベント発火元 |
| ExecutorMonitor.scala | `core/src/main/scala/org/apache/spark/scheduler/dynalloc/ExecutorMonitor.scala` | ソース | キャッシュブロック追跡リスナー |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | Spark UI用ストレージ情報リスナー |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ永続化（条件付き） |
| BasicEventFilterBuilder.scala | `core/src/main/scala/org/apache/spark/deploy/history/BasicEventFilterBuilder.scala` | ソース | 履歴サーバ用イベントフィルタ |
| JsonProtocol.scala | `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` | ソース | JSON直列化・逆直列化 |
