# 通知設計書 29-SparkListenerResourceProfileAdded

## 概要

本ドキュメントは、Apache SparkにおけるSparkListenerResourceProfileAddedイベント通知の設計仕様を定義する。このイベントは、ResourceProfile（リソースプロファイル）がResourceProfileManagerに追加された際に発火し、リソース要件の変更をリスナーに通知する。

### 本通知の処理概要

本通知は、Sparkのリソース管理において新しいResourceProfileが登録された際に発火するイベントである。ResourceProfileはExecutorとタスクのリソース要件（CPU、メモリ、GPUなど）を定義するオブジェクトであり、動的リソース割り当てにおけるリソースの異種構成をサポートする。

**業務上の目的・背景**：Spark 3.1.0から導入されたResourceProfile機能により、異なるリソース要件を持つExecutorを同一アプリケーション内で混在させることが可能になった。このイベントは、新しいResourceProfileの登録をリスナーに通知し、Spark UIでのリソースプロファイル情報の表示、イベントログへの記録、およびリソース管理の追跡を可能にする。YARN、Kubernetes、Standalone（動的割り当て有効時）で使用される。

**通知の送信タイミング**：ResourceProfileManager.addResourceProfile()メソッドで新しいResourceProfileが初めて追加された際に発火する。既に同一IDのProfileが登録済みの場合はイベントは発火しない。デフォルトのResourceProfileはResourceProfileManagerの初期化時に追加される。

**通知の受信者**：LiveListenerBusに登録されたすべてのSparkListenerInterface実装クラス。主要な受信者はAppStatusListener（ResourceProfileのKVStore書き込み）、EventLoggingListener（イベントログへの永続化）である。

**通知内容の概要**：resourceProfile（ResourceProfileオブジェクト）の1フィールドを含み、プロファイルID、Executorリソース要件、タスクリソース要件などの情報が格納される。

**期待されるアクション**：AppStatusListenerがResourceProfile情報をKVStoreに書き込み、Spark UIのEnvironmentタブに表示する。EventLoggingListenerがイベントログに記録する。

## 通知種別

アプリ内イベント通知（Sparkイベントリスナーバス経由の非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無 |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerInterface実装リスナーに対してブロードキャスト配信される。SparkListenerBus.doPostEventメソッドにおいて、SparkListenerResourceProfileAddedイベントとパターンマッチし、listener.onResourceProfileAdded()が呼び出される。

## 通知テンプレート

### メール通知の場合

該当なし。本通知はSparkの内部イベントバスを介したプログラマティック通知である。

### 本文テンプレート

```
イベント: SparkListenerResourceProfileAdded
Profile ID: {resourceProfile.id}
Executor Resource Requests: {resourceProfile.executorResources}
Task Resource Requests: {resourceProfile.taskResources}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| resourceProfile | ResourceProfileオブジェクト | ResourceProfileManager.addResourceProfile | Yes |
| resourceProfile.id | プロファイルの一意ID | ResourceProfile.id | Yes |
| resourceProfile.executorResources | Executorリソース要件マップ | ResourceProfile | Yes |
| resourceProfile.taskResources | タスクリソース要件マップ | ResourceProfile | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| リソースプロファイル登録 | ResourceProfileManager.addResourceProfile | 新しいProfileが初めて登録された場合 | 同一IDが既に存在する場合は発火しない |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 同一ID登録済み | resourceProfileIdToResourceProfileマップに既にIDが存在する場合 |
| サポート外環境 | ResourceProfileがサポートされていない環境（YARN/K8s/Standalone以外かつ動的割り当て無効）では例外がスローされる |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ResourceProfileManager.addResourceProfile] --> B{新しいProfile?}
    B -->|Yes| C[isSupported チェック]
    B -->|No| D[スキップ]
    C --> E[writeLockで排他制御]
    E --> F[resourceProfileIdToResourceProfileに登録]
    F --> G[limitingResource計算]
    G --> H[listenerBus.post SparkListenerResourceProfileAdded]
    H --> I[SparkListenerBus.doPostEvent]
    I --> J[listener.onResourceProfileAdded]
    J --> K[AppStatusListener: KVStore書き込み]
    J --> L[EventLoggingListener: イベントログ記録]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| AppStatusStore (KVStore) | INSERT | AppStatusListenerがResourceProfileInfoWrapperを書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| サポート外エラー | 非対応クラスタマネージャで非デフォルトProfileを使用 | SparkExceptionがスロー |
| リスナー例外 | リスナーのonResourceProfileAdded実装で例外発生 | ListenerBusが例外をキャッチしログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（ResourceProfile追加頻度に依存。通常は少数） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。ResourceProfileが追加されるたびに発火する。

## セキュリティ考慮事項

本通知にはリソースプロファイルのID、リソース要件（CPU数、メモリ量、GPU数等）が含まれる。インフラ構成情報であるため、機密性の高い環境では注意が必要だが、個人情報は含まれない。

## 備考

- Since 3.1.0で導入されたイベントである。
- ResourceProfileManagerはwriteLockによる排他制御を行い、同一IDの二重登録を防止する。
- デフォルトのResourceProfile（ID=0）はResourceProfileManager初期化時に必ず追加される（行60）。
- isSupported()メソッドにより、サポート外環境での使用は例外でブロックされる。ただしテスト時は例外がスキップされる（notRunningUnitTestsフラグ）。
- JsonProtocolでの直列化では"Resource Profile Id"、"Executor Resource Requests"、"Task Resource Requests"キーが使用される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 行293-296: SparkListenerResourceProfileAddedケースクラスの定義。ResourceProfileを含む |

**読解のコツ**: ResourceProfileクラスにはid、executorResources、taskResourcesなどのフィールドがある。@Since("3.1.0")アノテーション付き。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ResourceProfileManager.scala | `core/src/main/scala/org/apache/spark/resource/ResourceProfileManager.scala` | 行128-147: addResourceProfileメソッド。isSupported確認、writeLockで排他制御、新規Profileの場合のみlistenerBus.post |

**主要処理フロー**:
1. **行129**: isSupported(rp)でサポートチェック
2. **行131-138**: writeLock内でresourceProfileIdToResourceProfileに登録
3. **行141-146**: putNewProfileがtrueの場合、limitingResource計算後にlistenerBus.post(SparkListenerResourceProfileAdded(rp))

#### Step 3: イベント配信層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | 行98-99: doPostEventでSparkListenerResourceProfileAddedをパターンマッチ |

#### Step 4: リスナー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 行154-159: onResourceProfileAddedの実装。maxTasksとexecutorResources、taskResourcesを取得してKVStoreに書き込み |
| 4-2 | EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | 行270-272: onResourceProfileAddedの実装。flushLogger=trueでログ記録 |

### プログラム呼び出し階層図

```
ResourceProfileManager.addResourceProfile(rp)
    |
    +-- isSupported(rp) チェック
    +-- writeLock.lock()
    |      |
    |      +-- resourceProfileIdToResourceProfile.put(rp.id, rp)
    |
    +-- writeLock.unlock()
    +-- rp.limitingResource(sparkConf) 計算
    +-- listenerBus.post(SparkListenerResourceProfileAdded(rp))
           |
           +-- SparkListenerBus.doPostEvent
                  |
                  +-- AppStatusListener.onResourceProfileAdded
                  |      |
                  |      +-- KVStore書き込み (ResourceProfileInfoWrapper)
                  |
                  +-- EventLoggingListener.onResourceProfileAdded
                         |
                         +-- logEvent (flushLogger=true)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

ResourceProfile ----------> ResourceProfileManager ----------> SparkListenerResourceProfileAdded
(id, executorResources,         .addResourceProfile               |
 taskResources)                    |                              v
                                   v                        AppStatusStore (KVStore)
                            LiveListenerBus                  イベントログ (JSON)
                                   |
                                   v
                            リスナーへ配信
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントケースクラス定義 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベント配信ディスパッチ |
| ResourceProfileManager.scala | `core/src/main/scala/org/apache/spark/resource/ResourceProfileManager.scala` | ソース | イベント発火元（addResourceProfile） |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | KVStore書き込みリスナー |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ永続化 |
| JsonProtocol.scala | `core/src/main/scala/org/apache/spark/util/JsonProtocol.scala` | ソース | JSON直列化・逆直列化 |
