# 通知設計書 30-SparkListenerMiscellaneousProcessAdded

## 概要

本ドキュメントは、Apache SparkにおけるSparkListenerMiscellaneousProcessAddedイベント通知の設計仕様を定義する。このイベントは、DriverやExecutor以外のその他のプロセス（例：外部シャッフルサービスなど）がクラスタに追加された際に発火し、プロセス情報をリスナーに通知する。

### 本通知の処理概要

本通知は、CoarseGrainedSchedulerBackendがMiscellaneousProcessAddedメッセージを受信した際に発火するイベントであり、クラスタに追加された補助的プロセスの情報をリスナーに配信する。

**業務上の目的・背景**：Sparkクラスタには、DriverやExecutor以外にも外部シャッフルサービスやカスタムプロセスなどの補助的プロセスが参加する場合がある。これらのプロセスの存在と情報を追跡することで、Spark UIの「Other Processes」セクションでプロセス一覧を表示し、運用監視やデバッグを支援する。Since 3.2.0で導入された機能である。

**通知の送信タイミング**：CoarseGrainedSchedulerBackendのDriverEndpointがMiscellaneousProcessAddedメッセージを受信した際に発火する。このメッセージは、クラスタマネージャ（例：YARN ApplicationMaster）からSchedulerBackendに送信される。

**通知の受信者**：LiveListenerBusに登録されたすべてのSparkListenerInterface実装クラス。ただし、本イベントはSparkListenerBusのdoPostEventに専用caseブランチを持たず、onOtherEventにフォールスルーする。主要な受信者はAppStatusListener（onOtherEvent内でMiscellaneousProcessの情報をKVStoreに書き込み）である。

**通知内容の概要**：time（追加時刻）、processId（プロセスID）、info（MiscellaneousProcessDetailsオブジェクト：hostPort、cores、logUrlInfo）の3フィールドを含む。

**期待されるアクション**：AppStatusListenerがプロセス情報をKVStoreに書き込み、Spark UIの「Other Processes」セクションに表示する。

## 通知種別

アプリ内イベント通知（Sparkイベントリスナーバス経由の非同期配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 低 |
| リトライ | 無 |

### 送信先決定ロジック

LiveListenerBusに登録されたすべてのSparkListenerInterface実装リスナーに対してブロードキャスト配信される。SparkListenerBus.doPostEventには本イベント用の専用caseブランチがないため、default case（行100）によりlistener.onOtherEvent()が呼び出される。AppStatusListenerのonOtherEvent内でSparkListenerMiscellaneousProcessAddedをパターンマッチして処理する。

## 通知テンプレート

### メール通知の場合

該当なし。本通知はSparkの内部イベントバスを介したプログラマティック通知である。

### 本文テンプレート

```
イベント: SparkListenerMiscellaneousProcessAdded
時刻: {time}
プロセスID: {processId}
ホスト:ポート: {info.hostPort}
コア数: {info.cores}
ログURL: {info.logUrlInfo}
```

### 添付ファイル

該当なし。

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | プロセス追加時刻（ミリ秒） | MiscellaneousProcessAddedメッセージ | Yes |
| processId | プロセスの一意識別子 | MiscellaneousProcessAddedメッセージ | Yes |
| info | MiscellaneousProcessDetailsオブジェクト | MiscellaneousProcessAddedメッセージ | Yes |
| info.hostPort | プロセスのホスト:ポート | MiscellaneousProcessDetails | Yes |
| info.cores | プロセスのコア数 | MiscellaneousProcessDetails | Yes |
| info.logUrlInfo | ログURLのマップ | MiscellaneousProcessDetails | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| プロセス追加 | CoarseGrainedSchedulerBackend.DriverEndpointがMiscellaneousProcessAddedメッセージ受信 | 常時 | クラスタマネージャがプロセス追加を通知した際に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 特になし | MiscellaneousProcessAddedメッセージが到着するたびにイベントが発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[クラスタマネージャ: プロセス追加通知] --> B[CoarseGrainedSchedulerBackend.DriverEndpoint]
    B --> C[MiscellaneousProcessAddedメッセージ受信]
    C --> D[listenerBus.post SparkListenerMiscellaneousProcessAdded]
    D --> E[SparkListenerBus.doPostEvent: default case]
    E --> F[listener.onOtherEvent]
    F --> G[AppStatusListener: onOtherEventでパターンマッチ]
    G --> H[onMiscellaneousProcessAdded: KVStore書き込み]
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| AppStatusStore (KVStore) | INSERT/UPDATE | AppStatusListenerがMiscellaneousProcessのログURL、ホストポート、コア数を書き込み |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonOtherEvent実装で例外発生 | ListenerBusが例外をキャッチしログ出力 |
| メッセージ処理エラー | DriverEndpointでの予期しないメッセージ | logErrorでエラーログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし（プロセス追加頻度に依存。通常は少数） |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。プロセスが追加されるたびに発火する。

## セキュリティ考慮事項

本通知にはプロセスID、ホスト:ポート、コア数、ログURLが含まれる。ホスト情報やログURLはインフラ構成情報であるため、外部公開環境では注意が必要。個人情報は含まれない。

## 備考

- Since 3.2.0で導入されたイベントである。
- MiscellaneousProcessDetailsクラスは`core/src/main/scala/org/apache/spark/scheduler/MiscellaneousProcessDetails.scala`で定義されており、hostPort（String）、cores（Int）、logUrlInfo（Map[String, String]）の3フィールドを持つSerializable。
- SparkListenerBusのdoPostEventには専用caseブランチがなく、default caseでonOtherEventに渡される。
- AppStatusListenerのonOtherEvent（行112）で`case processInfoEvent: SparkListenerMiscellaneousProcessAdded`としてパターンマッチされる。
- CoarseGrainedSchedulerBackendのDriverEndpoint（行243-245）でMiscellaneousProcessAddedメッセージを処理する。
- CoarseGrainedClusterMessageの一部としてMiscellaneousProcessAddedメッセージが定義されている（行142-144）。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 行236-239: SparkListenerMiscellaneousProcessAddedケースクラスの定義。time、processId、infoの3フィールド |
| 1-2 | MiscellaneousProcessDetails.scala | `core/src/main/scala/org/apache/spark/scheduler/MiscellaneousProcessDetails.scala` | 行28-31: MiscellaneousProcessDetailsクラスの定義。hostPort、cores、logUrlInfoの3フィールド |

**読解のコツ**: @Since("3.2.0")アノテーションが付与されている。MiscellaneousProcessDetailsはSerializableを実装しており、RPC経由でのメッセージ送信に対応している。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CoarseGrainedSchedulerBackend.scala | `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` | 行243-245: DriverEndpointのreceiveメソッド内でMiscellaneousProcessAddedメッセージを処理し、SparkListenerMiscellaneousProcessAddedを発火 |
| 2-2 | CoarseGrainedClusterMessage.scala | `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedClusterMessage.scala` | 行142-144: MiscellaneousProcessAddedメッセージの定義 |

**主要処理フロー**:
1. **行243-244**: MiscellaneousProcessAdded(time, processId, info)メッセージをパターンマッチ
2. **行245**: listenerBus.post(SparkListenerMiscellaneousProcessAdded(time, processId, info))

#### Step 3: イベント配信層を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | 行100: default case `case _ => listener.onOtherEvent(event)`。専用caseブランチなし |

#### Step 4: リスナー処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 行110-113: onOtherEvent内でSparkListenerMiscellaneousProcessAddedをパターンマッチし、onMiscellaneousProcessAddedを呼び出す |
| 4-2 | AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | 行1436-1442: onMiscellaneousProcessAddedの実装。processLogs、hostPort、isActiveなどを設定しKVStoreに書き込み |

### プログラム呼び出し階層図

```
クラスタマネージャ (例: YARN AM)
    |
    +-- RPC: MiscellaneousProcessAdded メッセージ
           |
           +-- CoarseGrainedSchedulerBackend.DriverEndpoint.receive
                  |
                  +-- case MiscellaneousProcessAdded(time, processId, info)
                         |
                         +-- listenerBus.post(SparkListenerMiscellaneousProcessAdded)
                                |
                                +-- SparkListenerBus.doPostEvent (default case)
                                       |
                                       +-- listener.onOtherEvent
                                              |
                                              +-- AppStatusListener.onOtherEvent
                                                     |
                                                     +-- onMiscellaneousProcessAdded
                                                            |
                                                            +-- KVStore書き込み
```

### データフロー図

```
[入力]                              [処理]                              [出力]

MiscellaneousProcessAdded ----> CoarseGrainedSchedulerBackend ----> SparkListenerMiscellaneousProcessAdded
(time, processId, info)             .DriverEndpoint                      |
                                       |                                 v
                                       v                          AppStatusStore (KVStore)
                                 LiveListenerBus                   イベントログ (JSON, onOtherEvent経由)
                                       |
                                       v
                                 リスナーへ配信 (onOtherEvent)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントケースクラス定義 |
| MiscellaneousProcessDetails.scala | `core/src/main/scala/org/apache/spark/scheduler/MiscellaneousProcessDetails.scala` | ソース | プロセス詳細情報クラス定義 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベント配信ディスパッチ（default caseでonOtherEvent） |
| CoarseGrainedSchedulerBackend.scala | `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedSchedulerBackend.scala` | ソース | イベント発火元（DriverEndpoint） |
| CoarseGrainedClusterMessage.scala | `core/src/main/scala/org/apache/spark/scheduler/cluster/CoarseGrainedClusterMessage.scala` | ソース | MiscellaneousProcessAddedメッセージ定義 |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | KVStore書き込みリスナー |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログ永続化（onOtherEvent経由） |
