# 通知設計書 31-SparkListenerExecutorBlacklisted

## 概要

本ドキュメントは、Apache SparkにおけるSparkListenerExecutorBlacklistedイベント通知の設計について記述する。本イベントはExecutorがブラックリスト（除外リスト）に追加された際に発火する非推奨イベントであり、Spark 3.1.0以降はSparkListenerExecutorExcludedに置き換えられている。

### 本通知の処理概要

SparkListenerExecutorBlacklistedは、ドライバがExecutorをアプリケーションレベルで除外（ブラックリスト）した際に発火するイベント通知である。後方互換性のためにSparkListenerExecutorExcludedと同時に発行される。

**業務上の目的・背景**：分散処理環境において、特定のExecutorで繰り返しタスク失敗が発生した場合、そのExecutorを除外してクラスタの安定性を維持する必要がある。本通知は、そのような除外が発生したことをリスナーに通知し、モニタリングやUI表示を可能にする。HealthTracker機能（旧BlacklistTracker）がExecutorの障害パターンを追跡し、閾値を超えた場合に除外を実行する。

**通知の送信タイミング**：(1) TaskSetが正常完了後、Executorのタスク失敗数が`spark.excludeOnFailure.application.maxFailedTasksPerExecutor`の閾値を超えた場合、(2) フェッチ失敗時にexcludeOnFetchFailureが有効な場合にExecutorが除外される際。

**通知の受信者**：LiveListenerBusに登録された全てのSparkListenerInterface実装。主にAppStatusListener（Spark UI用）、EventLoggingListener（イベントログ記録用）、および任意のカスタムリスナー。

**通知内容の概要**：除外されたExecutorのID、除外が発生した時刻（ミリ秒）、およびそのExecutor上で発生したタスク失敗数が含まれる。

**期待されるアクション**：受信リスナーはExecutor除外の状態をUI上に反映し、イベントログに記録する。運用者はこの情報を基にクラスタの健全性を監視し、問題のあるノードの調査・対応を行う。

## 通知種別

アプリ内通知（Sparkイベントバスによるインプロセス非同期イベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | なし（イベントバスのキューイングにより配信保証） |

### 送信先決定ロジック

LiveListenerBusに登録された全てのSparkListenerInterface実装に対してブロードキャスト配信される。SparkListenerBus.doPostEventのパターンマッチにより`onExecutorBlacklisted`メソッドが呼び出される。

## 通知テンプレート

### イベントオブジェクト

| 項目 | 内容 |
|-----|------|
| イベントクラス | `SparkListenerExecutorBlacklisted` |
| パッケージ | `org.apache.spark.scheduler` |
| 親クラス | `SparkListenerEvent` |
| シリアライズ形式 | JSON（JsonProtocol経由） |

### イベントデータ構造

```scala
@deprecated("use SparkListenerExecutorExcluded instead", "3.1.0")
case class SparkListenerExecutorBlacklisted(
    time: Long,
    executorId: String,
    taskFailures: Int)
  extends SparkListenerEvent
```

### 添付ファイル

該当なし（インプロセスイベントのため）

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| time | イベント発生時刻（ミリ秒） | `clock.getTimeMillis()` | Yes |
| executorId | 除外対象のExecutor ID | HealthTracker内部管理 | Yes |
| taskFailures | タスク失敗数 | ExecutorFailureList.numUniqueTaskFailures | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| 内部処理 | TaskSet正常完了 | Executorのタスク失敗数がMAX_FAILURES_PER_EXEC以上 | HealthTracker.updateExcludedForSuccessfulTaskSet内で発火 |
| 内部処理 | フェッチ失敗発生 | EXCLUDE_FETCH_FAILURE_ENABLED=trueかつシャッフルサービス無効 | HealthTracker.updateExcludedForFetchFailure内で発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 既に除外済み | executorIdToExcludedStatusに既に登録されているExecutorは再除外されない |
| excludeOnFailure無効 | HealthTrackerが生成されない場合（機能無効時）はイベント自体が発生しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TaskSet完了 or フェッチ失敗] --> B{HealthTracker有効?}
    B -->|Yes| C[失敗数カウント更新]
    B -->|No| Z[処理終了]
    C --> D{閾値超過?}
    D -->|Yes| E{既に除外済み?}
    D -->|No| Z
    E -->|No| F[Executor除外登録]
    E -->|Yes| Z
    F --> G[SparkListenerExecutorBlacklisted発行]
    F --> H[SparkListenerExecutorExcluded発行]
    G --> I[LiveListenerBusでリスナーに配信]
    H --> I
    I --> Z
```

## データベース参照・更新仕様

### 参照テーブル一覧

該当なし（RDBMSは使用しない。インメモリのデータ構造を参照）

### インメモリデータ構造

| データ構造 | 用途 | 備考 |
|-----------|------|------|
| executorIdToFailureList | Executor毎のタスク失敗履歴 | HashMap[String, ExecutorFailureList] |
| executorIdToExcludedStatus | 除外済みExecutorの管理 | HashMap[String, ExcludedExecutor] |
| nodeToExcludedExecs | ノード毎の除外Executor一覧 | HashMap[String, HashSet[String]] |

### 更新テーブル一覧

該当なし（インメモリ管理。除外登録はexecutorIdToExcludedStatusへのput操作）

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| イベント配信失敗 | ListenerBusキュー溢れ | LiveListenerBusのドロップポリシーに従う |
| 設定不整合 | 除外関連設定値が不正 | HealthTracker初期化時にIllegalArgumentExceptionをスロー |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし（イベント発生時に即座に配信）

## セキュリティ考慮事項

- 本イベントはクラスタ内部の情報（Executor ID、タスク失敗数）のみを含み、個人情報は含まない
- LiveListenerBusはJVMプロセス内での配信であり、ネットワーク経由の送信は行わない
- イベントログに記録される場合は、イベントログのアクセス制御に従う

## 備考

- 本イベントは`@deprecated`アノテーション付きであり、Spark 3.1.0以降はSparkListenerExecutorExcludedを使用することが推奨される
- 後方互換性のため、HealthTrackerおよびTaskSetExcludelistでは両方のイベントが同時にpostされる
- SPARK-32037にて「blacklist」から「excludeOnFailure」への用語変更が行われた

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、イベントクラスの定義とそのフィールドを理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 128-132行目: SparkListenerExecutorBlacklistedのcase class定義。time, executorId, taskFailuresの3フィールドを持つ |
| 1-2 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | 136-140行目: 後継のSparkListenerExecutorExcludedの定義を比較確認 |

**読解のコツ**: `@deprecated`アノテーションの第1引数が代替クラス名、第2引数が非推奨化バージョンを示す。

#### Step 2: エントリーポイントを理解する

処理の起点となるHealthTrackerクラスを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 52-56行目: HealthTrackerクラスの定義とコンストラクタ。listenerBusを保持 |
| 2-2 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 264-315行目: updateExcludedForSuccessfulTaskSetメソッド。タスク失敗数の集計と閾値判定を行う |

**主要処理フロー**:
1. **284行目**: `newTotal >= MAX_FAILURES_PER_EXEC`で閾値判定
2. **290行目**: `listenerBus.post(SparkListenerExecutorBlacklisted(now, exec, newTotal))`でイベント発行
3. **291行目**: 同時にSparkListenerExecutorExcludedも発行

#### Step 3: フェッチ失敗時のフローを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | 220-262行目: updateExcludedForFetchFailureメソッド。フェッチ失敗時のExecutor除外処理 |

**主要処理フロー**:
- **253行目**: `listenerBus.post(SparkListenerExecutorBlacklisted(now, exec, 1))`でイベント発行（失敗数は1固定）

#### Step 4: イベント配信メカニズムを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | 66-71行目: doPostEvent内のパターンマッチでSparkListenerExecutorBlacklistedをonExecutorBlacklistedにルーティング |

### プログラム呼び出し階層図

```
TaskSchedulerImpl (タスク完了処理)
    |
    +-- HealthTracker.updateExcludedForSuccessfulTaskSet()
    |       |
    |       +-- ExecutorFailureList.addFailures()
    |       +-- ExecutorFailureList.numUniqueTaskFailures
    |       +-- listenerBus.post(SparkListenerExecutorBlacklisted)
    |       +-- listenerBus.post(SparkListenerExecutorExcluded)
    |
    +-- HealthTracker.updateExcludedForFetchFailure()
            |
            +-- listenerBus.post(SparkListenerExecutorBlacklisted)
            +-- listenerBus.post(SparkListenerExecutorExcluded)

LiveListenerBus
    |
    +-- SparkListenerBus.doPostEvent()
            |
            +-- listener.onExecutorBlacklisted()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

タスク失敗情報            HealthTracker                    SparkListenerExecutorBlacklisted
(exec, stageId,    --->  .updateExcludedFor...()   --->   イベント
 failureCount)           閾値判定・除外登録                  |
                                                           v
                                                    LiveListenerBus
                                                           |
                                                    +------+------+
                                                    |             |
                                              AppStatus     EventLogging
                                              Listener      Listener
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | イベントクラス定義・リスナーインターフェース |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ（パターンマッチ） |
| HealthTracker.scala | `core/src/main/scala/org/apache/spark/scheduler/HealthTracker.scala` | ソース | Executor除外ロジック・イベント発行元 |
| TaskSetExcludeList.scala | `core/src/main/scala/org/apache/spark/scheduler/TaskSetExcludeList.scala` | ソース | ステージレベルの除外管理（ステージレベルのBlacklistedForStageイベントを発行） |
| AppStatusListener.scala | `core/src/main/scala/org/apache/spark/status/AppStatusListener.scala` | ソース | UI向けイベント受信・状態管理 |
| EventLoggingListener.scala | `core/src/main/scala/org/apache/spark/scheduler/EventLoggingListener.scala` | ソース | イベントログへの永続化 |
