# 通知設計書 4-SparkListenerTaskGettingResult

## 概要

本ドキュメントは、Apache Sparkのコアイベント通知である`SparkListenerTaskGettingResult`の設計について記述する。このイベントは、タスクの結果をリモートフェッチ開始した際に発火するイベント通知である。

### 本通知の処理概要

SparkListenerTaskGettingResultは、Executorで実行されたタスクの結果データが大きく、ドライバがリモートからフェッチする必要がある場合に発火する特殊なイベントである。

**業務上の目的・背景**：タスク結果が`spark.driver.maxResultSize`の閾値を超える場合や、BlockManagerを経由してフェッチする必要がある場合に、フェッチ開始のタイミングをリスナーに通知する。これにより、Spark UIがタスクの「Getting Result」状態を表示でき、ユーザーはタスクが実行完了後に結果転送のフェーズに入ったことを確認できる。

**通知の送信タイミング**：DAGScheduler内の`handleGetTaskResult`メソッドで、TaskResultGetterがリモート結果フェッチを開始する際に発火する（DAGScheduler.scala L1346-1347）。結果がローカルに即座に取得できるタスク（小さな結果をインラインで返すタスク）では発火しない。

**通知の受信者**：SparkListenerInterfaceを実装し、LiveListenerBusに登録されたすべてのリスナーが受信する。

**通知内容の概要**：taskInfo（TaskInfo: タスクID、ステージID、Executor情報等）を含む。

**期待されるアクション**：受信したリスナーは、タスクの状態を「Getting Result」としてUIに反映する。

## 通知種別

アプリ内通知（Sparkイベントバス経由の非同期インプロセス通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

LiveListenerBusに登録された全リスナーに対してブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、Sparkイベントバス経由のインプロセス通知である。

### 本文テンプレート

```
イベントクラス: SparkListenerTaskGettingResult
シリアライズ形式: JSON（Jackson, @JsonTypeInfo）

{
  "Event": "org.apache.spark.scheduler.SparkListenerTaskGettingResult",
  "Task Info": { ... }
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | インプロセス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| taskInfo | タスク詳細情報 | TaskInfo | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューラ内部処理 | DAGScheduler.handleGetTaskResult | リモート結果フェッチ開始時 | DAGScheduler.scala L1346-1347 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| リモートフェッチ不要のタスク | 結果がインラインで返される小さなタスクでは発火しない |
| LiveListenerBus停止後 | イベントは配信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[タスク実行完了] --> B{結果サイズ確認}
    B -->|小さい: インライン結果| C[発火なし]
    B -->|大きい: リモートフェッチ必要| D[TaskResultGetter開始]
    D --> E[DAGScheduler.handleGetTaskResult]
    E --> F[SparkListenerTaskGettingResult生成]
    F --> G[listenerBus.post]
    G --> H[各リスナーのonTaskGettingResult呼び出し]
    H --> I[終了]
    C --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| KVStore | AppStatusListenerがタスク状態を更新 | UI表示用 |

### テーブル別参照項目詳細

#### KVStore

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| TaskDataWrapper | タスクの状態更新 | taskIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KVStore | UPDATE | タスク状態を「Getting Result」に更新 |
| イベントログファイル | APPEND | イベントをJSON記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | TaskDataWrapper.gettingResultTime | 現在時刻 | フェッチ開始時刻の記録 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キューオーバーフロー | イベント生成速度超過 | イベントドロップ |
| リスナー例外 | onTaskGettingResult内で例外 | 例外キャッチ、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| キュー容量 | デフォルト10,000イベント |

### 配信時間帯

時間帯制限なし。

## セキュリティ考慮事項

- TaskInfoにはexecutorId、host等のインフラ情報が含まれる

## 備考

- このイベントは全タスクで発火するわけではなく、リモートフェッチが必要なタスクでのみ発火する点に注意
- SparkListenerTaskGettingResultはtaskInfoのみの1フィールドケースクラスである（SparkListener.scala L44）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | L44: `case class SparkListenerTaskGettingResult(taskInfo: TaskInfo)`。taskInfoのみの1フィールド |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | L1346-1347: handleGetTaskResultメソッド。`listenerBus.post(SparkListenerTaskGettingResult(taskInfo))` |

**主要処理フロー**:
1. **L1346**: `handleGetTaskResult(taskInfo: TaskInfo)`メソッド定義
2. **L1347**: `listenerBus.post(SparkListenerTaskGettingResult(taskInfo))`でイベントをpost

#### Step 3: イベントディスパッチを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | L42-43: SparkListenerTaskGettingResultのパターンマッチ → listener.onTaskGettingResult()呼び出し |

### プログラム呼び出し階層図

```
TaskResultGetter (リモートフェッチ検出)
    |
    +-- DAGScheduler.handleGetTaskResult() [DAGScheduler.scala L1346]
            |
            +-- listenerBus.post(SparkListenerTaskGettingResult(taskInfo))
                    |
                    +-- LiveListenerBus.post()
                            |
                            +-- AsyncEventQueue.post() [各キュー]
                                    |
                                    +-- listener.onTaskGettingResult()
```

### データフロー図

```
[入力]                     [処理]                              [出力]

TaskResultGetter        LiveListenerBus                    各リスナー
(TaskInfo)             (AsyncEventQueue x N)

taskInfo ------------> SparkListenerTaskGettingResult ----> AppStatusListener
                                                           (KVStore更新)
                                                           EventLoggingListener
                                                           (イベントログ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | SparkListenerTaskGettingResultケースクラス定義 |
| DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | ソース | handleGetTaskResultからのイベント発火 |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ |
| LiveListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/LiveListenerBus.scala` | ソース | 非同期配信制御 |
