# 通知設計書 46-AlterDatabasePreEvent

## 概要

本ドキュメントは、Apache SparkのSQL外部カタログにおけるデータベース変更前イベント `AlterDatabasePreEvent` の通知設計を記載する。このイベントは外部カタログでデータベースの定義が変更される直前に発火され、リスナーに事前通知を提供する。

### 本通知の処理概要

`AlterDatabasePreEvent` は、`ExternalCatalogWithListener` を通じてデータベースの定義変更操作（ALTER DATABASE）が実行される直前に発火されるイベント通知である。データベースのプロパティ、説明文、場所URIなどの変更に対して、リスナーが事前に検知・対応する機会を提供する。

**業務上の目的・背景**：データベース定義の変更はデータガバナンスの観点で重要な操作である。変更前にイベントを発火することで、変更内容の事前検証、監査ログの記録、命名規則やプロパティルールの検証、変更承認ワークフローの実装などが可能になる。Pre/Postパターンにより、変更操作が失敗した場合にはPreEventのみが発火する。

**通知の送信タイミング**：`ExternalCatalogWithListener.alterDatabase()` メソッド内で、委譲先の `delegate.alterDatabase()` が呼び出される直前に `postToAll(AlterDatabasePreEvent(db))` により発火される。

**通知の受信者**：`ExternalCatalogEventListener` インタフェースを実装し、`ExternalCatalogWithListener` にリスナーとして登録されたすべてのオブジェクトが受信する。

**通知内容の概要**：変更対象のデータベース名（`database: String`）を含む。`DatabaseEvent` トレイトを継承する。なお、変更内容の詳細（新しいプロパティや説明文など）はイベントに含まれない。

**期待されるアクション**：受信したリスナーは、変更前のデータベース定義のスナップショット取得、監査ログの記録、変更内容の事前バリデーション、依存システムへの事前通知などを実行する。

## 通知種別

アプリ内イベント通知（Spark ListenerBus経由のインプロセス同期通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll経由） |
| 優先度 | 高（操作実行前のため） |
| リトライ | 無（同期呼び出しのため） |

### 送信先決定ロジック

`ExternalCatalogWithListener` に登録された全ての `ExternalCatalogEventListener` に対して、`postToAll` により同期的にブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本通知はインプロセスイベント通知であるため、メールテンプレートは該当しない。

### 本文テンプレート

```
AlterDatabasePreEvent(
  database: String  // 変更対象のデータベース名
)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 変更対象のデータベース名 | CatalogDatabase.name (dbDefinition.name) | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterDatabase() | 常に発火 | delegate.alterDatabase()呼び出しの直前に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | alterDatabase()が呼び出されれば常にPreEventは発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ExternalCatalogWithListener.alterDatabase呼び出し] --> B[dbDefinition.nameからデータベース名取得]
    B --> C[postToAll - AlterDatabasePreEvent発火]
    C --> D[全リスナーのonEventを同期呼び出し]
    D --> E[delegate.alterDatabase実行]
    E --> F{変更成功?}
    F -->|成功| G[postToAll - AlterDatabaseEvent発火]
    F -->|失敗 - 例外| H[AlterDatabaseEventは発火しない]
    G --> I[終了]
    H --> I
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| CatalogDatabase | 変更対象データベース定義の参照 | name, description, locationUri, propertiesを含む |

### テーブル別参照項目詳細

#### CatalogDatabase

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| name | イベントのdatabaseフィールドに設定 | alterDatabaseメソッドの引数から取得 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | PreEventの発火時点ではデータ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| 該当なし | - | - | イベント発火のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外がスローされた場合 | ListenerBusがキャッチしログに記録 |
| PreEvent発火後の操作失敗 | delegate.alterDatabase()が例外をスロー | PreEventは発火済みだがPostEventは発火しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

本イベントはインプロセスで配信されるため、外部ネットワーク通信は発生しない。データベース名のみを含むため機密情報漏洩リスクは低い。変更内容の詳細はイベントに含まれないため、リスナー側で変更前後の差分を確認するには別途カタログAPIを呼び出す必要がある。

## 備考

- `AlterDatabasePreEvent` は `AlterDatabaseEvent` と対になるPreイベントである
- 変更内容の詳細（新しいプロパティ等）はイベントに含まれない。データベース名のみ通知される
- テストスイート `ExternalCatalogEventSuite`（75-77行目）で発火パターンが検証されている
- alterDatabaseメソッドの引数 `dbDefinition: CatalogDatabase` から `name` フィールドを抽出して使用する

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | `AlterDatabasePreEvent` ケースクラス（68行目）。`DatabaseEvent` トレイトからの継承 |

**読解のコツ**: AlterDatabase系イベントはCreateDatabase系やDropDatabase系と同じ `DatabaseEvent` トレイトを継承し、`database: String` フィールドのみを含む。変更種別やALTER内容はイベントに含まれない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | `alterDatabase` メソッド（57-62行目）。dbDefinition.nameからDB名を抽出し、Pre/Postイベントを発火 |

**主要処理フロー**:
1. **58行目**: `val db = dbDefinition.name` でデータベース名を取得
2. **59行目**: `postToAll(AlterDatabasePreEvent(db))` - Preイベント発火
3. **60行目**: `delegate.alterDatabase(dbDefinition)` - 実際の変更操作を委譲
4. **61行目**: `postToAll(AlterDatabaseEvent(db))` - Postイベント発火（成功時のみ到達）

#### Step 3: テストケースで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | databaseテストケース（75-77行目）。ALTERの成功時にPre+Post発火を確認 |

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.alterDatabase() [ExternalCatalogWithListener.scala:57]
    |
    +-- postToAll(AlterDatabasePreEvent(db)) [59行目] ← 本イベント
    |       |
    |       +-- doPostEvent() [34行目]
    |               |
    |               +-- ExternalCatalogEventListener.onEvent()
    |
    +-- delegate.alterDatabase(dbDefinition) [60行目]
    |
    +-- postToAll(AlterDatabaseEvent(db)) [61行目]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

CatalogDatabase -------> ExternalCatalogWithListener -------> AlterDatabasePreEvent
  (dbDefinition)              .alterDatabase()                      |
                                    |                               v
                                    |                    ExternalCatalogEventListener
                                    v                          .onEvent()
                              delegate.alterDatabase()
                                    |
                                    v
                            AlterDatabaseEvent (成功時のみ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterDatabasePreEventイベントクラスの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火のラッパークラス |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | イベント発火パターンのテスト |
