# 通知設計書 5-SparkListenerSpeculativeTaskSubmitted

## 概要

本ドキュメントは、Apache Sparkのコアイベント通知である`SparkListenerSpeculativeTaskSubmitted`の設計について記述する。このイベントは、投機的タスク（speculative task）が送信された際に発火するイベント通知である。

### 本通知の処理概要

SparkListenerSpeculativeTaskSubmittedは、Sparkの投機的実行（speculative execution）機能において、遅延タスクの代替として新しいタスクが投入されたことをリスナーに通知するイベントである。

**業務上の目的・背景**：投機的実行は、クラスタ内の一部のノードが遅い（ストラグラー問題）場合に、同じタスクの別コピーを別のExecutorで実行することでジョブ全体の完了時間を短縮する機能である。このイベントにより、投機的タスクの発生を追跡でき、クラスタのパフォーマンス問題の診断や動的リソース割り当てのスケーリング判断に活用される。ExecutorAllocationManagerはこのイベントを受信して、投機的タスク分の追加Executorを要求する。

**通知の送信タイミング**：DAGScheduler内の`handleSpeculativeTaskSubmitted`メソッドで、TaskSetManagerが投機的タスクの送信を決定した際に発火する（DAGScheduler.scala L1296-1299）。

**通知の受信者**：SparkListenerInterfaceを実装し、LiveListenerBusに登録されたすべてのリスナーが受信する。特にExecutorAllocationManagerが重要な受信者である。

**通知内容の概要**：stageId、stageAttemptId、taskIndex、partitionIdを含む。後方互換性のため、taskIndexとpartitionIdはプライベートフィールドとして実装されている。

**期待されるアクション**：ExecutorAllocationManagerは投機的タスクの実行に必要な追加Executorを算出し、リソースマネージャに要求する。Spark UIは投機的タスクの情報を表示する。

## 通知種別

アプリ内通知（Sparkイベントバス経由の非同期インプロセス通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 非同期（LiveListenerBus経由） |
| 優先度 | 中 |
| リトライ | 無し |

### 送信先決定ロジック

LiveListenerBusに登録された全リスナーに対してブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本イベントはメール通知ではなく、Sparkイベントバス経由のインプロセス通知である。

### 本文テンプレート

```
イベントクラス: SparkListenerSpeculativeTaskSubmitted
シリアライズ形式: JSON（Jackson, @JsonTypeInfo）

{
  "Event": "org.apache.spark.scheduler.SparkListenerSpeculativeTaskSubmitted",
  "Stage ID": <int>,
  "Stage Attempt ID": <int>,
  "Task Index": <int>,
  "Partition ID": <int>
}
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| 該当なし | - | - | インプロセス通知のため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| stageId | ステージID | task.stageId | Yes |
| stageAttemptId | ステージアテンプト番号 | task.stageAttemptId | Yes（デフォルト0） |
| taskIndex | タスクインデックス | taskIndex引数 | Yes（内部フィールド、デフォルト-1） |
| partitionId | パーティションID | task.partitionId | Yes（内部フィールド、デフォルト-1） |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| スケジューラ内部処理 | DAGScheduler.handleSpeculativeTaskSubmitted | 投機的タスク送信時 | DAGScheduler.scala L1296-1299 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 投機的実行無効 | `spark.speculation`がfalseの場合、投機的タスク自体が生成されないため発火しない |
| LiveListenerBus停止後 | イベントは配信されない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[TaskSetManagerがストラグラー検出] --> B[投機的タスク生成]
    B --> C[DAGScheduler.handleSpeculativeTaskSubmitted]
    C --> D[SparkListenerSpeculativeTaskSubmitted生成]
    D --> E[listenerBus.post]
    E --> F[各リスナーのonSpeculativeTaskSubmitted呼び出し]
    F --> G[終了]
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| KVStore | AppStatusListenerが投機的タスク情報を格納 | UI表示用 |

### テーブル別参照項目詳細

#### KVStore

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| SpeculationStageSummaryWrapper | ステージの投機的実行サマリ | stageIdで検索 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| KVStore | INSERT/UPDATE | 投機的タスク情報の記録 |
| イベントログファイル | APPEND | イベントをJSON記録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| UPDATE | SpeculationStageSummary | 投機的タスク数+1 | AppStatusListenerによる更新 |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| キューオーバーフロー | イベント生成速度超過 | イベントドロップ |
| リスナー例外 | onSpeculativeTaskSubmitted内で例外 | 例外キャッチ、ログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0 |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| キュー容量 | デフォルト10,000イベント |

### 配信時間帯

時間帯制限なし。

## セキュリティ考慮事項

- ステージIDやパーティションIDなどの内部実行情報が含まれるが、機密情報は含まない

## 備考

- 後方互換性のため、`taskIndex`と`partitionId`はケースクラスのコンストラクタ引数ではなく、プライベートフィールド（`_taskIndex`、`_partitionId`）として実装されている（SparkListener.scala L51-57）
- 補助コンストラクタ `this(stageId, stageAttemptId, taskIndex, partitionId)` で4引数を渡してインスタンスを生成する（SparkListener.scala L59-63）
- DAGSchedulerからは常に4引数の補助コンストラクタ（`new SparkListenerSpeculativeTaskSubmitted(...)`) で生成される
- stageAttemptIdのデフォルト値は0

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | L47-64: SparkListenerSpeculativeTaskSubmittedケースクラス。主コンストラクタはstageId, stageAttemptIdの2引数。L53-54: `_taskIndex`と`_partitionId`のプライベートvarフィールド。L59-63: 4引数の補助コンストラクタ |

**読解のコツ**: このクラスは後方互換性を維持するために特殊な設計になっている。Jacksonでデシリアライズする際にtaskIndexが存在しない旧バージョンのJSONにも対応するため、ケースクラスのフィールドとしてではなくプライベートvarとして定義されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | L1296-1299: handleSpeculativeTaskSubmitted。`new SparkListenerSpeculativeTaskSubmitted(task.stageId, task.stageAttemptId, taskIndex, task.partitionId)`で4引数の補助コンストラクタを使用 |

**主要処理フロー**:
1. **L1296**: `handleSpeculativeTaskSubmitted(task: Task[_], taskIndex: Int)`メソッド
2. **L1297-1298**: `new SparkListenerSpeculativeTaskSubmitted`で4引数コンストラクタでインスタンス生成
3. **L1299**: `listenerBus.post(speculativeTaskSubmittedEvent)`でイベントをpost

#### Step 3: リスナー側の処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExecutorAllocationManager.scala | `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` | L829-832: onSpeculativeTaskSubmittedハンドラ。投機的タスクの追加によるExecutor要求数の再計算 |

### プログラム呼び出し階層図

```
TaskSetManager (ストラグラー検出・投機的タスク決定)
    |
    +-- DAGScheduler.handleSpeculativeTaskSubmitted() [DAGScheduler.scala L1296]
            |
            +-- listenerBus.post(new SparkListenerSpeculativeTaskSubmitted(...))
                    |
                    +-- LiveListenerBus.post()
                            |
                            +-- AsyncEventQueue.post() [各キュー]
                                    |
                                    +-- listener.onSpeculativeTaskSubmitted()
                                            |
                                            +-- ExecutorAllocationManager.onSpeculativeTaskSubmitted()
                                            +-- AppStatusListener (投機的タスク記録)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

TaskSetManager             LiveListenerBus                    各リスナー
(Task, taskIndex)         (AsyncEventQueue x N)

stageId, stageAttemptId                                       ExecutorAllocationManager
taskIndex, partitionId --> SparkListenerSpeculativeTask -----> (Executor追加要求)
                           Submitted                          AppStatusListener
                                                              (KVStore更新)
                                                              EventLoggingListener
                                                              (イベントログ)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SparkListener.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListener.scala` | ソース | SparkListenerSpeculativeTaskSubmittedケースクラス定義 |
| DAGScheduler.scala | `core/src/main/scala/org/apache/spark/scheduler/DAGScheduler.scala` | ソース | handleSpeculativeTaskSubmittedからのイベント発火 |
| ExecutorAllocationManager.scala | `core/src/main/scala/org/apache/spark/ExecutorAllocationManager.scala` | ソース | 投機的タスクに基づくExecutorスケーリング |
| SparkListenerBus.scala | `core/src/main/scala/org/apache/spark/scheduler/SparkListenerBus.scala` | ソース | イベントディスパッチ（L92-93） |
| BasicEventFilterBuilder.scala | `core/src/main/scala/org/apache/spark/deploy/history/BasicEventFilterBuilder.scala` | ソース | 履歴サーバーでのイベントフィルタリング（L131-132） |
