# 通知設計書 50-DropTablePreEvent

## 概要

本ドキュメントは、Apache SparkのSQL外部カタログにおけるテーブル削除前イベント `DropTablePreEvent` の通知設計を記載する。このイベントは外部カタログでテーブルが削除される直前に発火され、リスナーに事前通知を提供する。

### 本通知の処理概要

`DropTablePreEvent` は、`ExternalCatalogWithListener` を通じてテーブルの削除操作が実行される直前に発火されるイベント通知である。テーブル削除という破壊的操作に対して、リスナーが事前に検知・対応する機会を提供する。

**業務上の目的・背景**：テーブルの削除はデータパイプラインに対する重大な変更操作であり、関連するパーティション、統計情報、依存するビューやETLジョブなどに影響を及ぼす。削除前にイベントを発火することで、依存オブジェクトの確認、データのバックアップ、監査ログの記録、削除の承認プロセスの実装、外部システムへの事前通知など、削除前の対策を可能にする。Pre/Postパターンにより、削除操作が失敗した場合（存在しないテーブルの削除等）にはPreEventのみが発火しPostEventは発火しない。

**通知の送信タイミング**：`ExternalCatalogWithListener.dropTable()` メソッド内で、委譲先の `delegate.dropTable()` が呼び出される直前に `postToAll(DropTablePreEvent(db, table))` により発火される。

**通知の受信者**：`ExternalCatalogEventListener` インタフェースを実装し、`ExternalCatalogWithListener` にリスナーとして登録されたすべてのオブジェクトが受信する。

**通知内容の概要**：テーブルが属するデータベース名（`database: String`）とテーブル名（`name: String`）を含む。`TableEvent` トレイトを継承し、`DatabaseEvent` -> `ExternalCatalogEvent` -> `SparkListenerEvent` の階層を持つ。削除オプション（`ignoreIfNotExists`, `purge`）はイベントに含まれない。

**期待されるアクション**：受信したリスナーは、削除対象テーブルの依存関係確認、データのバックアップトリガー、監査ログの記録、外部データカタログへの事前通知、下流ETLジョブへの警告などを実行する。

## 通知種別

アプリ内イベント通知（Spark ListenerBus経由のインプロセス同期通知）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（ListenerBus.postToAll経由） |
| 優先度 | 高（破壊的操作の事前通知） |
| リトライ | 無（同期呼び出しのため） |

### 送信先決定ロジック

`ExternalCatalogWithListener` に登録された全ての `ExternalCatalogEventListener` に対して、`postToAll` により同期的にブロードキャスト配信される。

## 通知テンプレート

### メール通知の場合

本通知はインプロセスイベント通知であるため、メールテンプレートは該当しない。

### 本文テンプレート

```
DropTablePreEvent(
  database: String,  // テーブルが属するデータベース名
  name: String       // 削除対象のテーブル名
)
```

### 添付ファイル

該当なし

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | テーブルが属するデータベース名 | dropTableメソッドのdb引数 | Yes |
| name | 削除対象のテーブル名 | dropTableメソッドのtable引数 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.dropTable() | 常に発火（ignoreIfNotExistsの値に関係なく） | delegate.dropTable()呼び出しの直前に発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | dropTable()が呼び出されれば常にPreEventは発火する |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[ExternalCatalogWithListener.dropTable呼び出し] --> B[postToAll - DropTablePreEvent発火]
    B --> C[全リスナーのonEventを同期呼び出し]
    C --> D[delegate.dropTable実行]
    D --> E{削除成功?}
    E -->|成功| F[postToAll - DropTableEvent発火]
    E -->|失敗 - 例外| G[DropTableEventは発火しない]
    F --> H[終了]
    G --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| 該当なし | - | PreEventの発火にはデータ参照不要。メソッド引数から直接取得 |

### テーブル別参照項目詳細

該当なし。dropTableメソッドのdb引数およびtable引数から直接取得する。

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| 該当なし | - | PreEventの発火時点ではデータ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| 該当なし | - | - | イベント発火のみ |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外がスローされた場合 | ListenerBusがキャッチしログに記録 |
| PreEvent発火後の操作失敗 | delegate.dropTable()が例外をスロー（存在しないテーブル等） | PreEventは発火済みだがPostEventは発火しない |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。テーブル削除操作時に随時発火される。

## セキュリティ考慮事項

本イベントはインプロセスで配信されるため、外部ネットワーク通信は発生しない。データベース名とテーブル名のみを含むため、直接的な機密情報の漏洩リスクは低い。テーブル削除は破壊的操作であるため、カスタムリスナーによる監査ログ記録やアラート通知の実装が推奨される。purgeオプション（ゴミ箱バイパス）の有無はイベントに含まれないため、リスナー側で把握できない点に注意。

## 備考

- `DropTablePreEvent` は `DropTableEvent` と対になるPreイベントである
- `TableEvent` トレイトを継承し、`database` と `name` の2フィールドを持つ
- `dropTable` メソッドの引数には `ignoreIfNotExists` と `purge` が含まれるが、いずれもイベントには含まれない
- テストスイート `ExternalCatalogEventSuite`（152-161行目）で発火パターンが検証されている
- 存在しないテーブル削除時（ignoreIfNotExists=false）はPreEventのみ発火（154-155行目）
- 正常削除時はPre+Post両方が発火（157-158行目）
- `ignoreIfNotExists = true` で存在しないテーブルでもPre/Post両方が発火（160-161行目）

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | `DropTablePreEvent` ケースクラス（98行目）。`TableEvent` トレイト（78-83行目）からの継承。database, nameの2フィールドを持つ |

**読解のコツ**: `DropTablePreEvent` は `TableEvent` を継承し、Create系やAlter系のテーブルイベントと同じインタフェースを持つ。テーブルイベントはデータベースイベントを拡張し、テーブル名（name）フィールドを追加した構造。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | `dropTable` メソッド（98-106行目）。db, table, ignoreIfNotExists, purgeの4引数を受け取り、Pre/Postイベントを発火 |

**主要処理フロー**:
1. **103行目**: `postToAll(DropTablePreEvent(db, table))` - Preイベント発火
2. **104行目**: `delegate.dropTable(db, table, ignoreIfNotExists, purge)` - 実際の削除操作を委譲
3. **105行目**: `postToAll(DropTableEvent(db, table))` - Postイベント発火（成功時のみ到達）

#### Step 3: テストケースで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | tableテストケース（152-161行目）。存在しないテーブル削除時のPreのみ発火、正常削除時のPre+Post発火パターン |

**主要処理フロー**:
- **154-155行目**: 存在しないテーブル削除（ignoreIfNotExists=false） `DropTablePreEvent("db5", "tbl1") :: Nil`
- **157-158行目**: 正常削除 `DropTablePreEvent("db5", "tbl2") :: DropTableEvent("db5", "tbl2") :: Nil`
- **160-161行目**: 存在しないテーブル削除（ignoreIfNotExists=true） `DropTablePreEvent("db5", "tbl2") :: DropTableEvent("db5", "tbl2") :: Nil`

### プログラム呼び出し階層図

```
ExternalCatalogWithListener.dropTable() [ExternalCatalogWithListener.scala:98]
    |
    +-- postToAll(DropTablePreEvent(db, table)) [103行目] ← 本イベント
    |       |
    |       +-- doPostEvent() [34行目]
    |               |
    |               +-- ExternalCatalogEventListener.onEvent()
    |
    +-- delegate.dropTable(db, table, ignoreIfNotExists, purge) [104行目]
    |
    +-- postToAll(DropTableEvent(db, table)) [105行目]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

db: String ------------> ExternalCatalogWithListener -------> DropTablePreEvent
table: String                  .dropTable()                    (database, name)
ignoreIfNotExists                   |                               |
purge                               |                               v
                                    |                    ExternalCatalogEventListener
                                    v                          .onEvent()
                              delegate.dropTable()
                                    |
                                    v
                            DropTableEvent (成功時のみ)
                              (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | DropTablePreEventイベントクラスおよびTableEventトレイトの定義 |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火のラッパークラス |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | イベント発火パターンのテスト |
