# 通知設計書 52-RenameTablePreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいてテーブルのリネーム操作が実行される前に発火するイベント通知「RenameTablePreEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、テーブルリネーム操作の開始を外部リスナーに事前通知するために使用される。

### 本通知の処理概要

RenameTablePreEventは、外部カタログ（ExternalCatalog）上でテーブルのリネーム操作が実行される直前に発火するイベント通知である。ExternalCatalogWithListenerクラスのrenameTableメソッド内で、デリゲート先の実処理を呼び出す前にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：テーブルのリネーム操作はメタデータの変更を伴う重要な操作であり、リネーム前に依存関係のチェック、バリデーション、監査ログの事前記録などの前処理を実行する必要がある。RenameTablePreEventはリネーム操作の事前通知として、これらの前処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.renameTableメソッドにおいて、デリゲート先のExternalCatalog.renameTableを呼び出す前（行109）にpostToAllメソッドで発火される。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：リネーム対象テーブルが属するデータベース名（database）、現在のテーブル名（name）、新しいテーブル名（newName）の3つのフィールドを含む。

**期待されるアクション**：受信リスナーはテーブルリネーム操作の開始を検知し、依存テーブルの確認、ビューの整合性チェック、キャッシュの準備的無効化などの前処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録され、Spark全体のリスナーバスにも伝播する。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
RenameTablePreEvent(database: String, name: String, newName: String)

例：RenameTablePreEvent("default", "old_table", "new_table")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | テーブルが属するデータベース名 | ExternalCatalogWithListener.renameTableの引数db | Yes |
| name | リネーム前のテーブル名 | ExternalCatalogWithListener.renameTableの引数oldName | Yes |
| newName | リネーム後のテーブル名 | ExternalCatalogWithListener.renameTableの引数newName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.renameTable() | renameTableメソッドが呼び出されること | 行109でデリゲート処理の前にpostToAllされる |
| API呼び出し | ALTER TABLE RENAME SQL文の実行 | SQLパーサー経由でrenameTableが呼ばれること | SparkSQL経由でもrenameTable APIを通じて発火する |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventはデリゲート処理前に無条件で発火される。後続のデリゲート処理が失敗してもPreEventは既に発火済み |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[renameTable呼び出し] --> B[RenameTablePreEvent発火]
    B --> C[delegate.renameTable実行]
    C -->|成功| D[RenameTableEvent発火]
    C -->|例外| E[例外スロー - RenameTableEventは未発火]
    D --> F[終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアのテーブルメタデータ | リネーム対象テーブルの存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストアテーブルメタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | テーブル所属DB確認 | 引数dbで指定 |
| table_name | テーブル存在確認 | 引数oldNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの発火時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力。他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。renameTable APIが呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

- イベントにはデータベース名、現テーブル名、新テーブル名のみが含まれ、テーブルデータ自体は含まれないため、機密データの漏洩リスクは限定的である。
- SparkListenerBusに登録された全てのリスナーに配信されるため、リスナー登録のアクセス制御に留意する。

## 備考

- RenameTablePreEventはテーブルリネームの「前」イベント（pre-event）であり、対応する「後」イベントとしてRenameTableEvent（No.53）が存在する。
- PreEventはデリゲート処理の成否に関わらず常に発火される。テストコード ExternalCatalogEventSuite.scala 行146-149で、リネーム失敗時にPreEventのみが発火することが確認されている。
- newNameフィールドにより、リネーム先の名前も事前に把握できる。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行108-112: RenameTablePreEventケースクラスの定義。database, name, newNameの3フィールドを持つ。TableEventトレイトを継承 |

**読解のコツ**: RenameTablePreEventはTableEventを継承するが、newNameフィールドはTableEventトレイトには定義されておらず、RenameTablePreEvent固有のフィールドである。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行108-112: renameTableメソッド。Pre/Postイベントの発火パターン |

**主要処理フロー**:
1. **行109**: `postToAll(RenameTablePreEvent(db, oldName, newName))` でPreイベントを発火
2. **行110**: `delegate.renameTable(db, oldName, newName)` でデリゲート先の実処理を実行
3. **行111**: `postToAll(RenameTableEvent(db, oldName, newName))` でPostイベントを発火

#### Step 3: イベント配信基盤を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | 行37: ListenerBusトレイト定義、行67-69: addListenerメソッド |

#### Step 4: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行141-149: テーブルリネームテスト。正常時はPre+Postの2イベント発火、失敗時はPreのみ |

### プログラム呼び出し階層図

```
SparkSession (SQL: ALTER TABLE ... RENAME TO ...)
    |
    +-- SessionCatalog.renameTable()
           |
           +-- ExternalCatalogWithListener.renameTable()  [行108-112]
                  |
                  +-- postToAll(RenameTablePreEvent)       [行109]
                  |      |
                  |      +-- ExternalCatalogEventListener.onEvent()
                  |      +-- SparkContext.listenerBus.post()
                  |
                  +-- delegate.renameTable()               [行110]
                  |
                  +-- postToAll(RenameTableEvent)          [行111]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

renameTable(db, oldName, --> ExternalCatalogWithListener     --> RenameTablePreEvent
 newName)                        .renameTable()                   (database, name, newName)
                                 |                                    |
                                 v                                    v
                           delegate.renameTable()             --> RenameTableEvent
                           (実際のメタストア操作)                  (database, name, newName)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | RenameTablePreEventの定義（行108-112） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火を伴うカタログ操作のラッパー（行108-112） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログのインタフェース定義 |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | ExternalCatalogWithListenerの初期化 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | RenameTablePreEventの発火テスト（行141-149） |
