# 通知設計書 53-RenameTableEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいてテーブルのリネーム操作が完了した後に発火するイベント通知「RenameTableEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、テーブルリネーム操作の完了を外部リスナーに通知するために使用される。

### 本通知の処理概要

RenameTableEventは、外部カタログ（ExternalCatalog）上でテーブルのリネーム操作が正常に完了した直後に発火するイベント通知である。ExternalCatalogWithListenerクラスのrenameTableメソッド内で、デリゲート先の実処理が成功した後にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：テーブルリネームが完了した際に、キャッシュの無効化、UIの表示更新、依存ビューやジョブの参照先更新、監査ログの記録などの後続処理を実行する必要がある。RenameTableEventはこれらの後続処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.renameTableメソッドにおいて、デリゲート先のExternalCatalog.renameTableが正常に完了した直後（行111）にpostToAllメソッドで発火される。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：リネーム対象テーブルが属するデータベース名（database）、リネーム前のテーブル名（name）、リネーム後のテーブル名（newName）の3つのフィールドを含む。

**期待されるアクション**：受信リスナーはテーブルリネーム操作の完了を検知し、関連するキャッシュの更新、テーブル参照の変更、メタデータの更新、UIの表示更新などの後続処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
RenameTableEvent(database: String, name: String, newName: String)

例：RenameTableEvent("default", "old_table", "new_table")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | テーブルが属するデータベース名 | ExternalCatalogWithListener.renameTableの引数db | Yes |
| name | リネーム前のテーブル名 | ExternalCatalogWithListener.renameTableの引数oldName | Yes |
| newName | リネーム後のテーブル名 | ExternalCatalogWithListener.renameTableの引数newName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.renameTable() | デリゲート先のrenameTableが例外なく完了すること | 行110でdelegate.renameTableが成功した後、行111でpostToAllされる |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| テーブルが存在しない場合 | delegate.renameTableが例外をスローし、RenameTableEventは発火しない（RenameTablePreEventのみ発火） |
| デリゲート処理で例外発生 | delegate.renameTableが何らかの例外をスローした場合、PostイベントであるRenameTableEventは発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[renameTable呼び出し] --> B[RenameTablePreEvent発火]
    B --> C[delegate.renameTable実行]
    C -->|成功| D[RenameTableEvent発火]
    C -->|例外| E[例外スロー - RenameTableEventは未発火]
    D --> F[postToAllで全リスナーに配信]
    F --> G[SparkListenerBusへ伝播]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアのテーブルメタデータ | リネーム対象テーブルの存在確認 | Hiveメタストアまたはインメモリカタログ |

### テーブル別参照項目詳細

#### メタストアテーブルメタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | テーブル所属DB確認 | 引数dbで指定 |
| table_name | テーブル存在確認 | 引数oldNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| メタストアのテーブルメタデータ | UPDATE | デリゲート先のExternalCatalog実装がテーブル名を更新 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| テーブル不存在エラー | リネーム元テーブルが存在しない場合 | RenameTablePreEventのみ発火し、RenameTableEventは発火しない |
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力。他のリスナーへの配信は継続される |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。renameTable APIが呼び出されたタイミングで即座に配信される。

## セキュリティ考慮事項

- イベントにはデータベース名、旧テーブル名、新テーブル名のみが含まれ、テーブルデータ自体は含まれないため、機密データの漏洩リスクは限定的である。

## 備考

- RenameTableEventはテーブルリネームの「後」イベント（post-event）であり、対応する「前」イベントとしてRenameTablePreEvent（No.52）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行141-144で、正常時にPre/Post両方のイベントが発火することが確認されている。
- テストコード 行146-149で、リネーム失敗時（テーブル不存在）にPreEventのみ発火することが確認されている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行117-121: RenameTableEventケースクラスの定義。database, name, newNameの3フィールドを持つ |

**読解のコツ**: RenameTableEventとRenameTablePreEventは同じフィールド構成を持つが、発火タイミングが異なる（Pre=操作前、Post=操作後）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行108-112: renameTableメソッド。行111がRenameTableEventの発火箇所 |

**主要処理フロー**:
1. **行109**: `postToAll(RenameTablePreEvent(db, oldName, newName))` でPreイベント発火
2. **行110**: `delegate.renameTable(db, oldName, newName)` でデリゲート先の実処理
3. **行111**: `postToAll(RenameTableEvent(db, oldName, newName))` でPostイベント（本イベント）発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行141-149: リネームの正常系・異常系テスト |

### プログラム呼び出し階層図

```
SparkSession (SQL: ALTER TABLE ... RENAME TO ...)
    |
    +-- SessionCatalog.renameTable()
           |
           +-- ExternalCatalogWithListener.renameTable()  [行108-112]
                  |
                  +-- postToAll(RenameTablePreEvent)       [行109]
                  +-- delegate.renameTable()               [行110]
                  +-- postToAll(RenameTableEvent)          [行111]
                         |
                         +-- ExternalCatalogEventListener.onEvent()
                         +-- SparkContext.listenerBus.post()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

renameTable(db, oldName, --> ExternalCatalogWithListener     --> RenameTablePreEvent
 newName)                        .renameTable()                   (database, name, newName)
                                 |                                    |
                                 v                                    v
                           delegate.renameTable()             --> RenameTableEvent
                           (テーブル名更新)                        (database, name, newName)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | RenameTableEventの定義（行117-121） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | イベント発火ラッパー（行108-112） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | リネームイベントの発火テスト（行141-149） |
