# 通知設計書 54-AlterTablePreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいてテーブルの変更操作が実行される前に発火するイベント通知「AlterTablePreEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、テーブル変更操作の開始を外部リスナーに事前通知するために使用される。

### 本通知の処理概要

AlterTablePreEventは、外部カタログ（ExternalCatalog）上でテーブルの変更操作が実行される直前に発火するイベント通知である。テーブル定義全体の変更、データスキーマの変更、スキーマの変更、統計情報の変更の4種類の操作でそれぞれ異なるkind値を伴って発火される。ExternalCatalogWithListenerクラスの各alterTableメソッド内で、デリゲート先の実処理を呼び出す前にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：テーブルの変更操作はスキーマ変更、統計情報更新、テーブルプロパティ変更など多岐にわたり、それぞれの操作種別に応じた事前処理（バリデーション、依存関係チェック、監査ログの事前記録）が必要となる。AlterTablePreEventはkindフィールドにより変更種別を識別できるため、種別に応じた前処理を実行できる。

**通知の送信タイミング**：ExternalCatalogWithListenerの以下4つのメソッドでデリゲート処理前に発火される。(1) alterTable（行117、kind="table"）、(2) alterTableDataSchema（行123、kind="dataSchema"）、(3) alterTableSchema（行129、kind="schema"）、(4) alterTableStats（行138、kind="stats"）。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：変更対象テーブルが属するデータベース名（database）、テーブル名（name）、変更種別（kind）の3つのフィールドを含む。kindの値はAlterTableKind列挙型で定義されている。

**期待されるアクション**：受信リスナーはテーブル変更操作の種別をkindフィールドで判別し、適切な前処理を実行する。例えばスキーマ変更時はキャッシュの事前無効化を検討し、統計情報更新時は最適化プランの再評価準備を行う。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
AlterTablePreEvent(database: String, name: String, kind: String)

例：AlterTablePreEvent("default", "my_table", "table")
    AlterTablePreEvent("default", "my_table", "dataSchema")
    AlterTablePreEvent("default", "my_table", "schema")
    AlterTablePreEvent("default", "my_table", "stats")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | テーブルが属するデータベース名 | 各alterTableメソッドの引数から取得 | Yes |
| name | 変更対象のテーブル名 | 各alterTableメソッドの引数から取得 | Yes |
| kind | 変更種別（"table", "dataSchema", "schema", "stats"のいずれか） | AlterTableKind列挙型の値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterTable() | メソッド呼び出し | 行117でkind="table"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableDataSchema() | メソッド呼び出し | 行123でkind="dataSchema"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableSchema() | メソッド呼び出し | 行129でkind="schema"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableStats() | メソッド呼び出し | 行138でkind="stats"としてpostToAll |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventはデリゲート処理前に無条件で発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[alterTable系メソッド呼び出し] --> B[AlterTablePreEvent発火 - kindに応じた値]
    B --> C[delegate.alterTable系メソッド実行]
    C -->|成功| D[AlterTableEvent発火]
    C -->|例外| E[例外スロー - AlterTableEventは未発火]
    D --> F[終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアのテーブルメタデータ | 変更対象テーブルの存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストアテーブルメタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | テーブル所属DB確認 | 引数で指定 |
| table_name | テーブル存在確認 | 引数で指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの発火時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名、テーブル名、変更種別のみが含まれ、変更内容の詳細（新スキーマ、新統計情報等）は含まれないため、機密データの漏洩リスクは限定的である。

## 備考

- AlterTablePreEventはテーブル変更の「前」イベント（pre-event）であり、対応する「後」イベントとしてAlterTableEvent（No.55）が存在する。
- AlterTableKindオブジェクト（events.scala 行127-132）で定義された4つの値（TABLE, DATASCHEMA, SCHEMA, STATS）がkindフィールドの有効値である。
- テストコード ExternalCatalogEventSuite.scala 行123-138で、alterTable、alterTableSchema、alterTableStatsの各操作で適切なkind値のイベントが発火することが確認されている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行127-132: AlterTableKindオブジェクト（TABLE, DATASCHEMA, SCHEMA, STATSの定義）、行137-140: AlterTablePreEventケースクラス（database, name, kindの3フィールド） |

**読解のコツ**: AlterTableKindはEnumerationではなくobjectの定数として定義されている（val TABLE = "table"のようにString型）。kindフィールドはString型であり、型安全性はないため注意が必要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行114-141: 4つのalterTable系メソッド（alterTable, alterTableDataSchema, alterTableSchema, alterTableStats） |

**主要処理フロー**:
1. **行117**: `postToAll(AlterTablePreEvent(db, name, AlterTableKind.TABLE))` - alterTableでのPreイベント発火
2. **行123**: `postToAll(AlterTablePreEvent(db, table, AlterTableKind.DATASCHEMA))` - alterTableDataSchemaでのPreイベント発火
3. **行129**: `postToAll(AlterTablePreEvent(db, table, AlterTableKind.SCHEMA))` - alterTableSchemaでのPreイベント発火
4. **行138**: `postToAll(AlterTablePreEvent(db, table, AlterTableKind.STATS))` - alterTableStatsでのPreイベント発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行123-138: alterTable, alterTableSchema, alterTableStatsの各テスト。kindの値が正しく設定されていることを検証 |

### プログラム呼び出し階層図

```
SparkSession (SQL: ALTER TABLE ...)
    |
    +-- SessionCatalog.alterTable() / alterTableSchema() / alterTableStats()
           |
           +-- ExternalCatalogWithListener
                  |
                  +-- alterTable()           [行114-120]
                  |      +-- postToAll(AlterTablePreEvent(..., "table"))    [行117]
                  |      +-- delegate.alterTable()                          [行118]
                  |      +-- postToAll(AlterTableEvent(..., "table"))       [行119]
                  |
                  +-- alterTableDataSchema() [行122-126]
                  |      +-- postToAll(AlterTablePreEvent(..., "dataSchema")) [行123]
                  |      +-- delegate.alterTableDataSchema()                  [行124]
                  |      +-- postToAll(AlterTableEvent(..., "dataSchema"))    [行125]
                  |
                  +-- alterTableSchema()     [行128-132]
                  |      +-- postToAll(AlterTablePreEvent(..., "schema"))   [行129]
                  |      +-- delegate.alterTableSchema()                    [行130]
                  |      +-- postToAll(AlterTableEvent(..., "schema"))      [行131]
                  |
                  +-- alterTableStats()      [行134-141]
                         +-- postToAll(AlterTablePreEvent(..., "stats"))    [行138]
                         +-- delegate.alterTableStats()                     [行139]
                         +-- postToAll(AlterTableEvent(..., "stats"))       [行140]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

alterTable(tableDefn)    --> ExternalCatalogWithListener     --> AlterTablePreEvent
  or                             .alterTable*()                  (database, name, kind)
alterTableDataSchema()           |                                    |
  or                             v                                    v
alterTableSchema()         delegate.alterTable*()            --> AlterTableEvent
  or                       (実際のメタストア操作)                 (database, name, kind)
alterTableStats()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterTablePreEvent、AlterTableKindの定義（行127-140） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | 4つのalterTable系メソッド（行114-141） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | alterTableイベントの発火テスト（行123-138） |
