# 通知設計書 55-AlterTableEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいてテーブルの変更操作が完了した後に発火するイベント通知「AlterTableEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、テーブル変更操作の完了を外部リスナーに通知するために使用される。

### 本通知の処理概要

AlterTableEventは、外部カタログ（ExternalCatalog）上でテーブルの変更操作が正常に完了した直後に発火するイベント通知である。テーブル定義全体の変更、データスキーマの変更、スキーマの変更、統計情報の変更の4種類の操作でそれぞれ異なるkind値を伴って発火される。

**業務上の目的・背景**：テーブル変更が完了した後に、キャッシュの無効化、クエリプランの再最適化、UIの表示更新、監査ログの記録などの後続処理を実行する必要がある。AlterTableEventはkindフィールドにより変更種別を識別できるため、種別に応じた後続処理の実行が可能である。

**通知の送信タイミング**：ExternalCatalogWithListenerの以下4つのメソッドでデリゲート処理の成功後に発火される。(1) alterTable（行119、kind="table"）、(2) alterTableDataSchema（行125、kind="dataSchema"）、(3) alterTableSchema（行131、kind="schema"）、(4) alterTableStats（行140、kind="stats"）。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：変更対象テーブルが属するデータベース名（database）、テーブル名（name）、変更種別（kind）の3つのフィールドを含む。kindの値はAlterTableKind列挙型で定義されている。

**期待されるアクション**：受信リスナーはテーブル変更完了をkindフィールドで種別判別し、キャッシュの無効化、クエリプランの再生成、統計情報の反映、UIの更新などを実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
AlterTableEvent(database: String, name: String, kind: String)

例：AlterTableEvent("default", "my_table", "table")
    AlterTableEvent("default", "my_table", "dataSchema")
    AlterTableEvent("default", "my_table", "schema")
    AlterTableEvent("default", "my_table", "stats")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | テーブルが属するデータベース名 | 各alterTableメソッドの引数から取得 | Yes |
| name | 変更対象のテーブル名 | 各alterTableメソッドの引数から取得 | Yes |
| kind | 変更種別（"table", "dataSchema", "schema", "stats"のいずれか） | AlterTableKind列挙型の値 | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.alterTable() | デリゲート処理成功 | 行119でkind="table"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableDataSchema() | デリゲート処理成功 | 行125でkind="dataSchema"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableSchema() | デリゲート処理成功 | 行131でkind="schema"としてpostToAll |
| API呼び出し | ExternalCatalogWithListener.alterTableStats() | デリゲート処理成功 | 行140でkind="stats"としてpostToAll |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| デリゲート処理で例外発生 | delegate.alterTable系メソッドが例外をスローした場合、AlterTableEventは発火しない（AlterTablePreEventのみ発火） |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[alterTable系メソッド呼び出し] --> B[AlterTablePreEvent発火]
    B --> C[delegate.alterTable系メソッド実行]
    C -->|成功| D[AlterTableEvent発火 - kindに応じた値]
    C -->|例外| E[例外スロー - AlterTableEventは未発火]
    D --> F[postToAllで全リスナーに配信]
    F --> G[SparkListenerBusへ伝播]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアのテーブルメタデータ | 変更対象テーブルの存在確認・変更前情報の取得 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストアテーブルメタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | テーブル所属DB確認 | 引数で指定 |
| table_name | テーブル存在確認 | 引数で指定 |
| schema | スキーマ変更時の現行スキーマ参照 | alterTableSchema/alterTableDataSchema時 |
| statistics | 統計情報更新時の現行統計参照 | alterTableStats時 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| メタストアのテーブルメタデータ | UPDATE | テーブル定義、スキーマ、統計情報のいずれかを更新（kindに依存） |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| デリゲート処理失敗 | delegate.alterTable系メソッドが例外スロー | AlterTablePreEventのみ発火し、AlterTableEventは発火しない |
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名、テーブル名、変更種別のみが含まれ、変更内容の詳細は含まれない。
- スキーマ変更の具体的内容（追加カラム名等）はイベントから読み取れないため、機密性の高いスキーマ情報の漏洩リスクは低い。

## 備考

- AlterTableEventはテーブル変更の「後」イベント（post-event）であり、対応する「前」イベントとしてAlterTablePreEvent（No.54）が存在する。
- AlterTableKindの4つの値は、それぞれ異なるalterTableメソッドに対応している。
- テストコード ExternalCatalogEventSuite.scala 行123-138で各kind値の検証が行われている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行127-132: AlterTableKindオブジェクト、行145-148: AlterTableEventケースクラス（database, name, kindの3フィールド） |

**読解のコツ**: AlterTableEventとAlterTablePreEventは同一のフィールド構成を持つ。kindフィールドの値でどの種類のテーブル変更が行われたかを判別する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行114-141: 4つのalterTable系メソッド。各メソッドの最後でAlterTableEventをpostToAll |

**主要処理フロー**:
1. **行119**: `postToAll(AlterTableEvent(db, name, AlterTableKind.TABLE))` - alterTableでのPostイベント発火
2. **行125**: `postToAll(AlterTableEvent(db, table, AlterTableKind.DATASCHEMA))` - alterTableDataSchemaでのPostイベント発火
3. **行131**: `postToAll(AlterTableEvent(db, table, AlterTableKind.SCHEMA))` - alterTableSchemaでのPostイベント発火
4. **行140**: `postToAll(AlterTableEvent(db, table, AlterTableKind.STATS))` - alterTableStatsでのPostイベント発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行123-138: テーブル変更テスト。各kind値でPre+Postペアが発火されることを検証 |

### プログラム呼び出し階層図

```
SparkSession (SQL: ALTER TABLE ...)
    |
    +-- SessionCatalog.alterTable*()
           |
           +-- ExternalCatalogWithListener.alterTable*()
                  |
                  +-- postToAll(AlterTablePreEvent(db, name, kind))
                  +-- delegate.alterTable*()
                  +-- postToAll(AlterTableEvent(db, name, kind))  <-- 本イベント
                         |
                         +-- ExternalCatalogEventListener.onEvent()
                         +-- SparkContext.listenerBus.post()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

alterTable*(args)        --> ExternalCatalogWithListener     --> AlterTablePreEvent
                                 .alterTable*()                  (database, name, kind)
                                 |                                    |
                                 v                                    v
                           delegate.alterTable*()            --> AlterTableEvent
                           (メタストア更新)                       (database, name, kind)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | AlterTableEvent、AlterTableKindの定義（行127-148） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | 4つのalterTable系メソッド（行114-141） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | alterTableイベントの発火テスト（行123-138） |
