# 通知設計書 56-CreateFunctionPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいて関数の作成操作が実行される前に発火するイベント通知「CreateFunctionPreEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、関数作成操作の開始を外部リスナーに事前通知するために使用される。

### 本通知の処理概要

CreateFunctionPreEventは、外部カタログ（ExternalCatalog）上で関数の作成操作が実行される直前に発火するイベント通知である。ExternalCatalogWithListenerクラスのcreateFunctionメソッド内で、デリゲート先の実処理を呼び出す前にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：ユーザー定義関数（UDF）の作成はカタログの重要な変更操作であり、作成前に名前の重複チェック、権限の検証、依存リソースの確認などの前処理を実行する必要がある。CreateFunctionPreEventはこれらの前処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.createFunctionメソッドにおいて、デリゲート先のExternalCatalog.createFunctionを呼び出す前（行287）にpostToAllメソッドで発火される。関数名はCatalogFunction.identifier.funcNameから取得される（行286）。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：関数が属するデータベース名（database）と関数名（name）の2つのフィールドを含む。FunctionEventトレイトおよびDatabaseEventトレイトを継承しており、SparkListenerEventとしても扱われる。

**期待されるアクション**：受信リスナーは関数作成操作の開始を検知し、名前衝突の検証、セキュリティチェック、監査ログの事前記録などの前処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし（同期配信のため、リスナー側の例外はログ出力後に無視） |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` メソッドで登録された全てのExternalCatalogEventListenerに対して配信される。SharedState初期化時（SharedState.scala 行175）にSparkContext.listenerBusへpostするブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

本イベントはインプロセスのイベントバス配信であり、メール通知は該当しない。

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
CreateFunctionPreEvent(database: String, name: String)

例：CreateFunctionPreEvent("default", "my_udf")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | ExternalCatalogWithListener.createFunctionの引数db | Yes |
| name | 作成する関数名 | funcDefinition.identifier.funcName（行286） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.createFunction() | メソッド呼び出し | 行287でデリゲート処理前にpostToAll |
| API呼び出し | CREATE FUNCTION SQL文の実行 | SQLパーサー経由でcreateFunctionが呼ばれること | SparkSQL経由でもcreateFunction APIを通じて発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventはデリゲート処理前に無条件で発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[createFunction呼び出し] --> B[CreateFunctionPreEvent発火]
    B --> C[delegate.createFunction実行]
    C -->|成功| D[CreateFunctionEvent発火]
    C -->|例外| E[例外スロー - CreateFunctionEventは未発火]
    D --> F[終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアの関数メタデータ | 同名関数の存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストア関数メタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | 関数所属DB確認 | 引数dbで指定 |
| function_name | 関数存在確認（重複チェック） | funcDefinition.identifier.funcNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの発火時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外が発生した場合 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名と関数名のみが含まれ、関数の実装（className）やリソース情報は含まれないため、機密データの漏洩リスクは限定的である。

## 備考

- CreateFunctionPreEventは関数作成の「前」イベント（pre-event）であり、対応する「後」イベントとしてCreateFunctionEvent（No.57）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行176-182で、関数作成の正常系・異常系テストが確認されている。関数が既に存在する場合はdelegate.createFunctionが例外をスローし、CreateFunctionPreEventのみ発火する。
- 関数名はCatalogFunction.identifierのfuncNameプロパティから取得される。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行153-158: FunctionEventトレイト（DatabaseEvent継承、nameフィールド追加）、行163: CreateFunctionPreEventケースクラス |

**読解のコツ**: FunctionEventトレイトはDatabaseEventを継承しており、databaseフィールドはDatabaseEventから、nameフィールドはFunctionEventで追加される。TableEventとFunctionEventは同じくDatabaseEventを継承するが、nameの意味が異なる（テーブル名 vs 関数名）。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行285-290: createFunctionメソッド。行286でfuncNameを取得、行287でPreイベント発火、行288でデリゲート処理、行289でPostイベント発火 |

**主要処理フロー**:
1. **行286**: `val name = funcDefinition.identifier.funcName` で関数名を取得
2. **行287**: `postToAll(CreateFunctionPreEvent(db, name))` でPreイベントを発火
3. **行288**: `delegate.createFunction(db, funcDefinition)` でデリゲート先の実処理
4. **行289**: `postToAll(CreateFunctionEvent(db, name))` でPostイベント発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行164-182: 関数テスト。createFunction正常時のPre+Post発火、重複時のPreのみ発火を検証 |

### プログラム呼び出し階層図

```
SparkSession (SQL: CREATE FUNCTION ...)
    |
    +-- SessionCatalog.createFunction()
           |
           +-- ExternalCatalogWithListener.createFunction()  [行285-290]
                  |
                  +-- val name = funcDefinition.identifier.funcName  [行286]
                  +-- postToAll(CreateFunctionPreEvent)              [行287]
                  |      |
                  |      +-- ExternalCatalogEventListener.onEvent()
                  |      +-- SparkContext.listenerBus.post()
                  |
                  +-- delegate.createFunction()                      [行288]
                  +-- postToAll(CreateFunctionEvent)                  [行289]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

createFunction(db,       --> ExternalCatalogWithListener     --> CreateFunctionPreEvent
 funcDefinition)                 .createFunction()               (database, name)
                                 |                                    |
                                 v                                    v
                           delegate.createFunction()          --> CreateFunctionEvent
                           (関数メタデータ登録)                    (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | CreateFunctionPreEvent、FunctionEventの定義（行153-163） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | createFunctionメソッド（行285-290） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | createFunctionイベントの発火テスト（行164-182） |
