# 通知設計書 57-CreateFunctionEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいて関数の作成操作が完了した後に発火するイベント通知「CreateFunctionEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、関数作成操作の完了を外部リスナーに通知するために使用される。

### 本通知の処理概要

CreateFunctionEventは、外部カタログ（ExternalCatalog）上で関数の作成操作が正常に完了した直後に発火するイベント通知である。ExternalCatalogWithListenerクラスのcreateFunctionメソッド内で、デリゲート先の実処理が成功した後にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：ユーザー定義関数の作成が完了した際に、関数カタログの更新通知、UIの表示更新、監査ログの記録などの後続処理を実行する必要がある。CreateFunctionEventはこれらの後続処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.createFunctionメソッドにおいて、デリゲート先のExternalCatalog.createFunctionが正常に完了した直後（行289）にpostToAllメソッドで発火される。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録される。

**通知内容の概要**：関数が属するデータベース名（database）と関数名（name）の2つのフィールドを含む。FunctionEventトレイトおよびDatabaseEventトレイトを継承している。

**期待されるアクション**：受信リスナーは関数作成の完了を検知し、関数カタログの更新確認、UIの表示更新、監査ログの記録、依存するクエリの再コンパイルなどを実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` で登録された全ExternalCatalogEventListenerに配信。SharedState初期化時にSparkContext.listenerBusへのブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
CreateFunctionEvent(database: String, name: String)

例：CreateFunctionEvent("default", "my_udf")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | ExternalCatalogWithListener.createFunctionの引数db | Yes |
| name | 作成された関数名 | funcDefinition.identifier.funcName（行286） | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.createFunction() | デリゲート先のcreateFunctionが例外なく完了すること | 行288でdelegate.createFunctionが成功した後、行289でpostToAll |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| 同名関数が既に存在する場合 | delegate.createFunctionが例外をスローし、CreateFunctionEventは発火しない（CreateFunctionPreEventのみ発火） |
| デリゲート処理で例外発生 | PostイベントであるCreateFunctionEventは発火しない |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[createFunction呼び出し] --> B[CreateFunctionPreEvent発火]
    B --> C[delegate.createFunction実行]
    C -->|成功| D[CreateFunctionEvent発火]
    C -->|例外| E[例外スロー - CreateFunctionEventは未発火]
    D --> F[postToAllで全リスナーに配信]
    F --> G[SparkListenerBusへ伝播]
    G --> H[終了]
    E --> H
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアの関数メタデータ | 同名関数の重複確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストア関数メタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | 関数所属DB確認 | 引数dbで指定 |
| function_name | 重複確認 | funcNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| メタストアの関数メタデータ | INSERT | デリゲート先のExternalCatalog実装が関数メタデータを登録 |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| 関数重複エラー | 同名関数が既に存在する場合 | CreateFunctionPreEventのみ発火。呼び出し元に例外スロー |
| リスナー例外 | リスナーのonEvent内で例外発生 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名と関数名のみが含まれ、関数の実装クラス名（className）やリソース情報は含まれない。

## 備考

- CreateFunctionEventは関数作成の「後」イベント（post-event）であり、対応する「前」イベントとしてCreateFunctionPreEvent（No.56）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行176-182で発火動作が確認されている。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行153-158: FunctionEventトレイト、行168: CreateFunctionEventケースクラス |

**読解のコツ**: CreateFunctionEventとCreateFunctionPreEventは同一のフィールド構成（database, name）を持つ。発火タイミングのみが異なる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行285-290: createFunctionメソッド。行289がCreateFunctionEventの発火箇所 |

**主要処理フロー**:
1. **行286**: `val name = funcDefinition.identifier.funcName` で関数名取得
2. **行287**: `postToAll(CreateFunctionPreEvent(db, name))` でPreイベント発火
3. **行288**: `delegate.createFunction(db, funcDefinition)` でデリゲート処理
4. **行289**: `postToAll(CreateFunctionEvent(db, name))` でPostイベント（本イベント）発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行176-182: createFunction正常時Pre+Post発火、重複時Preのみ |

### プログラム呼び出し階層図

```
SparkSession (SQL: CREATE FUNCTION ...)
    |
    +-- SessionCatalog.createFunction()
           |
           +-- ExternalCatalogWithListener.createFunction()  [行285-290]
                  |
                  +-- postToAll(CreateFunctionPreEvent)       [行287]
                  +-- delegate.createFunction()               [行288]
                  +-- postToAll(CreateFunctionEvent)          [行289]  <-- 本イベント
                         |
                         +-- ExternalCatalogEventListener.onEvent()
                         +-- SparkContext.listenerBus.post()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

createFunction(db,       --> ExternalCatalogWithListener     --> CreateFunctionPreEvent
 funcDefinition)                 .createFunction()               (database, name)
                                 |                                    |
                                 v                                    v
                           delegate.createFunction()          --> CreateFunctionEvent
                           (関数メタデータ登録)                    (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | CreateFunctionEventの定義（行168） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | createFunctionメソッド（行285-290） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | createFunctionの発火テスト（行176-182） |
