# 通知設計書 58-DropFunctionPreEvent

## 概要

本ドキュメントは、Apache Sparkの外部カタログにおいて関数の削除操作が実行される前に発火するイベント通知「DropFunctionPreEvent」の設計仕様を記述する。本イベントは `ExternalCatalogEvent` の一種であり、関数削除操作の開始を外部リスナーに事前通知するために使用される。

### 本通知の処理概要

DropFunctionPreEventは、外部カタログ（ExternalCatalog）上で関数の削除操作が実行される直前に発火するイベント通知である。ExternalCatalogWithListenerクラスのdropFunctionメソッド内で、デリゲート先の実処理を呼び出す前にpostToAllメソッドで全リスナーに配信される。

**業務上の目的・背景**：ユーザー定義関数の削除は、その関数を利用しているクエリやビューに影響を与える可能性がある重要な操作である。削除前に依存関係の確認、影響範囲の評価、監査ログの事前記録などの前処理を実行する必要がある。DropFunctionPreEventはこれらの前処理をイベント駆動で実現するための基盤となる。

**通知の送信タイミング**：ExternalCatalogWithListener.dropFunctionメソッドにおいて、デリゲート先のExternalCatalog.dropFunctionを呼び出す前（行293）にpostToAllメソッドで発火される。

**通知の受信者**：ExternalCatalogEventListenerインタフェースを実装し、ExternalCatalogWithListenerに登録された全てのリスナーが受信する。SharedStateの初期化時にSparkContext.listenerBusへのブリッジリスナーが登録されるため、SparkListenerBus上の全リスナーにも伝播される。

**通知内容の概要**：関数が属するデータベース名（database）と関数名（name）の2つのフィールドを含む。FunctionEventトレイトおよびDatabaseEventトレイトを継承している。

**期待されるアクション**：受信リスナーは関数削除操作の開始を検知し、依存クエリの確認、影響範囲の通知、監査ログの事前記録などの前処理を実行する。

## 通知種別

アプリ内通知（Sparkイベントバス経由のインプロセスイベント配信）

## 送信仕様

### 基本情報

| 項目 | 内容 |
|-----|------|
| 送信方式 | 同期（postToAllによるリスナーバス内同期配信） |
| 優先度 | 中（通常のカタログ操作イベント） |
| リトライ | なし |

### 送信先決定ロジック

ExternalCatalogWithListenerに `addListener` で登録された全ExternalCatalogEventListenerに配信。SharedState初期化時にSparkContext.listenerBusへのブリッジリスナーが登録される。

## 通知テンプレート

### メール通知の場合

| 項目 | 内容 |
|-----|------|
| 送信元アドレス | N/A |
| 送信元名称 | N/A |
| 件名 | N/A |
| 形式 | N/A |

### 本文テンプレート

```
イベントはcase classのインスタンスとして配信される：
DropFunctionPreEvent(database: String, name: String)

例：DropFunctionPreEvent("default", "my_udf")
```

### 添付ファイル

| ファイル名 | 形式 | 条件 | 説明 |
|----------|------|------|------|
| N/A | N/A | N/A | インプロセスイベントのため添付ファイルなし |

## テンプレート変数

| 変数名 | 説明 | データ取得元 | 必須 |
|--------|------|-------------|-----|
| database | 関数が属するデータベース名 | ExternalCatalogWithListener.dropFunctionの引数db | Yes |
| name | 削除対象の関数名 | ExternalCatalogWithListener.dropFunctionの引数funcName | Yes |

## 送信トリガー・条件

### トリガー一覧

| トリガー種別 | トリガーイベント | 送信条件 | 説明 |
|------------|----------------|---------|------|
| API呼び出し | ExternalCatalogWithListener.dropFunction() | メソッド呼び出し | 行293でデリゲート処理前にpostToAll |
| API呼び出し | DROP FUNCTION SQL文の実行 | SQLパーサー経由でdropFunctionが呼ばれること | SparkSQL経由でもdropFunction APIを通じて発火 |

### 送信抑止条件

| 条件 | 説明 |
|-----|------|
| なし | PreEventはデリゲート処理前に無条件で発火される |

## 処理フロー

### 送信フロー

```mermaid
flowchart TD
    A[dropFunction呼び出し] --> B[DropFunctionPreEvent発火]
    B --> C[delegate.dropFunction実行]
    C -->|成功| D[DropFunctionEvent発火]
    C -->|例外| E[例外スロー - DropFunctionEventは未発火]
    D --> F[終了]
    E --> F
```

## データベース参照・更新仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 備考 |
|-----------|------|------|
| メタストアの関数メタデータ | 削除対象関数の存在確認 | デリゲート先で実施 |

### テーブル別参照項目詳細

#### メタストア関数メタデータ

| 参照項目（カラム名） | 用途 | 取得条件 |
|-------------------|------|---------|
| database_name | 関数所属DB確認 | 引数dbで指定 |
| function_name | 関数存在確認 | 引数funcNameで指定 |

### 更新テーブル一覧

| テーブル名 | 操作 | 概要 |
|-----------|------|------|
| N/A | N/A | PreEventの発火時点ではまだ更新は行われない |

#### 送信ログテーブル

| 操作 | 項目（カラム名） | 更新値 | 備考 |
|-----|-----------------|-------|------|
| N/A | N/A | N/A | イベントバス配信のため送信ログテーブルは存在しない |

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 対処方法 |
|----------|---------|---------|
| リスナー例外 | リスナーのonEvent内で例外発生 | ListenerBusがキャッチしてログ出力 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | N/A |
| リトライ対象エラー | N/A |

## 配信設定

### レート制限

| 項目 | 内容 |
|-----|------|
| 1分あたり上限 | 制限なし |
| 1日あたり上限 | 制限なし |

### 配信時間帯

制限なし。

## セキュリティ考慮事項

- イベントにはデータベース名と関数名のみが含まれ、関数の実装詳細は含まれない。

## 備考

- DropFunctionPreEventは関数削除の「前」イベント（pre-event）であり、対応する「後」イベントとしてDropFunctionEvent（No.59）が存在する。
- テストコード ExternalCatalogEventSuite.scala 行203-210で、関数削除の正常系・異常系テストが確認されている。関数が存在しない場合はdelegate.dropFunctionが例外をスローし、DropFunctionPreEventのみ発火する。

---

## コードリーディングガイド

本通知を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | 行153-158: FunctionEventトレイト（DatabaseEvent継承、nameフィールド追加）、行173: DropFunctionPreEventケースクラス |

**読解のコツ**: DropFunctionPreEventはFunctionEventを継承し、database（DatabaseEvent由来）とname（FunctionEvent由来）の2フィールドを持つシンプルなcase class。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | 行292-296: dropFunctionメソッド。行293でPreイベント発火、行294でデリゲート処理、行295でPostイベント発火 |

**主要処理フロー**:
1. **行293**: `postToAll(DropFunctionPreEvent(db, funcName))` でPreイベントを発火
2. **行294**: `delegate.dropFunction(db, funcName)` でデリゲート先の実処理
3. **行295**: `postToAll(DropFunctionEvent(db, funcName))` でPostイベント発火

#### Step 3: テストで動作を確認する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | 行203-210: dropFunction正常時Pre+Post発火、関数不存在時Preのみ発火 |

### プログラム呼び出し階層図

```
SparkSession (SQL: DROP FUNCTION ...)
    |
    +-- SessionCatalog.dropFunction()
           |
           +-- ExternalCatalogWithListener.dropFunction()  [行292-296]
                  |
                  +-- postToAll(DropFunctionPreEvent)       [行293]
                  |      |
                  |      +-- ExternalCatalogEventListener.onEvent()
                  |      +-- SparkContext.listenerBus.post()
                  |
                  +-- delegate.dropFunction()               [行294]
                  +-- postToAll(DropFunctionEvent)           [行295]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

dropFunction(db,         --> ExternalCatalogWithListener     --> DropFunctionPreEvent
 funcName)                       .dropFunction()                 (database, name)
                                 |                                    |
                                 v                                    v
                           delegate.dropFunction()            --> DropFunctionEvent
                           (関数メタデータ削除)                    (database, name)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| events.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/events.scala` | ソース | DropFunctionPreEventの定義（行173） |
| ExternalCatalogWithListener.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogWithListener.scala` | ソース | dropFunctionメソッド（行292-296） |
| ExternalCatalog.scala | `sql/catalyst/src/main/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalog.scala` | ソース | 外部カタログインタフェース |
| ListenerBus.scala | `core/src/main/scala/org/apache/spark/util/ListenerBus.scala` | ソース | イベント配信基盤 |
| SharedState.scala | `sql/core/src/main/scala/org/apache/spark/sql/internal/SharedState.scala` | ソース | 初期化とlistenerBus接続 |
| ExternalCatalogEventSuite.scala | `sql/catalyst/src/test/scala/org/apache/spark/sql/catalyst/catalog/ExternalCatalogEventSuite.scala` | テスト | dropFunctionの発火テスト（行203-210） |
